/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.FormEntryOutput;
import software.amazon.awssdk.services.datazone.model.FormsOutputMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssetTypeResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetAssetTypeResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetAssetTypeResponse.getter(GetAssetTypeResponse::createdAt)).setter(GetAssetTypeResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetAssetTypeResponse.getter(GetAssetTypeResponse::createdBy)).setter(GetAssetTypeResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetAssetTypeResponse.getter(GetAssetTypeResponse::description)).setter(GetAssetTypeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(GetAssetTypeResponse.getter(GetAssetTypeResponse::domainId)).setter(GetAssetTypeResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<Map<String, FormEntryOutput>> FORMS_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("formsOutput").getter(GetAssetTypeResponse.getter(GetAssetTypeResponse::formsOutput)).setter(GetAssetTypeResponse.setter(Builder::formsOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsOutput").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormEntryOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetAssetTypeResponse.getter(GetAssetTypeResponse::name)).setter(GetAssetTypeResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ORIGIN_DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originDomainId").getter(GetAssetTypeResponse.getter(GetAssetTypeResponse::originDomainId)).setter(GetAssetTypeResponse.setter(Builder::originDomainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originDomainId").build()}).build();
    private static final SdkField<String> ORIGIN_PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originProjectId").getter(GetAssetTypeResponse.getter(GetAssetTypeResponse::originProjectId)).setter(GetAssetTypeResponse.setter(Builder::originProjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originProjectId").build()}).build();
    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningProjectId").getter(GetAssetTypeResponse.getter(GetAssetTypeResponse::owningProjectId)).setter(GetAssetTypeResponse.setter(Builder::owningProjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()}).build();
    private static final SdkField<String> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revision").getter(GetAssetTypeResponse.getter(GetAssetTypeResponse::revision)).setter(GetAssetTypeResponse.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetAssetTypeResponse.getter(GetAssetTypeResponse::updatedAt)).setter(GetAssetTypeResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(GetAssetTypeResponse.getter(GetAssetTypeResponse::updatedBy)).setter(GetAssetTypeResponse.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, FORMS_OUTPUT_FIELD, NAME_FIELD, ORIGIN_DOMAIN_ID_FIELD, ORIGIN_PROJECT_ID_FIELD, OWNING_PROJECT_ID_FIELD, REVISION_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("createdBy", CREATED_BY_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("domainId", DOMAIN_ID_FIELD);
            this.put("formsOutput", FORMS_OUTPUT_FIELD);
            this.put("name", NAME_FIELD);
            this.put("originDomainId", ORIGIN_DOMAIN_ID_FIELD);
            this.put("originProjectId", ORIGIN_PROJECT_ID_FIELD);
            this.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
            this.put("revision", REVISION_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
            this.put("updatedBy", UPDATED_BY_FIELD);
        }
    });
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final String domainId;
    private final Map<String, FormEntryOutput> formsOutput;
    private final String name;
    private final String originDomainId;
    private final String originProjectId;
    private final String owningProjectId;
    private final String revision;
    private final Instant updatedAt;
    private final String updatedBy;

    private GetAssetTypeResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.formsOutput = builder.formsOutput;
        this.name = builder.name;
        this.originDomainId = builder.originDomainId;
        this.originProjectId = builder.originProjectId;
        this.owningProjectId = builder.owningProjectId;
        this.revision = builder.revision;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final boolean hasFormsOutput() {
        return this.formsOutput != null && !(this.formsOutput instanceof SdkAutoConstructMap);
    }

    public final Map<String, FormEntryOutput> formsOutput() {
        return this.formsOutput;
    }

    public final String name() {
        return this.name;
    }

    public final String originDomainId() {
        return this.originDomainId;
    }

    public final String originProjectId() {
        return this.originProjectId;
    }

    public final String owningProjectId() {
        return this.owningProjectId;
    }

    public final String revision() {
        return this.revision;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormsOutput() ? this.formsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.originDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.originProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssetTypeResponse)) {
            return false;
        }
        GetAssetTypeResponse other = (GetAssetTypeResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && this.hasFormsOutput() == other.hasFormsOutput() && Objects.equals(this.formsOutput(), other.formsOutput()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.originDomainId(), other.originDomainId()) && Objects.equals(this.originProjectId(), other.originProjectId()) && Objects.equals(this.owningProjectId(), other.owningProjectId()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy());
    }

    public final String toString() {
        return ToString.builder((String)"GetAssetTypeResponse").add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainId", (Object)this.domainId()).add("FormsOutput", this.hasFormsOutput() ? this.formsOutput() : null).add("Name", (Object)this.name()).add("OriginDomainId", (Object)this.originDomainId()).add("OriginProjectId", (Object)this.originProjectId()).add("OwningProjectId", (Object)this.owningProjectId()).add("Revision", (Object)this.revision()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "formsOutput": {
                return Optional.ofNullable(clazz.cast(this.formsOutput()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "originDomainId": {
                return Optional.ofNullable(clazz.cast(this.originDomainId()));
            }
            case "originProjectId": {
                return Optional.ofNullable(clazz.cast(this.originProjectId()));
            }
            case "owningProjectId": {
                return Optional.ofNullable(clazz.cast(this.owningProjectId()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetAssetTypeResponse, T> g) {
        return obj -> g.apply((GetAssetTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String createdBy;
        private String description;
        private String domainId;
        private Map<String, FormEntryOutput> formsOutput = DefaultSdkAutoConstructMap.getInstance();
        private String name;
        private String originDomainId;
        private String originProjectId;
        private String owningProjectId;
        private String revision;
        private Instant updatedAt;
        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssetTypeResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.domainId(model.domainId);
            this.formsOutput(model.formsOutput);
            this.name(model.name);
            this.originDomainId(model.originDomainId);
            this.originProjectId(model.originProjectId);
            this.owningProjectId(model.owningProjectId);
            this.revision(model.revision);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Map<String, FormEntryOutput.Builder> getFormsOutput() {
            Map<String, FormEntryOutput.Builder> result = FormsOutputMapCopier.copyToBuilder(this.formsOutput);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFormsOutput(Map<String, FormEntryOutput.BuilderImpl> formsOutput) {
            this.formsOutput = FormsOutputMapCopier.copyFromBuilder(formsOutput);
        }

        @Override
        public final Builder formsOutput(Map<String, FormEntryOutput> formsOutput) {
            this.formsOutput = FormsOutputMapCopier.copy(formsOutput);
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOriginDomainId() {
            return this.originDomainId;
        }

        public final void setOriginDomainId(String originDomainId) {
            this.originDomainId = originDomainId;
        }

        @Override
        public final Builder originDomainId(String originDomainId) {
            this.originDomainId = originDomainId;
            return this;
        }

        public final String getOriginProjectId() {
            return this.originProjectId;
        }

        public final void setOriginProjectId(String originProjectId) {
            this.originProjectId = originProjectId;
        }

        @Override
        public final Builder originProjectId(String originProjectId) {
            this.originProjectId = originProjectId;
            return this;
        }

        public final String getOwningProjectId() {
            return this.owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public GetAssetTypeResponse build() {
            return new GetAssetTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssetTypeResponse> {
        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder formsOutput(Map<String, FormEntryOutput> var1);

        public Builder name(String var1);

        public Builder originDomainId(String var1);

        public Builder originProjectId(String var1);

        public Builder owningProjectId(String var1);

        public Builder revision(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);
    }
}

