/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuotas;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountAttributesResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribeAccountAttributesResponse> {
    private static final SdkField<ResourceQuotas> RESOURCE_QUOTAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceQuotas").getter(DescribeAccountAttributesResponse.getter(DescribeAccountAttributesResponse::resourceQuotas)).setter(DescribeAccountAttributesResponse.setter(Builder::resourceQuotas)).constructor(ResourceQuotas::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceQuotas").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_QUOTAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourceQuotas", RESOURCE_QUOTAS_FIELD);
        }
    });
    private final ResourceQuotas resourceQuotas;

    private DescribeAccountAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceQuotas = builder.resourceQuotas;
    }

    public final ResourceQuotas resourceQuotas() {
        return this.resourceQuotas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceQuotas());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesResponse)) {
            return false;
        }
        DescribeAccountAttributesResponse other = (DescribeAccountAttributesResponse)((Object)obj);
        return Objects.equals(this.resourceQuotas(), other.resourceQuotas());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAccountAttributesResponse").add("ResourceQuotas", (Object)this.resourceQuotas()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceQuotas": {
                return Optional.ofNullable(clazz.cast(this.resourceQuotas()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountAttributesResponse, T> g) {
        return obj -> g.apply((DescribeAccountAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private ResourceQuotas resourceQuotas;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesResponse model) {
            super(model);
            this.resourceQuotas(model.resourceQuotas);
        }

        public final ResourceQuotas.Builder getResourceQuotas() {
            return this.resourceQuotas != null ? this.resourceQuotas.toBuilder() : null;
        }

        public final void setResourceQuotas(ResourceQuotas.BuilderImpl resourceQuotas) {
            this.resourceQuotas = resourceQuotas != null ? resourceQuotas.build() : null;
        }

        @Override
        public final Builder resourceQuotas(ResourceQuotas resourceQuotas) {
            this.resourceQuotas = resourceQuotas;
            return this;
        }

        @Override
        public DescribeAccountAttributesResponse build() {
            return new DescribeAccountAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccountAttributesResponse> {
        public Builder resourceQuotas(ResourceQuotas var1);

        default public Builder resourceQuotas(Consumer<ResourceQuotas.Builder> resourceQuotas) {
            return this.resourceQuotas((ResourceQuotas)((ResourceQuotas.Builder)ResourceQuotas.builder().applyMutation(resourceQuotas)).build());
        }
    }
}

