/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to create an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<CreateApplicationRequest.Builder, CreateApplicationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(CreateApplicationRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateApplicationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ApplicationResourceLifecycleConfig> RESOURCE_LIFECYCLE_CONFIG_FIELD = SdkField
            .<ApplicationResourceLifecycleConfig> builder(MarshallingType.SDK_POJO).memberName("ResourceLifecycleConfig")
            .getter(getter(CreateApplicationRequest::resourceLifecycleConfig)).setter(setter(Builder::resourceLifecycleConfig))
            .constructor(ApplicationResourceLifecycleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLifecycleConfig").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateApplicationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            DESCRIPTION_FIELD, RESOURCE_LIFECYCLE_CONFIG_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationName;

    private final String description;

    private final ApplicationResourceLifecycleConfig resourceLifecycleConfig;

    private final List<Tag> tags;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.description = builder.description;
        this.resourceLifecycleConfig = builder.resourceLifecycleConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the application. Must be unique within your account.
     * </p>
     * 
     * @return The name of the application. Must be unique within your account.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Your description of the application.
     * </p>
     * 
     * @return Your description of the application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies an application resource lifecycle configuration to prevent your application from accumulating too many
     * versions.
     * </p>
     * 
     * @return Specifies an application resource lifecycle configuration to prevent your application from accumulating
     *         too many versions.
     */
    public final ApplicationResourceLifecycleConfig resourceLifecycleConfig() {
        return resourceLifecycleConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the tags applied to the application.
     * </p>
     * <p>
     * Elastic Beanstalk applies these tags only to the application. Environments that you create in the application
     * don't inherit the tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies the tags applied to the application.</p>
     *         <p>
     *         Elastic Beanstalk applies these tags only to the application. Environments that you create in the
     *         application don't inherit the tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(resourceLifecycleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName()) && Objects.equals(description(), other.description())
                && Objects.equals(resourceLifecycleConfig(), other.resourceLifecycleConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationRequest").add("ApplicationName", applicationName())
                .add("Description", description()).add("ResourceLifecycleConfig", resourceLifecycleConfig())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ResourceLifecycleConfig":
            return Optional.ofNullable(clazz.cast(resourceLifecycleConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationName", APPLICATION_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ResourceLifecycleConfig", RESOURCE_LIFECYCLE_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateApplicationRequest> {
        /**
         * <p>
         * The name of the application. Must be unique within your account.
         * </p>
         * 
         * @param applicationName
         *        The name of the application. Must be unique within your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Your description of the application.
         * </p>
         * 
         * @param description
         *        Your description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies an application resource lifecycle configuration to prevent your application from accumulating too
         * many versions.
         * </p>
         * 
         * @param resourceLifecycleConfig
         *        Specifies an application resource lifecycle configuration to prevent your application from
         *        accumulating too many versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig);

        /**
         * <p>
         * Specifies an application resource lifecycle configuration to prevent your application from accumulating too
         * many versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ApplicationResourceLifecycleConfig.Builder} avoiding the need to create one manually via
         * {@link ApplicationResourceLifecycleConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationResourceLifecycleConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceLifecycleConfig(ApplicationResourceLifecycleConfig)}.
         * 
         * @param resourceLifecycleConfig
         *        a consumer that will call methods on {@link ApplicationResourceLifecycleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceLifecycleConfig(ApplicationResourceLifecycleConfig)
         */
        default Builder resourceLifecycleConfig(Consumer<ApplicationResourceLifecycleConfig.Builder> resourceLifecycleConfig) {
            return resourceLifecycleConfig(ApplicationResourceLifecycleConfig.builder().applyMutation(resourceLifecycleConfig)
                    .build());
        }

        /**
         * <p>
         * Specifies the tags applied to the application.
         * </p>
         * <p>
         * Elastic Beanstalk applies these tags only to the application. Environments that you create in the application
         * don't inherit the tags.
         * </p>
         * 
         * @param tags
         *        Specifies the tags applied to the application.</p>
         *        <p>
         *        Elastic Beanstalk applies these tags only to the application. Environments that you create in the
         *        application don't inherit the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Specifies the tags applied to the application.
         * </p>
         * <p>
         * Elastic Beanstalk applies these tags only to the application. Environments that you create in the application
         * don't inherit the tags.
         * </p>
         * 
         * @param tags
         *        Specifies the tags applied to the application.</p>
         *        <p>
         *        Elastic Beanstalk applies these tags only to the application. Environments that you create in the
         *        application don't inherit the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Specifies the tags applied to the application.
         * </p>
         * <p>
         * Elastic Beanstalk applies these tags only to the application. Environments that you create in the application
         * don't inherit the tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.elasticbeanstalk.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticbeanstalk.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String description;

        private ApplicationResourceLifecycleConfig resourceLifecycleConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            applicationName(model.applicationName);
            description(model.description);
            resourceLifecycleConfig(model.resourceLifecycleConfig);
            tags(model.tags);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ApplicationResourceLifecycleConfig.Builder getResourceLifecycleConfig() {
            return resourceLifecycleConfig != null ? resourceLifecycleConfig.toBuilder() : null;
        }

        public final void setResourceLifecycleConfig(ApplicationResourceLifecycleConfig.BuilderImpl resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig != null ? resourceLifecycleConfig.build() : null;
        }

        @Override
        public final Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
