/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.DatabaseColumnIncludeOrExcludeListCopier;
import software.amazon.awssdk.services.firehose.model.DatabaseColumnList;
import software.amazon.awssdk.services.firehose.model.DatabaseList;
import software.amazon.awssdk.services.firehose.model.DatabaseSnapshotInfo;
import software.amazon.awssdk.services.firehose.model.DatabaseSnapshotInfoListCopier;
import software.amazon.awssdk.services.firehose.model.DatabaseSourceAuthenticationConfiguration;
import software.amazon.awssdk.services.firehose.model.DatabaseSourceVPCConfiguration;
import software.amazon.awssdk.services.firehose.model.DatabaseTableList;
import software.amazon.awssdk.services.firehose.model.DatabaseType;
import software.amazon.awssdk.services.firehose.model.SSLMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatabaseSourceDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatabaseSourceDescription> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DatabaseSourceDescription.getter(DatabaseSourceDescription::typeAsString)).setter(DatabaseSourceDescription.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(DatabaseSourceDescription.getter(DatabaseSourceDescription::endpoint)).setter(DatabaseSourceDescription.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(DatabaseSourceDescription.getter(DatabaseSourceDescription::port)).setter(DatabaseSourceDescription.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> SSL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SSLMode").getter(DatabaseSourceDescription.getter(DatabaseSourceDescription::sslModeAsString)).setter(DatabaseSourceDescription.setter(Builder::sslMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSLMode").build()}).build();
    private static final SdkField<DatabaseList> DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Databases").getter(DatabaseSourceDescription.getter(DatabaseSourceDescription::databases)).setter(DatabaseSourceDescription.setter(Builder::databases)).constructor(DatabaseList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Databases").build()}).build();
    private static final SdkField<DatabaseTableList> TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tables").getter(DatabaseSourceDescription.getter(DatabaseSourceDescription::tables)).setter(DatabaseSourceDescription.setter(Builder::tables)).constructor(DatabaseTableList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tables").build()}).build();
    private static final SdkField<DatabaseColumnList> COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Columns").getter(DatabaseSourceDescription.getter(DatabaseSourceDescription::columns)).setter(DatabaseSourceDescription.setter(Builder::columns)).constructor(DatabaseColumnList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build()}).build();
    private static final SdkField<List<String>> SURROGATE_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SurrogateKeys").getter(DatabaseSourceDescription.getter(DatabaseSourceDescription::surrogateKeys)).setter(DatabaseSourceDescription.setter(Builder::surrogateKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SurrogateKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SNAPSHOT_WATERMARK_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotWatermarkTable").getter(DatabaseSourceDescription.getter(DatabaseSourceDescription::snapshotWatermarkTable)).setter(DatabaseSourceDescription.setter(Builder::snapshotWatermarkTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWatermarkTable").build()}).build();
    private static final SdkField<List<DatabaseSnapshotInfo>> SNAPSHOT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnapshotInfo").getter(DatabaseSourceDescription.getter(DatabaseSourceDescription::snapshotInfo)).setter(DatabaseSourceDescription.setter(Builder::snapshotInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatabaseSnapshotInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DatabaseSourceAuthenticationConfiguration> DATABASE_SOURCE_AUTHENTICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatabaseSourceAuthenticationConfiguration").getter(DatabaseSourceDescription.getter(DatabaseSourceDescription::databaseSourceAuthenticationConfiguration)).setter(DatabaseSourceDescription.setter(Builder::databaseSourceAuthenticationConfiguration)).constructor(DatabaseSourceAuthenticationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseSourceAuthenticationConfiguration").build()}).build();
    private static final SdkField<DatabaseSourceVPCConfiguration> DATABASE_SOURCE_VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatabaseSourceVPCConfiguration").getter(DatabaseSourceDescription.getter(DatabaseSourceDescription::databaseSourceVPCConfiguration)).setter(DatabaseSourceDescription.setter(Builder::databaseSourceVPCConfiguration)).constructor(DatabaseSourceVPCConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseSourceVPCConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ENDPOINT_FIELD, PORT_FIELD, SSL_MODE_FIELD, DATABASES_FIELD, TABLES_FIELD, COLUMNS_FIELD, SURROGATE_KEYS_FIELD, SNAPSHOT_WATERMARK_TABLE_FIELD, SNAPSHOT_INFO_FIELD, DATABASE_SOURCE_AUTHENTICATION_CONFIGURATION_FIELD, DATABASE_SOURCE_VPC_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Type", TYPE_FIELD);
            this.put("Endpoint", ENDPOINT_FIELD);
            this.put("Port", PORT_FIELD);
            this.put("SSLMode", SSL_MODE_FIELD);
            this.put("Databases", DATABASES_FIELD);
            this.put("Tables", TABLES_FIELD);
            this.put("Columns", COLUMNS_FIELD);
            this.put("SurrogateKeys", SURROGATE_KEYS_FIELD);
            this.put("SnapshotWatermarkTable", SNAPSHOT_WATERMARK_TABLE_FIELD);
            this.put("SnapshotInfo", SNAPSHOT_INFO_FIELD);
            this.put("DatabaseSourceAuthenticationConfiguration", DATABASE_SOURCE_AUTHENTICATION_CONFIGURATION_FIELD);
            this.put("DatabaseSourceVPCConfiguration", DATABASE_SOURCE_VPC_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String endpoint;
    private final Integer port;
    private final String sslMode;
    private final DatabaseList databases;
    private final DatabaseTableList tables;
    private final DatabaseColumnList columns;
    private final List<String> surrogateKeys;
    private final String snapshotWatermarkTable;
    private final List<DatabaseSnapshotInfo> snapshotInfo;
    private final DatabaseSourceAuthenticationConfiguration databaseSourceAuthenticationConfiguration;
    private final DatabaseSourceVPCConfiguration databaseSourceVPCConfiguration;

    private DatabaseSourceDescription(BuilderImpl builder) {
        this.type = builder.type;
        this.endpoint = builder.endpoint;
        this.port = builder.port;
        this.sslMode = builder.sslMode;
        this.databases = builder.databases;
        this.tables = builder.tables;
        this.columns = builder.columns;
        this.surrogateKeys = builder.surrogateKeys;
        this.snapshotWatermarkTable = builder.snapshotWatermarkTable;
        this.snapshotInfo = builder.snapshotInfo;
        this.databaseSourceAuthenticationConfiguration = builder.databaseSourceAuthenticationConfiguration;
        this.databaseSourceVPCConfiguration = builder.databaseSourceVPCConfiguration;
    }

    public final DatabaseType type() {
        return DatabaseType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final Integer port() {
        return this.port;
    }

    public final SSLMode sslMode() {
        return SSLMode.fromValue(this.sslMode);
    }

    public final String sslModeAsString() {
        return this.sslMode;
    }

    public final DatabaseList databases() {
        return this.databases;
    }

    public final DatabaseTableList tables() {
        return this.tables;
    }

    public final DatabaseColumnList columns() {
        return this.columns;
    }

    public final boolean hasSurrogateKeys() {
        return this.surrogateKeys != null && !(this.surrogateKeys instanceof SdkAutoConstructList);
    }

    public final List<String> surrogateKeys() {
        return this.surrogateKeys;
    }

    public final String snapshotWatermarkTable() {
        return this.snapshotWatermarkTable;
    }

    public final boolean hasSnapshotInfo() {
        return this.snapshotInfo != null && !(this.snapshotInfo instanceof SdkAutoConstructList);
    }

    public final List<DatabaseSnapshotInfo> snapshotInfo() {
        return this.snapshotInfo;
    }

    public final DatabaseSourceAuthenticationConfiguration databaseSourceAuthenticationConfiguration() {
        return this.databaseSourceAuthenticationConfiguration;
    }

    public final DatabaseSourceVPCConfiguration databaseSourceVPCConfiguration() {
        return this.databaseSourceVPCConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.databases());
        hashCode = 31 * hashCode + Objects.hashCode(this.tables());
        hashCode = 31 * hashCode + Objects.hashCode(this.columns());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSurrogateKeys() ? this.surrogateKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWatermarkTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshotInfo() ? this.snapshotInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseSourceAuthenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseSourceVPCConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseSourceDescription)) {
            return false;
        }
        DatabaseSourceDescription other = (DatabaseSourceDescription)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.sslModeAsString(), other.sslModeAsString()) && Objects.equals(this.databases(), other.databases()) && Objects.equals(this.tables(), other.tables()) && Objects.equals(this.columns(), other.columns()) && this.hasSurrogateKeys() == other.hasSurrogateKeys() && Objects.equals(this.surrogateKeys(), other.surrogateKeys()) && Objects.equals(this.snapshotWatermarkTable(), other.snapshotWatermarkTable()) && this.hasSnapshotInfo() == other.hasSnapshotInfo() && Objects.equals(this.snapshotInfo(), other.snapshotInfo()) && Objects.equals(this.databaseSourceAuthenticationConfiguration(), other.databaseSourceAuthenticationConfiguration()) && Objects.equals(this.databaseSourceVPCConfiguration(), other.databaseSourceVPCConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DatabaseSourceDescription").add("Type", (Object)this.typeAsString()).add("Endpoint", (Object)this.endpoint()).add("Port", (Object)this.port()).add("SSLMode", (Object)this.sslModeAsString()).add("Databases", (Object)this.databases()).add("Tables", (Object)this.tables()).add("Columns", (Object)this.columns()).add("SurrogateKeys", this.hasSurrogateKeys() ? this.surrogateKeys() : null).add("SnapshotWatermarkTable", (Object)this.snapshotWatermarkTable()).add("SnapshotInfo", this.hasSnapshotInfo() ? this.snapshotInfo() : null).add("DatabaseSourceAuthenticationConfiguration", (Object)this.databaseSourceAuthenticationConfiguration()).add("DatabaseSourceVPCConfiguration", (Object)this.databaseSourceVPCConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "SSLMode": {
                return Optional.ofNullable(clazz.cast(this.sslModeAsString()));
            }
            case "Databases": {
                return Optional.ofNullable(clazz.cast(this.databases()));
            }
            case "Tables": {
                return Optional.ofNullable(clazz.cast(this.tables()));
            }
            case "Columns": {
                return Optional.ofNullable(clazz.cast(this.columns()));
            }
            case "SurrogateKeys": {
                return Optional.ofNullable(clazz.cast(this.surrogateKeys()));
            }
            case "SnapshotWatermarkTable": {
                return Optional.ofNullable(clazz.cast(this.snapshotWatermarkTable()));
            }
            case "SnapshotInfo": {
                return Optional.ofNullable(clazz.cast(this.snapshotInfo()));
            }
            case "DatabaseSourceAuthenticationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.databaseSourceAuthenticationConfiguration()));
            }
            case "DatabaseSourceVPCConfiguration": {
                return Optional.ofNullable(clazz.cast(this.databaseSourceVPCConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatabaseSourceDescription, T> g) {
        return obj -> g.apply((DatabaseSourceDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String endpoint;
        private Integer port;
        private String sslMode;
        private DatabaseList databases;
        private DatabaseTableList tables;
        private DatabaseColumnList columns;
        private List<String> surrogateKeys = DefaultSdkAutoConstructList.getInstance();
        private String snapshotWatermarkTable;
        private List<DatabaseSnapshotInfo> snapshotInfo = DefaultSdkAutoConstructList.getInstance();
        private DatabaseSourceAuthenticationConfiguration databaseSourceAuthenticationConfiguration;
        private DatabaseSourceVPCConfiguration databaseSourceVPCConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseSourceDescription model) {
            this.type(model.type);
            this.endpoint(model.endpoint);
            this.port(model.port);
            this.sslMode(model.sslMode);
            this.databases(model.databases);
            this.tables(model.tables);
            this.columns(model.columns);
            this.surrogateKeys(model.surrogateKeys);
            this.snapshotWatermarkTable(model.snapshotWatermarkTable);
            this.snapshotInfo(model.snapshotInfo);
            this.databaseSourceAuthenticationConfiguration(model.databaseSourceAuthenticationConfiguration);
            this.databaseSourceVPCConfiguration(model.databaseSourceVPCConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DatabaseType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getSslMode() {
            return this.sslMode;
        }

        public final void setSslMode(String sslMode) {
            this.sslMode = sslMode;
        }

        @Override
        public final Builder sslMode(String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        @Override
        public final Builder sslMode(SSLMode sslMode) {
            this.sslMode(sslMode == null ? null : sslMode.toString());
            return this;
        }

        public final DatabaseList.Builder getDatabases() {
            return this.databases != null ? this.databases.toBuilder() : null;
        }

        public final void setDatabases(DatabaseList.BuilderImpl databases) {
            this.databases = databases != null ? databases.build() : null;
        }

        @Override
        public final Builder databases(DatabaseList databases) {
            this.databases = databases;
            return this;
        }

        public final DatabaseTableList.Builder getTables() {
            return this.tables != null ? this.tables.toBuilder() : null;
        }

        public final void setTables(DatabaseTableList.BuilderImpl tables) {
            this.tables = tables != null ? tables.build() : null;
        }

        @Override
        public final Builder tables(DatabaseTableList tables) {
            this.tables = tables;
            return this;
        }

        public final DatabaseColumnList.Builder getColumns() {
            return this.columns != null ? this.columns.toBuilder() : null;
        }

        public final void setColumns(DatabaseColumnList.BuilderImpl columns) {
            this.columns = columns != null ? columns.build() : null;
        }

        @Override
        public final Builder columns(DatabaseColumnList columns) {
            this.columns = columns;
            return this;
        }

        public final Collection<String> getSurrogateKeys() {
            if (this.surrogateKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.surrogateKeys;
        }

        public final void setSurrogateKeys(Collection<String> surrogateKeys) {
            this.surrogateKeys = DatabaseColumnIncludeOrExcludeListCopier.copy(surrogateKeys);
        }

        @Override
        public final Builder surrogateKeys(Collection<String> surrogateKeys) {
            this.surrogateKeys = DatabaseColumnIncludeOrExcludeListCopier.copy(surrogateKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder surrogateKeys(String ... surrogateKeys) {
            this.surrogateKeys(Arrays.asList(surrogateKeys));
            return this;
        }

        public final String getSnapshotWatermarkTable() {
            return this.snapshotWatermarkTable;
        }

        public final void setSnapshotWatermarkTable(String snapshotWatermarkTable) {
            this.snapshotWatermarkTable = snapshotWatermarkTable;
        }

        @Override
        public final Builder snapshotWatermarkTable(String snapshotWatermarkTable) {
            this.snapshotWatermarkTable = snapshotWatermarkTable;
            return this;
        }

        public final List<DatabaseSnapshotInfo.Builder> getSnapshotInfo() {
            List<DatabaseSnapshotInfo.Builder> result = DatabaseSnapshotInfoListCopier.copyToBuilder(this.snapshotInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshotInfo(Collection<DatabaseSnapshotInfo.BuilderImpl> snapshotInfo) {
            this.snapshotInfo = DatabaseSnapshotInfoListCopier.copyFromBuilder(snapshotInfo);
        }

        @Override
        public final Builder snapshotInfo(Collection<DatabaseSnapshotInfo> snapshotInfo) {
            this.snapshotInfo = DatabaseSnapshotInfoListCopier.copy(snapshotInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotInfo(DatabaseSnapshotInfo ... snapshotInfo) {
            this.snapshotInfo(Arrays.asList(snapshotInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotInfo(Consumer<DatabaseSnapshotInfo.Builder> ... snapshotInfo) {
            this.snapshotInfo(Stream.of(snapshotInfo).map(c -> (DatabaseSnapshotInfo)((DatabaseSnapshotInfo.Builder)DatabaseSnapshotInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DatabaseSourceAuthenticationConfiguration.Builder getDatabaseSourceAuthenticationConfiguration() {
            return this.databaseSourceAuthenticationConfiguration != null ? this.databaseSourceAuthenticationConfiguration.toBuilder() : null;
        }

        public final void setDatabaseSourceAuthenticationConfiguration(DatabaseSourceAuthenticationConfiguration.BuilderImpl databaseSourceAuthenticationConfiguration) {
            this.databaseSourceAuthenticationConfiguration = databaseSourceAuthenticationConfiguration != null ? databaseSourceAuthenticationConfiguration.build() : null;
        }

        @Override
        public final Builder databaseSourceAuthenticationConfiguration(DatabaseSourceAuthenticationConfiguration databaseSourceAuthenticationConfiguration) {
            this.databaseSourceAuthenticationConfiguration = databaseSourceAuthenticationConfiguration;
            return this;
        }

        public final DatabaseSourceVPCConfiguration.Builder getDatabaseSourceVPCConfiguration() {
            return this.databaseSourceVPCConfiguration != null ? this.databaseSourceVPCConfiguration.toBuilder() : null;
        }

        public final void setDatabaseSourceVPCConfiguration(DatabaseSourceVPCConfiguration.BuilderImpl databaseSourceVPCConfiguration) {
            this.databaseSourceVPCConfiguration = databaseSourceVPCConfiguration != null ? databaseSourceVPCConfiguration.build() : null;
        }

        @Override
        public final Builder databaseSourceVPCConfiguration(DatabaseSourceVPCConfiguration databaseSourceVPCConfiguration) {
            this.databaseSourceVPCConfiguration = databaseSourceVPCConfiguration;
            return this;
        }

        public DatabaseSourceDescription build() {
            return new DatabaseSourceDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatabaseSourceDescription> {
        public Builder type(String var1);

        public Builder type(DatabaseType var1);

        public Builder endpoint(String var1);

        public Builder port(Integer var1);

        public Builder sslMode(String var1);

        public Builder sslMode(SSLMode var1);

        public Builder databases(DatabaseList var1);

        default public Builder databases(Consumer<DatabaseList.Builder> databases) {
            return this.databases((DatabaseList)((DatabaseList.Builder)DatabaseList.builder().applyMutation(databases)).build());
        }

        public Builder tables(DatabaseTableList var1);

        default public Builder tables(Consumer<DatabaseTableList.Builder> tables) {
            return this.tables((DatabaseTableList)((DatabaseTableList.Builder)DatabaseTableList.builder().applyMutation(tables)).build());
        }

        public Builder columns(DatabaseColumnList var1);

        default public Builder columns(Consumer<DatabaseColumnList.Builder> columns) {
            return this.columns((DatabaseColumnList)((DatabaseColumnList.Builder)DatabaseColumnList.builder().applyMutation(columns)).build());
        }

        public Builder surrogateKeys(Collection<String> var1);

        public Builder surrogateKeys(String ... var1);

        public Builder snapshotWatermarkTable(String var1);

        public Builder snapshotInfo(Collection<DatabaseSnapshotInfo> var1);

        public Builder snapshotInfo(DatabaseSnapshotInfo ... var1);

        public Builder snapshotInfo(Consumer<DatabaseSnapshotInfo.Builder> ... var1);

        public Builder databaseSourceAuthenticationConfiguration(DatabaseSourceAuthenticationConfiguration var1);

        default public Builder databaseSourceAuthenticationConfiguration(Consumer<DatabaseSourceAuthenticationConfiguration.Builder> databaseSourceAuthenticationConfiguration) {
            return this.databaseSourceAuthenticationConfiguration((DatabaseSourceAuthenticationConfiguration)((DatabaseSourceAuthenticationConfiguration.Builder)DatabaseSourceAuthenticationConfiguration.builder().applyMutation(databaseSourceAuthenticationConfiguration)).build());
        }

        public Builder databaseSourceVPCConfiguration(DatabaseSourceVPCConfiguration var1);

        default public Builder databaseSourceVPCConfiguration(Consumer<DatabaseSourceVPCConfiguration.Builder> databaseSourceVPCConfiguration) {
            return this.databaseSourceVPCConfiguration((DatabaseSourceVPCConfiguration)((DatabaseSourceVPCConfiguration.Builder)DatabaseSourceVPCConfiguration.builder().applyMutation(databaseSourceVPCConfiguration)).build());
        }
    }
}

