/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the VPC of the Amazon OpenSearch Service destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcConfigurationDescription.Builder, VpcConfigurationDescription> {
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(VpcConfigurationDescription::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(VpcConfigurationDescription::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(VpcConfigurationDescription::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(VpcConfigurationDescription::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDS_FIELD,
            ROLE_ARN_FIELD, SECURITY_GROUP_IDS_FIELD, VPC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> subnetIds;

    private final String roleARN;

    private final List<String> securityGroupIds;

    private final String vpcId;

    private VpcConfigurationDescription(BuilderImpl builder) {
        this.subnetIds = builder.subnetIds;
        this.roleARN = builder.roleARN;
        this.securityGroupIds = builder.securityGroupIds;
        this.vpcId = builder.vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the subnets that Firehose uses to create ENIs in the VPC of the Amazon OpenSearch Service destination.
     * Make sure that the routing tables and inbound and outbound rules allow traffic to flow from the subnets whose IDs
     * are specified here to the subnets that have the destination Amazon OpenSearch Service endpoints. Firehose creates
     * at least one ENI in each of the subnets that are specified here. Do not delete or modify these ENIs.
     * </p>
     * <p>
     * The number of ENIs that Firehose creates in the subnets specified here scales up and down automatically based on
     * throughput. To enable Firehose to scale up the number of ENIs to match throughput, ensure that you have
     * sufficient quota. To help you calculate the quota you need, assume that Firehose can create up to three ENIs for
     * this Firehose stream for each of the subnets specified here. For more information about ENI quota, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network Interfaces
     * </a> in the Amazon VPC Quotas topic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The IDs of the subnets that Firehose uses to create ENIs in the VPC of the Amazon OpenSearch Service
     *         destination. Make sure that the routing tables and inbound and outbound rules allow traffic to flow from
     *         the subnets whose IDs are specified here to the subnets that have the destination Amazon OpenSearch
     *         Service endpoints. Firehose creates at least one ENI in each of the subnets that are specified here. Do
     *         not delete or modify these ENIs.</p>
     *         <p>
     *         The number of ENIs that Firehose creates in the subnets specified here scales up and down automatically
     *         based on throughput. To enable Firehose to scale up the number of ENIs to match throughput, ensure that
     *         you have sufficient quota. To help you calculate the quota you need, assume that Firehose can create up
     *         to three ENIs for this Firehose stream for each of the subnets specified here. For more information about
     *         ENI quota, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network
     *         Interfaces </a> in the Amazon VPC Quotas topic.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The ARN of the IAM role that the Firehose stream uses to create endpoints in the destination VPC. You can use
     * your existing Firehose delivery role or you can specify a new role. In either case, make sure that the role
     * trusts the Firehose service principal and that it grants the following permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ec2:DescribeVpcs</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:DescribeVpcAttribute</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:DescribeSubnets</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:DescribeSecurityGroups</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:DescribeNetworkInterfaces</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:CreateNetworkInterface</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:CreateNetworkInterfacePermission</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:DeleteNetworkInterface</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you revoke these permissions after you create the Firehose stream, Firehose can't scale out by creating more
     * ENIs when necessary. You might therefore see a degradation in performance.
     * </p>
     * 
     * @return The ARN of the IAM role that the Firehose stream uses to create endpoints in the destination VPC. You can
     *         use your existing Firehose delivery role or you can specify a new role. In either case, make sure that
     *         the role trusts the Firehose service principal and that it grants the following permissions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ec2:DescribeVpcs</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ec2:DescribeVpcAttribute</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ec2:DescribeSubnets</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ec2:DescribeSecurityGroups</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ec2:DescribeNetworkInterfaces</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ec2:CreateNetworkInterface</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ec2:CreateNetworkInterfacePermission</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ec2:DeleteNetworkInterface</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you revoke these permissions after you create the Firehose stream, Firehose can't scale out by
     *         creating more ENIs when necessary. You might therefore see a degradation in performance.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups that Firehose uses when it creates ENIs in the VPC of the Amazon OpenSearch
     * Service destination. You can use the same security group that the Amazon ES domain uses or different ones. If you
     * specify different security groups, ensure that they allow outbound HTTPS traffic to the Amazon OpenSearch Service
     * domain's security group. Also ensure that the Amazon OpenSearch Service domain's security group allows HTTPS
     * traffic from the security groups specified here. If you use the same security group for both your Firehose stream
     * and the Amazon OpenSearch Service domain, make sure the security group inbound rule allows HTTPS traffic. For
     * more information about security group rules, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security group
     * rules</a> in the Amazon VPC documentation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The IDs of the security groups that Firehose uses when it creates ENIs in the VPC of the Amazon
     *         OpenSearch Service destination. You can use the same security group that the Amazon ES domain uses or
     *         different ones. If you specify different security groups, ensure that they allow outbound HTTPS traffic
     *         to the Amazon OpenSearch Service domain's security group. Also ensure that the Amazon OpenSearch Service
     *         domain's security group allows HTTPS traffic from the security groups specified here. If you use the same
     *         security group for both your Firehose stream and the Amazon OpenSearch Service domain, make sure the
     *         security group inbound rule allows HTTPS traffic. For more information about security group rules, see <a
     *         href
     *         ="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security
     *         group rules</a> in the Amazon VPC documentation.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The ID of the Amazon OpenSearch Service destination's VPC.
     * </p>
     * 
     * @return The ID of the Amazon OpenSearch Service destination's VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfigurationDescription)) {
            return false;
        }
        VpcConfigurationDescription other = (VpcConfigurationDescription) obj;
        return hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(roleARN(), other.roleARN()) && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcConfigurationDescription").add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("RoleARN", roleARN()).add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcConfigurationDescription, T> g) {
        return obj -> g.apply((VpcConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConfigurationDescription> {
        /**
         * <p>
         * The IDs of the subnets that Firehose uses to create ENIs in the VPC of the Amazon OpenSearch Service
         * destination. Make sure that the routing tables and inbound and outbound rules allow traffic to flow from the
         * subnets whose IDs are specified here to the subnets that have the destination Amazon OpenSearch Service
         * endpoints. Firehose creates at least one ENI in each of the subnets that are specified here. Do not delete or
         * modify these ENIs.
         * </p>
         * <p>
         * The number of ENIs that Firehose creates in the subnets specified here scales up and down automatically based
         * on throughput. To enable Firehose to scale up the number of ENIs to match throughput, ensure that you have
         * sufficient quota. To help you calculate the quota you need, assume that Firehose can create up to three ENIs
         * for this Firehose stream for each of the subnets specified here. For more information about ENI quota, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network
         * Interfaces </a> in the Amazon VPC Quotas topic.
         * </p>
         * 
         * @param subnetIds
         *        The IDs of the subnets that Firehose uses to create ENIs in the VPC of the Amazon OpenSearch Service
         *        destination. Make sure that the routing tables and inbound and outbound rules allow traffic to flow
         *        from the subnets whose IDs are specified here to the subnets that have the destination Amazon
         *        OpenSearch Service endpoints. Firehose creates at least one ENI in each of the subnets that are
         *        specified here. Do not delete or modify these ENIs.</p>
         *        <p>
         *        The number of ENIs that Firehose creates in the subnets specified here scales up and down
         *        automatically based on throughput. To enable Firehose to scale up the number of ENIs to match
         *        throughput, ensure that you have sufficient quota. To help you calculate the quota you need, assume
         *        that Firehose can create up to three ENIs for this Firehose stream for each of the subnets specified
         *        here. For more information about ENI quota, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network
         *        Interfaces </a> in the Amazon VPC Quotas topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The IDs of the subnets that Firehose uses to create ENIs in the VPC of the Amazon OpenSearch Service
         * destination. Make sure that the routing tables and inbound and outbound rules allow traffic to flow from the
         * subnets whose IDs are specified here to the subnets that have the destination Amazon OpenSearch Service
         * endpoints. Firehose creates at least one ENI in each of the subnets that are specified here. Do not delete or
         * modify these ENIs.
         * </p>
         * <p>
         * The number of ENIs that Firehose creates in the subnets specified here scales up and down automatically based
         * on throughput. To enable Firehose to scale up the number of ENIs to match throughput, ensure that you have
         * sufficient quota. To help you calculate the quota you need, assume that Firehose can create up to three ENIs
         * for this Firehose stream for each of the subnets specified here. For more information about ENI quota, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network
         * Interfaces </a> in the Amazon VPC Quotas topic.
         * </p>
         * 
         * @param subnetIds
         *        The IDs of the subnets that Firehose uses to create ENIs in the VPC of the Amazon OpenSearch Service
         *        destination. Make sure that the routing tables and inbound and outbound rules allow traffic to flow
         *        from the subnets whose IDs are specified here to the subnets that have the destination Amazon
         *        OpenSearch Service endpoints. Firehose creates at least one ENI in each of the subnets that are
         *        specified here. Do not delete or modify these ENIs.</p>
         *        <p>
         *        The number of ENIs that Firehose creates in the subnets specified here scales up and down
         *        automatically based on throughput. To enable Firehose to scale up the number of ENIs to match
         *        throughput, ensure that you have sufficient quota. To help you calculate the quota you need, assume
         *        that Firehose can create up to three ENIs for this Firehose stream for each of the subnets specified
         *        here. For more information about ENI quota, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network
         *        Interfaces </a> in the Amazon VPC Quotas topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The ARN of the IAM role that the Firehose stream uses to create endpoints in the destination VPC. You can use
         * your existing Firehose delivery role or you can specify a new role. In either case, make sure that the role
         * trusts the Firehose service principal and that it grants the following permissions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ec2:DescribeVpcs</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ec2:DescribeVpcAttribute</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ec2:DescribeSubnets</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ec2:DescribeSecurityGroups</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ec2:DescribeNetworkInterfaces</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ec2:CreateNetworkInterface</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ec2:CreateNetworkInterfacePermission</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ec2:DeleteNetworkInterface</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you revoke these permissions after you create the Firehose stream, Firehose can't scale out by creating
         * more ENIs when necessary. You might therefore see a degradation in performance.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the IAM role that the Firehose stream uses to create endpoints in the destination VPC. You
         *        can use your existing Firehose delivery role or you can specify a new role. In either case, make sure
         *        that the role trusts the Firehose service principal and that it grants the following permissions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ec2:DescribeVpcs</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ec2:DescribeVpcAttribute</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ec2:DescribeSubnets</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ec2:DescribeSecurityGroups</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ec2:DescribeNetworkInterfaces</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ec2:CreateNetworkInterface</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ec2:CreateNetworkInterfacePermission</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ec2:DeleteNetworkInterface</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you revoke these permissions after you create the Firehose stream, Firehose can't scale out by
         *        creating more ENIs when necessary. You might therefore see a degradation in performance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The IDs of the security groups that Firehose uses when it creates ENIs in the VPC of the Amazon OpenSearch
         * Service destination. You can use the same security group that the Amazon ES domain uses or different ones. If
         * you specify different security groups, ensure that they allow outbound HTTPS traffic to the Amazon OpenSearch
         * Service domain's security group. Also ensure that the Amazon OpenSearch Service domain's security group
         * allows HTTPS traffic from the security groups specified here. If you use the same security group for both
         * your Firehose stream and the Amazon OpenSearch Service domain, make sure the security group inbound rule
         * allows HTTPS traffic. For more information about security group rules, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security
         * group rules</a> in the Amazon VPC documentation.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups that Firehose uses when it creates ENIs in the VPC of the Amazon
         *        OpenSearch Service destination. You can use the same security group that the Amazon ES domain uses or
         *        different ones. If you specify different security groups, ensure that they allow outbound HTTPS
         *        traffic to the Amazon OpenSearch Service domain's security group. Also ensure that the Amazon
         *        OpenSearch Service domain's security group allows HTTPS traffic from the security groups specified
         *        here. If you use the same security group for both your Firehose stream and the Amazon OpenSearch
         *        Service domain, make sure the security group inbound rule allows HTTPS traffic. For more information
         *        about security group rules, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules"
         *        >Security group rules</a> in the Amazon VPC documentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The IDs of the security groups that Firehose uses when it creates ENIs in the VPC of the Amazon OpenSearch
         * Service destination. You can use the same security group that the Amazon ES domain uses or different ones. If
         * you specify different security groups, ensure that they allow outbound HTTPS traffic to the Amazon OpenSearch
         * Service domain's security group. Also ensure that the Amazon OpenSearch Service domain's security group
         * allows HTTPS traffic from the security groups specified here. If you use the same security group for both
         * your Firehose stream and the Amazon OpenSearch Service domain, make sure the security group inbound rule
         * allows HTTPS traffic. For more information about security group rules, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security
         * group rules</a> in the Amazon VPC documentation.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups that Firehose uses when it creates ENIs in the VPC of the Amazon
         *        OpenSearch Service destination. You can use the same security group that the Amazon ES domain uses or
         *        different ones. If you specify different security groups, ensure that they allow outbound HTTPS
         *        traffic to the Amazon OpenSearch Service domain's security group. Also ensure that the Amazon
         *        OpenSearch Service domain's security group allows HTTPS traffic from the security groups specified
         *        here. If you use the same security group for both your Firehose stream and the Amazon OpenSearch
         *        Service domain, make sure the security group inbound rule allows HTTPS traffic. For more information
         *        about security group rules, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules"
         *        >Security group rules</a> in the Amazon VPC documentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The ID of the Amazon OpenSearch Service destination's VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the Amazon OpenSearch Service destination's VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String roleARN;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfigurationDescription model) {
            subnetIds(model.subnetIds);
            roleARN(model.roleARN);
            securityGroupIds(model.securityGroupIds);
            vpcId(model.vpcId);
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public VpcConfigurationDescription build() {
            return new VpcConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
