/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickdevices.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceMethod
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceMethod> {
    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceType").getter(DeviceMethod.getter(DeviceMethod::deviceType)).setter(DeviceMethod.setter(Builder::deviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceType").build()}).build();
    private static final SdkField<String> METHOD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MethodName").getter(DeviceMethod.getter(DeviceMethod::methodName)).setter(DeviceMethod.setter(Builder::methodName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("methodName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_TYPE_FIELD, METHOD_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("deviceType", DEVICE_TYPE_FIELD);
            this.put("methodName", METHOD_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String deviceType;
    private final String methodName;

    private DeviceMethod(BuilderImpl builder) {
        this.deviceType = builder.deviceType;
        this.methodName = builder.methodName;
    }

    public final String deviceType() {
        return this.deviceType;
    }

    public final String methodName() {
        return this.methodName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.methodName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceMethod)) {
            return false;
        }
        DeviceMethod other = (DeviceMethod)obj;
        return Objects.equals(this.deviceType(), other.deviceType()) && Objects.equals(this.methodName(), other.methodName());
    }

    public final String toString() {
        return ToString.builder((String)"DeviceMethod").add("DeviceType", (Object)this.deviceType()).add("MethodName", (Object)this.methodName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceType": {
                return Optional.ofNullable(clazz.cast(this.deviceType()));
            }
            case "MethodName": {
                return Optional.ofNullable(clazz.cast(this.methodName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeviceMethod, T> g) {
        return obj -> g.apply((DeviceMethod)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceType;
        private String methodName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceMethod model) {
            this.deviceType(model.deviceType);
            this.methodName(model.methodName);
        }

        public final String getDeviceType() {
            return this.deviceType;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final String getMethodName() {
            return this.methodName;
        }

        public final void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public final Builder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public DeviceMethod build() {
            return new DeviceMethod(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceMethod> {
        public Builder deviceType(String var1);

        public Builder methodName(String var1);
    }
}

