/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotdeviceadvisor.model.IotDeviceAdvisorResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSuiteDefinitionResponse
extends IotDeviceAdvisorResponse
implements ToCopyableBuilder<Builder, GetSuiteDefinitionResponse> {
    private static final SdkField<String> SUITE_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteDefinitionId").getter(GetSuiteDefinitionResponse.getter(GetSuiteDefinitionResponse::suiteDefinitionId)).setter(GetSuiteDefinitionResponse.setter(Builder::suiteDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionId").build()}).build();
    private static final SdkField<String> SUITE_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteDefinitionArn").getter(GetSuiteDefinitionResponse.getter(GetSuiteDefinitionResponse::suiteDefinitionArn)).setter(GetSuiteDefinitionResponse.setter(Builder::suiteDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionArn").build()}).build();
    private static final SdkField<String> SUITE_DEFINITION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteDefinitionVersion").getter(GetSuiteDefinitionResponse.getter(GetSuiteDefinitionResponse::suiteDefinitionVersion)).setter(GetSuiteDefinitionResponse.setter(Builder::suiteDefinitionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionVersion").build()}).build();
    private static final SdkField<String> LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latestVersion").getter(GetSuiteDefinitionResponse.getter(GetSuiteDefinitionResponse::latestVersion)).setter(GetSuiteDefinitionResponse.setter(Builder::latestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()}).build();
    private static final SdkField<SuiteDefinitionConfiguration> SUITE_DEFINITION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("suiteDefinitionConfiguration").getter(GetSuiteDefinitionResponse.getter(GetSuiteDefinitionResponse::suiteDefinitionConfiguration)).setter(GetSuiteDefinitionResponse.setter(Builder::suiteDefinitionConfiguration)).constructor(SuiteDefinitionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionConfiguration").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetSuiteDefinitionResponse.getter(GetSuiteDefinitionResponse::createdAt)).setter(GetSuiteDefinitionResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedAt").getter(GetSuiteDefinitionResponse.getter(GetSuiteDefinitionResponse::lastModifiedAt)).setter(GetSuiteDefinitionResponse.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetSuiteDefinitionResponse.getter(GetSuiteDefinitionResponse::tags)).setter(GetSuiteDefinitionResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_ID_FIELD, SUITE_DEFINITION_ARN_FIELD, SUITE_DEFINITION_VERSION_FIELD, LATEST_VERSION_FIELD, SUITE_DEFINITION_CONFIGURATION_FIELD, CREATED_AT_FIELD, LAST_MODIFIED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("suiteDefinitionId", SUITE_DEFINITION_ID_FIELD);
            this.put("suiteDefinitionArn", SUITE_DEFINITION_ARN_FIELD);
            this.put("suiteDefinitionVersion", SUITE_DEFINITION_VERSION_FIELD);
            this.put("latestVersion", LATEST_VERSION_FIELD);
            this.put("suiteDefinitionConfiguration", SUITE_DEFINITION_CONFIGURATION_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String suiteDefinitionId;
    private final String suiteDefinitionArn;
    private final String suiteDefinitionVersion;
    private final String latestVersion;
    private final SuiteDefinitionConfiguration suiteDefinitionConfiguration;
    private final Instant createdAt;
    private final Instant lastModifiedAt;
    private final Map<String, String> tags;

    private GetSuiteDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.suiteDefinitionId = builder.suiteDefinitionId;
        this.suiteDefinitionArn = builder.suiteDefinitionArn;
        this.suiteDefinitionVersion = builder.suiteDefinitionVersion;
        this.latestVersion = builder.latestVersion;
        this.suiteDefinitionConfiguration = builder.suiteDefinitionConfiguration;
        this.createdAt = builder.createdAt;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.tags = builder.tags;
    }

    public final String suiteDefinitionId() {
        return this.suiteDefinitionId;
    }

    public final String suiteDefinitionArn() {
        return this.suiteDefinitionArn;
    }

    public final String suiteDefinitionVersion() {
        return this.suiteDefinitionVersion;
    }

    public final String latestVersion() {
        return this.latestVersion;
    }

    public final SuiteDefinitionConfiguration suiteDefinitionConfiguration() {
        return this.suiteDefinitionConfiguration;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteDefinitionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteDefinitionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSuiteDefinitionResponse)) {
            return false;
        }
        GetSuiteDefinitionResponse other = (GetSuiteDefinitionResponse)((Object)obj);
        return Objects.equals(this.suiteDefinitionId(), other.suiteDefinitionId()) && Objects.equals(this.suiteDefinitionArn(), other.suiteDefinitionArn()) && Objects.equals(this.suiteDefinitionVersion(), other.suiteDefinitionVersion()) && Objects.equals(this.latestVersion(), other.latestVersion()) && Objects.equals(this.suiteDefinitionConfiguration(), other.suiteDefinitionConfiguration()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetSuiteDefinitionResponse").add("SuiteDefinitionId", (Object)this.suiteDefinitionId()).add("SuiteDefinitionArn", (Object)this.suiteDefinitionArn()).add("SuiteDefinitionVersion", (Object)this.suiteDefinitionVersion()).add("LatestVersion", (Object)this.latestVersion()).add("SuiteDefinitionConfiguration", (Object)this.suiteDefinitionConfiguration()).add("CreatedAt", (Object)this.createdAt()).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "suiteDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.suiteDefinitionId()));
            }
            case "suiteDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.suiteDefinitionArn()));
            }
            case "suiteDefinitionVersion": {
                return Optional.ofNullable(clazz.cast(this.suiteDefinitionVersion()));
            }
            case "latestVersion": {
                return Optional.ofNullable(clazz.cast(this.latestVersion()));
            }
            case "suiteDefinitionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.suiteDefinitionConfiguration()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetSuiteDefinitionResponse, T> g) {
        return obj -> g.apply((GetSuiteDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotDeviceAdvisorResponse.BuilderImpl
    implements Builder {
        private String suiteDefinitionId;
        private String suiteDefinitionArn;
        private String suiteDefinitionVersion;
        private String latestVersion;
        private SuiteDefinitionConfiguration suiteDefinitionConfiguration;
        private Instant createdAt;
        private Instant lastModifiedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSuiteDefinitionResponse model) {
            super(model);
            this.suiteDefinitionId(model.suiteDefinitionId);
            this.suiteDefinitionArn(model.suiteDefinitionArn);
            this.suiteDefinitionVersion(model.suiteDefinitionVersion);
            this.latestVersion(model.latestVersion);
            this.suiteDefinitionConfiguration(model.suiteDefinitionConfiguration);
            this.createdAt(model.createdAt);
            this.lastModifiedAt(model.lastModifiedAt);
            this.tags(model.tags);
        }

        public final String getSuiteDefinitionId() {
            return this.suiteDefinitionId;
        }

        public final void setSuiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
        }

        @Override
        public final Builder suiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
            return this;
        }

        public final String getSuiteDefinitionArn() {
            return this.suiteDefinitionArn;
        }

        public final void setSuiteDefinitionArn(String suiteDefinitionArn) {
            this.suiteDefinitionArn = suiteDefinitionArn;
        }

        @Override
        public final Builder suiteDefinitionArn(String suiteDefinitionArn) {
            this.suiteDefinitionArn = suiteDefinitionArn;
            return this;
        }

        public final String getSuiteDefinitionVersion() {
            return this.suiteDefinitionVersion;
        }

        public final void setSuiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
        }

        @Override
        public final Builder suiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
            return this;
        }

        public final String getLatestVersion() {
            return this.latestVersion;
        }

        public final void setLatestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
        }

        @Override
        public final Builder latestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final SuiteDefinitionConfiguration.Builder getSuiteDefinitionConfiguration() {
            return this.suiteDefinitionConfiguration != null ? this.suiteDefinitionConfiguration.toBuilder() : null;
        }

        public final void setSuiteDefinitionConfiguration(SuiteDefinitionConfiguration.BuilderImpl suiteDefinitionConfiguration) {
            this.suiteDefinitionConfiguration = suiteDefinitionConfiguration != null ? suiteDefinitionConfiguration.build() : null;
        }

        @Override
        public final Builder suiteDefinitionConfiguration(SuiteDefinitionConfiguration suiteDefinitionConfiguration) {
            this.suiteDefinitionConfiguration = suiteDefinitionConfiguration;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetSuiteDefinitionResponse build() {
            return new GetSuiteDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotDeviceAdvisorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSuiteDefinitionResponse> {
        public Builder suiteDefinitionId(String var1);

        public Builder suiteDefinitionArn(String var1);

        public Builder suiteDefinitionVersion(String var1);

        public Builder latestVersion(String var1);

        public Builder suiteDefinitionConfiguration(SuiteDefinitionConfiguration var1);

        default public Builder suiteDefinitionConfiguration(Consumer<SuiteDefinitionConfiguration.Builder> suiteDefinitionConfiguration) {
            return this.suiteDefinitionConfiguration((SuiteDefinitionConfiguration)((SuiteDefinitionConfiguration.Builder)SuiteDefinitionConfiguration.builder().applyMutation(suiteDefinitionConfiguration)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

