/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphAsyncClient;
import software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateSummary;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse;

public class GetFlowTemplateRevisionsPublisher
implements SdkPublisher<GetFlowTemplateRevisionsResponse> {
    private final IoTThingsGraphAsyncClient client;
    private final GetFlowTemplateRevisionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetFlowTemplateRevisionsPublisher(IoTThingsGraphAsyncClient client, GetFlowTemplateRevisionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetFlowTemplateRevisionsPublisher(IoTThingsGraphAsyncClient client, GetFlowTemplateRevisionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetFlowTemplateRevisionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetFlowTemplateRevisionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FlowTemplateSummary> summaries() {
        Function<GetFlowTemplateRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetFlowTemplateRevisionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetFlowTemplateRevisionsResponseFetcher
    implements AsyncPageFetcher<GetFlowTemplateRevisionsResponse> {
        private GetFlowTemplateRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(GetFlowTemplateRevisionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetFlowTemplateRevisionsResponse> nextPage(GetFlowTemplateRevisionsResponse previousPage) {
            if (previousPage == null) {
                return GetFlowTemplateRevisionsPublisher.this.client.getFlowTemplateRevisions(GetFlowTemplateRevisionsPublisher.this.firstRequest);
            }
            return GetFlowTemplateRevisionsPublisher.this.client.getFlowTemplateRevisions((GetFlowTemplateRevisionsRequest)((Object)GetFlowTemplateRevisionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

