/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphClient;
import software.amazon.awssdk.services.iotthingsgraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateSummary;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse;

public class SearchFlowTemplatesIterable
implements SdkIterable<SearchFlowTemplatesResponse> {
    private final IoTThingsGraphClient client;
    private final SearchFlowTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchFlowTemplatesIterable(IoTThingsGraphClient client, SearchFlowTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchFlowTemplatesResponseFetcher();
    }

    public Iterator<SearchFlowTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FlowTemplateSummary> summaries() {
        Function<SearchFlowTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchFlowTemplatesResponseFetcher
    implements SyncPageFetcher<SearchFlowTemplatesResponse> {
        private SearchFlowTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(SearchFlowTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchFlowTemplatesResponse nextPage(SearchFlowTemplatesResponse previousPage) {
            if (previousPage == null) {
                return SearchFlowTemplatesIterable.this.client.searchFlowTemplates(SearchFlowTemplatesIterable.this.firstRequest);
            }
            return SearchFlowTemplatesIterable.this.client.searchFlowTemplates((SearchFlowTemplatesRequest)((Object)SearchFlowTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

