/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the estimated cost for resources in your Lightsail for Research account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostEstimate implements SdkPojo, Serializable, ToCopyableBuilder<CostEstimate.Builder, CostEstimate> {
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageType").getter(getter(CostEstimate::usageType)).setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()).build();

    private static final SdkField<List<EstimateByTime>> RESULTS_BY_TIME_FIELD = SdkField
            .<List<EstimateByTime>> builder(MarshallingType.LIST)
            .memberName("resultsByTime")
            .getter(getter(CostEstimate::resultsByTime))
            .setter(setter(Builder::resultsByTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultsByTime").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EstimateByTime> builder(MarshallingType.SDK_POJO)
                                            .constructor(EstimateByTime::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_TYPE_FIELD,
            RESULTS_BY_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String usageType;

    private final List<EstimateByTime> resultsByTime;

    private CostEstimate(BuilderImpl builder) {
        this.usageType = builder.usageType;
        this.resultsByTime = builder.resultsByTime;
    }

    /**
     * <p>
     * The types of usage that are included in the estimate, such as costs, usage, or data transfer.
     * </p>
     * 
     * @return The types of usage that are included in the estimate, such as costs, usage, or data transfer.
     */
    public final String usageType() {
        return usageType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResultsByTime property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResultsByTime() {
        return resultsByTime != null && !(resultsByTime instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The cost estimate result that's associated with a time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResultsByTime} method.
     * </p>
     * 
     * @return The cost estimate result that's associated with a time period.
     */
    public final List<EstimateByTime> resultsByTime() {
        return resultsByTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usageType());
        hashCode = 31 * hashCode + Objects.hashCode(hasResultsByTime() ? resultsByTime() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostEstimate)) {
            return false;
        }
        CostEstimate other = (CostEstimate) obj;
        return Objects.equals(usageType(), other.usageType()) && hasResultsByTime() == other.hasResultsByTime()
                && Objects.equals(resultsByTime(), other.resultsByTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CostEstimate").add("UsageType", usageType())
                .add("ResultsByTime", hasResultsByTime() ? resultsByTime() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usageType":
            return Optional.ofNullable(clazz.cast(usageType()));
        case "resultsByTime":
            return Optional.ofNullable(clazz.cast(resultsByTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CostEstimate, T> g) {
        return obj -> g.apply((CostEstimate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CostEstimate> {
        /**
         * <p>
         * The types of usage that are included in the estimate, such as costs, usage, or data transfer.
         * </p>
         * 
         * @param usageType
         *        The types of usage that are included in the estimate, such as costs, usage, or data transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageType(String usageType);

        /**
         * <p>
         * The cost estimate result that's associated with a time period.
         * </p>
         * 
         * @param resultsByTime
         *        The cost estimate result that's associated with a time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsByTime(Collection<EstimateByTime> resultsByTime);

        /**
         * <p>
         * The cost estimate result that's associated with a time period.
         * </p>
         * 
         * @param resultsByTime
         *        The cost estimate result that's associated with a time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsByTime(EstimateByTime... resultsByTime);

        /**
         * <p>
         * The cost estimate result that's associated with a time period.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.EstimateByTime.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lightsail.model.EstimateByTime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.EstimateByTime.Builder#build()} is called immediately
         * and its result is passed to {@link #resultsByTime(List<EstimateByTime>)}.
         * 
         * @param resultsByTime
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.EstimateByTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultsByTime(java.util.Collection<EstimateByTime>)
         */
        Builder resultsByTime(Consumer<EstimateByTime.Builder>... resultsByTime);
    }

    static final class BuilderImpl implements Builder {
        private String usageType;

        private List<EstimateByTime> resultsByTime = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CostEstimate model) {
            usageType(model.usageType);
            resultsByTime(model.resultsByTime);
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final List<EstimateByTime.Builder> getResultsByTime() {
            List<EstimateByTime.Builder> result = EstimatesByTimeCopier.copyToBuilder(this.resultsByTime);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultsByTime(Collection<EstimateByTime.BuilderImpl> resultsByTime) {
            this.resultsByTime = EstimatesByTimeCopier.copyFromBuilder(resultsByTime);
        }

        @Override
        public final Builder resultsByTime(Collection<EstimateByTime> resultsByTime) {
            this.resultsByTime = EstimatesByTimeCopier.copy(resultsByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsByTime(EstimateByTime... resultsByTime) {
            resultsByTime(Arrays.asList(resultsByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsByTime(Consumer<EstimateByTime.Builder>... resultsByTime) {
            resultsByTime(Stream.of(resultsByTime).map(c -> EstimateByTime.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CostEstimate build() {
            return new CostEstimate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
