/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon Elastic Compute Cloud instance and related resources to be created using the
 * <code>create cloud formation stack</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceEntry implements SdkPojo, Serializable, ToCopyableBuilder<InstanceEntry.Builder, InstanceEntry> {
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceName").getter(getter(InstanceEntry::sourceName)).setter(setter(Builder::sourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(InstanceEntry::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> PORT_INFO_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portInfoSource").getter(getter(InstanceEntry::portInfoSourceAsString))
            .setter(setter(Builder::portInfoSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portInfoSource").build()).build();

    private static final SdkField<String> USER_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userData").getter(getter(InstanceEntry::userData)).setter(setter(Builder::userData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userData").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(InstanceEntry::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_NAME_FIELD,
            INSTANCE_TYPE_FIELD, PORT_INFO_SOURCE_FIELD, USER_DATA_FIELD, AVAILABILITY_ZONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceName;

    private final String instanceType;

    private final String portInfoSource;

    private final String userData;

    private final String availabilityZone;

    private InstanceEntry(BuilderImpl builder) {
        this.sourceName = builder.sourceName;
        this.instanceType = builder.instanceType;
        this.portInfoSource = builder.portInfoSource;
        this.userData = builder.userData;
        this.availabilityZone = builder.availabilityZone;
    }

    /**
     * <p>
     * The name of the export snapshot record, which contains the exported Lightsail instance snapshot that will be used
     * as the source of the new Amazon EC2 instance.
     * </p>
     * <p>
     * Use the <code>get export snapshot records</code> operation to get a list of export snapshot records that you can
     * use to create a CloudFormation stack.
     * </p>
     * 
     * @return The name of the export snapshot record, which contains the exported Lightsail instance snapshot that will
     *         be used as the source of the new Amazon EC2 instance.</p>
     *         <p>
     *         Use the <code>get export snapshot records</code> operation to get a list of export snapshot records that
     *         you can use to create a CloudFormation stack.
     */
    public final String sourceName() {
        return sourceName;
    }

    /**
     * <p>
     * The instance type (<code>t2.micro</code>) to use for the new Amazon EC2 instance.
     * </p>
     * 
     * @return The instance type (<code>t2.micro</code>) to use for the new Amazon EC2 instance.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The port configuration to use for the new Amazon EC2 instance.
     * </p>
     * <p>
     * The following configuration options are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DEFAULT</code> - Use the default firewall settings from the Lightsail instance blueprint. If this is
     * specified, then IPv4 and IPv6 will be configured for the new instance that is created in Amazon EC2.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE</code> - Use the configured firewall settings from the source Lightsail instance. If this is
     * specified, the new instance that is created in Amazon EC2 will be configured to match the configuration of the
     * source Lightsail instance. For example, if the source instance is configured for dual-stack (IPv4 and IPv6), then
     * IPv4 and IPv6 will be configured for the new instance that is created in Amazon EC2. If the source instance is
     * configured for IPv4 only, then only IPv4 will be configured for the new instance that is created in Amazon EC2.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> - Use the default Amazon EC2 security group. If this is specified, then only IPv4 will be
     * configured for the new instance that is created in Amazon EC2.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CLOSED</code> - All ports closed. If this is specified, then only IPv4 will be configured for the new
     * instance that is created in Amazon EC2.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you configured <code>lightsail-connect</code> as a <code>cidrListAliases</code> on your instance, or if you
     * chose to allow the Lightsail browser-based SSH or RDP clients to connect to your instance, that configuration is
     * not carried over to your new Amazon EC2 instance.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portInfoSource}
     * will return {@link PortInfoSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #portInfoSourceAsString}.
     * </p>
     * 
     * @return The port configuration to use for the new Amazon EC2 instance.</p>
     *         <p>
     *         The following configuration options are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DEFAULT</code> - Use the default firewall settings from the Lightsail instance blueprint. If this
     *         is specified, then IPv4 and IPv6 will be configured for the new instance that is created in Amazon EC2.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTANCE</code> - Use the configured firewall settings from the source Lightsail instance. If this
     *         is specified, the new instance that is created in Amazon EC2 will be configured to match the
     *         configuration of the source Lightsail instance. For example, if the source instance is configured for
     *         dual-stack (IPv4 and IPv6), then IPv4 and IPv6 will be configured for the new instance that is created in
     *         Amazon EC2. If the source instance is configured for IPv4 only, then only IPv4 will be configured for the
     *         new instance that is created in Amazon EC2.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> - Use the default Amazon EC2 security group. If this is specified, then only IPv4 will
     *         be configured for the new instance that is created in Amazon EC2.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CLOSED</code> - All ports closed. If this is specified, then only IPv4 will be configured for the
     *         new instance that is created in Amazon EC2.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If you configured <code>lightsail-connect</code> as a <code>cidrListAliases</code> on your instance, or
     *         if you chose to allow the Lightsail browser-based SSH or RDP clients to connect to your instance, that
     *         configuration is not carried over to your new Amazon EC2 instance.
     *         </p>
     * @see PortInfoSourceType
     */
    public final PortInfoSourceType portInfoSource() {
        return PortInfoSourceType.fromValue(portInfoSource);
    }

    /**
     * <p>
     * The port configuration to use for the new Amazon EC2 instance.
     * </p>
     * <p>
     * The following configuration options are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DEFAULT</code> - Use the default firewall settings from the Lightsail instance blueprint. If this is
     * specified, then IPv4 and IPv6 will be configured for the new instance that is created in Amazon EC2.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE</code> - Use the configured firewall settings from the source Lightsail instance. If this is
     * specified, the new instance that is created in Amazon EC2 will be configured to match the configuration of the
     * source Lightsail instance. For example, if the source instance is configured for dual-stack (IPv4 and IPv6), then
     * IPv4 and IPv6 will be configured for the new instance that is created in Amazon EC2. If the source instance is
     * configured for IPv4 only, then only IPv4 will be configured for the new instance that is created in Amazon EC2.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> - Use the default Amazon EC2 security group. If this is specified, then only IPv4 will be
     * configured for the new instance that is created in Amazon EC2.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CLOSED</code> - All ports closed. If this is specified, then only IPv4 will be configured for the new
     * instance that is created in Amazon EC2.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you configured <code>lightsail-connect</code> as a <code>cidrListAliases</code> on your instance, or if you
     * chose to allow the Lightsail browser-based SSH or RDP clients to connect to your instance, that configuration is
     * not carried over to your new Amazon EC2 instance.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portInfoSource}
     * will return {@link PortInfoSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #portInfoSourceAsString}.
     * </p>
     * 
     * @return The port configuration to use for the new Amazon EC2 instance.</p>
     *         <p>
     *         The following configuration options are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DEFAULT</code> - Use the default firewall settings from the Lightsail instance blueprint. If this
     *         is specified, then IPv4 and IPv6 will be configured for the new instance that is created in Amazon EC2.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTANCE</code> - Use the configured firewall settings from the source Lightsail instance. If this
     *         is specified, the new instance that is created in Amazon EC2 will be configured to match the
     *         configuration of the source Lightsail instance. For example, if the source instance is configured for
     *         dual-stack (IPv4 and IPv6), then IPv4 and IPv6 will be configured for the new instance that is created in
     *         Amazon EC2. If the source instance is configured for IPv4 only, then only IPv4 will be configured for the
     *         new instance that is created in Amazon EC2.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> - Use the default Amazon EC2 security group. If this is specified, then only IPv4 will
     *         be configured for the new instance that is created in Amazon EC2.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CLOSED</code> - All ports closed. If this is specified, then only IPv4 will be configured for the
     *         new instance that is created in Amazon EC2.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If you configured <code>lightsail-connect</code> as a <code>cidrListAliases</code> on your instance, or
     *         if you chose to allow the Lightsail browser-based SSH or RDP clients to connect to your instance, that
     *         configuration is not carried over to your new Amazon EC2 instance.
     *         </p>
     * @see PortInfoSourceType
     */
    public final String portInfoSourceAsString() {
        return portInfoSource;
    }

    /**
     * <p>
     * A launch script you can create that configures a server with additional user data. For example, you might want to
     * run <code>apt-get -y update</code>.
     * </p>
     * <note>
     * <p>
     * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and
     * CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses <code>pkg</code>.
     * </p>
     * </note>
     * 
     * @return A launch script you can create that configures a server with additional user data. For example, you might
     *         want to run <code>apt-get -y update</code>.</p> <note>
     *         <p>
     *         Depending on the machine image you choose, the command to get software on your instance varies. Amazon
     *         Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
     *         <code>pkg</code>.
     *         </p>
     */
    public final String userData() {
        return userData;
    }

    /**
     * <p>
     * The Availability Zone for the new Amazon EC2 instance.
     * </p>
     * 
     * @return The Availability Zone for the new Amazon EC2 instance.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(portInfoSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceEntry)) {
            return false;
        }
        InstanceEntry other = (InstanceEntry) obj;
        return Objects.equals(sourceName(), other.sourceName()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(portInfoSourceAsString(), other.portInfoSourceAsString())
                && Objects.equals(userData(), other.userData()) && Objects.equals(availabilityZone(), other.availabilityZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceEntry").add("SourceName", sourceName()).add("InstanceType", instanceType())
                .add("PortInfoSource", portInfoSourceAsString()).add("UserData", userData())
                .add("AvailabilityZone", availabilityZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceName":
            return Optional.ofNullable(clazz.cast(sourceName()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "portInfoSource":
            return Optional.ofNullable(clazz.cast(portInfoSourceAsString()));
        case "userData":
            return Optional.ofNullable(clazz.cast(userData()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceEntry, T> g) {
        return obj -> g.apply((InstanceEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceEntry> {
        /**
         * <p>
         * The name of the export snapshot record, which contains the exported Lightsail instance snapshot that will be
         * used as the source of the new Amazon EC2 instance.
         * </p>
         * <p>
         * Use the <code>get export snapshot records</code> operation to get a list of export snapshot records that you
         * can use to create a CloudFormation stack.
         * </p>
         * 
         * @param sourceName
         *        The name of the export snapshot record, which contains the exported Lightsail instance snapshot that
         *        will be used as the source of the new Amazon EC2 instance.</p>
         *        <p>
         *        Use the <code>get export snapshot records</code> operation to get a list of export snapshot records
         *        that you can use to create a CloudFormation stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceName(String sourceName);

        /**
         * <p>
         * The instance type (<code>t2.micro</code>) to use for the new Amazon EC2 instance.
         * </p>
         * 
         * @param instanceType
         *        The instance type (<code>t2.micro</code>) to use for the new Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The port configuration to use for the new Amazon EC2 instance.
         * </p>
         * <p>
         * The following configuration options are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DEFAULT</code> - Use the default firewall settings from the Lightsail instance blueprint. If this is
         * specified, then IPv4 and IPv6 will be configured for the new instance that is created in Amazon EC2.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE</code> - Use the configured firewall settings from the source Lightsail instance. If this is
         * specified, the new instance that is created in Amazon EC2 will be configured to match the configuration of
         * the source Lightsail instance. For example, if the source instance is configured for dual-stack (IPv4 and
         * IPv6), then IPv4 and IPv6 will be configured for the new instance that is created in Amazon EC2. If the
         * source instance is configured for IPv4 only, then only IPv4 will be configured for the new instance that is
         * created in Amazon EC2.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> - Use the default Amazon EC2 security group. If this is specified, then only IPv4 will be
         * configured for the new instance that is created in Amazon EC2.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CLOSED</code> - All ports closed. If this is specified, then only IPv4 will be configured for the new
         * instance that is created in Amazon EC2.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If you configured <code>lightsail-connect</code> as a <code>cidrListAliases</code> on your instance, or if
         * you chose to allow the Lightsail browser-based SSH or RDP clients to connect to your instance, that
         * configuration is not carried over to your new Amazon EC2 instance.
         * </p>
         * </note>
         * 
         * @param portInfoSource
         *        The port configuration to use for the new Amazon EC2 instance.</p>
         *        <p>
         *        The following configuration options are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DEFAULT</code> - Use the default firewall settings from the Lightsail instance blueprint. If
         *        this is specified, then IPv4 and IPv6 will be configured for the new instance that is created in
         *        Amazon EC2.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTANCE</code> - Use the configured firewall settings from the source Lightsail instance. If
         *        this is specified, the new instance that is created in Amazon EC2 will be configured to match the
         *        configuration of the source Lightsail instance. For example, if the source instance is configured for
         *        dual-stack (IPv4 and IPv6), then IPv4 and IPv6 will be configured for the new instance that is created
         *        in Amazon EC2. If the source instance is configured for IPv4 only, then only IPv4 will be configured
         *        for the new instance that is created in Amazon EC2.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> - Use the default Amazon EC2 security group. If this is specified, then only IPv4
         *        will be configured for the new instance that is created in Amazon EC2.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CLOSED</code> - All ports closed. If this is specified, then only IPv4 will be configured for
         *        the new instance that is created in Amazon EC2.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If you configured <code>lightsail-connect</code> as a <code>cidrListAliases</code> on your instance,
         *        or if you chose to allow the Lightsail browser-based SSH or RDP clients to connect to your instance,
         *        that configuration is not carried over to your new Amazon EC2 instance.
         *        </p>
         * @see PortInfoSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortInfoSourceType
         */
        Builder portInfoSource(String portInfoSource);

        /**
         * <p>
         * The port configuration to use for the new Amazon EC2 instance.
         * </p>
         * <p>
         * The following configuration options are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DEFAULT</code> - Use the default firewall settings from the Lightsail instance blueprint. If this is
         * specified, then IPv4 and IPv6 will be configured for the new instance that is created in Amazon EC2.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE</code> - Use the configured firewall settings from the source Lightsail instance. If this is
         * specified, the new instance that is created in Amazon EC2 will be configured to match the configuration of
         * the source Lightsail instance. For example, if the source instance is configured for dual-stack (IPv4 and
         * IPv6), then IPv4 and IPv6 will be configured for the new instance that is created in Amazon EC2. If the
         * source instance is configured for IPv4 only, then only IPv4 will be configured for the new instance that is
         * created in Amazon EC2.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> - Use the default Amazon EC2 security group. If this is specified, then only IPv4 will be
         * configured for the new instance that is created in Amazon EC2.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CLOSED</code> - All ports closed. If this is specified, then only IPv4 will be configured for the new
         * instance that is created in Amazon EC2.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If you configured <code>lightsail-connect</code> as a <code>cidrListAliases</code> on your instance, or if
         * you chose to allow the Lightsail browser-based SSH or RDP clients to connect to your instance, that
         * configuration is not carried over to your new Amazon EC2 instance.
         * </p>
         * </note>
         * 
         * @param portInfoSource
         *        The port configuration to use for the new Amazon EC2 instance.</p>
         *        <p>
         *        The following configuration options are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DEFAULT</code> - Use the default firewall settings from the Lightsail instance blueprint. If
         *        this is specified, then IPv4 and IPv6 will be configured for the new instance that is created in
         *        Amazon EC2.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTANCE</code> - Use the configured firewall settings from the source Lightsail instance. If
         *        this is specified, the new instance that is created in Amazon EC2 will be configured to match the
         *        configuration of the source Lightsail instance. For example, if the source instance is configured for
         *        dual-stack (IPv4 and IPv6), then IPv4 and IPv6 will be configured for the new instance that is created
         *        in Amazon EC2. If the source instance is configured for IPv4 only, then only IPv4 will be configured
         *        for the new instance that is created in Amazon EC2.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> - Use the default Amazon EC2 security group. If this is specified, then only IPv4
         *        will be configured for the new instance that is created in Amazon EC2.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CLOSED</code> - All ports closed. If this is specified, then only IPv4 will be configured for
         *        the new instance that is created in Amazon EC2.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If you configured <code>lightsail-connect</code> as a <code>cidrListAliases</code> on your instance,
         *        or if you chose to allow the Lightsail browser-based SSH or RDP clients to connect to your instance,
         *        that configuration is not carried over to your new Amazon EC2 instance.
         *        </p>
         * @see PortInfoSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortInfoSourceType
         */
        Builder portInfoSource(PortInfoSourceType portInfoSource);

        /**
         * <p>
         * A launch script you can create that configures a server with additional user data. For example, you might
         * want to run <code>apt-get -y update</code>.
         * </p>
         * <note>
         * <p>
         * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux
         * and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
         * <code>pkg</code>.
         * </p>
         * </note>
         * 
         * @param userData
         *        A launch script you can create that configures a server with additional user data. For example, you
         *        might want to run <code>apt-get -y update</code>.</p> <note>
         *        <p>
         *        Depending on the machine image you choose, the command to get software on your instance varies. Amazon
         *        Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
         *        <code>pkg</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The Availability Zone for the new Amazon EC2 instance.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the new Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);
    }

    static final class BuilderImpl implements Builder {
        private String sourceName;

        private String instanceType;

        private String portInfoSource;

        private String userData;

        private String availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceEntry model) {
            sourceName(model.sourceName);
            instanceType(model.instanceType);
            portInfoSource(model.portInfoSource);
            userData(model.userData);
            availabilityZone(model.availabilityZone);
        }

        public final String getSourceName() {
            return sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getPortInfoSource() {
            return portInfoSource;
        }

        public final void setPortInfoSource(String portInfoSource) {
            this.portInfoSource = portInfoSource;
        }

        @Override
        public final Builder portInfoSource(String portInfoSource) {
            this.portInfoSource = portInfoSource;
            return this;
        }

        @Override
        public final Builder portInfoSource(PortInfoSourceType portInfoSource) {
            this.portInfoSource(portInfoSource == null ? null : portInfoSource.toString());
            return this;
        }

        public final String getUserData() {
            return userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        @Override
        public InstanceEntry build() {
            return new InstanceEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
