/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.DevicePosition;
import software.amazon.awssdk.services.location.model.DevicePositionListCopier;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDevicePositionHistoryResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, GetDevicePositionHistoryResponse> {
    private static final SdkField<List<DevicePosition>> DEVICE_POSITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DevicePositions").getter(GetDevicePositionHistoryResponse.getter(GetDevicePositionHistoryResponse::devicePositions)).setter(GetDevicePositionHistoryResponse.setter(Builder::devicePositions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevicePositions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DevicePosition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetDevicePositionHistoryResponse.getter(GetDevicePositionHistoryResponse::nextToken)).setter(GetDevicePositionHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_POSITIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DevicePositions", DEVICE_POSITIONS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<DevicePosition> devicePositions;
    private final String nextToken;

    private GetDevicePositionHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.devicePositions = builder.devicePositions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDevicePositions() {
        return this.devicePositions != null && !(this.devicePositions instanceof SdkAutoConstructList);
    }

    public final List<DevicePosition> devicePositions() {
        return this.devicePositions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDevicePositions() ? this.devicePositions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePositionHistoryResponse)) {
            return false;
        }
        GetDevicePositionHistoryResponse other = (GetDevicePositionHistoryResponse)((Object)obj);
        return this.hasDevicePositions() == other.hasDevicePositions() && Objects.equals(this.devicePositions(), other.devicePositions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetDevicePositionHistoryResponse").add("DevicePositions", this.hasDevicePositions() ? this.devicePositions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DevicePositions": {
                return Optional.ofNullable(clazz.cast(this.devicePositions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDevicePositionHistoryResponse, T> g) {
        return obj -> g.apply((GetDevicePositionHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private List<DevicePosition> devicePositions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePositionHistoryResponse model) {
            super(model);
            this.devicePositions(model.devicePositions);
            this.nextToken(model.nextToken);
        }

        public final List<DevicePosition.Builder> getDevicePositions() {
            List<DevicePosition.Builder> result = DevicePositionListCopier.copyToBuilder(this.devicePositions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDevicePositions(Collection<DevicePosition.BuilderImpl> devicePositions) {
            this.devicePositions = DevicePositionListCopier.copyFromBuilder(devicePositions);
        }

        @Override
        public final Builder devicePositions(Collection<DevicePosition> devicePositions) {
            this.devicePositions = DevicePositionListCopier.copy(devicePositions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devicePositions(DevicePosition ... devicePositions) {
            this.devicePositions(Arrays.asList(devicePositions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devicePositions(Consumer<DevicePosition.Builder> ... devicePositions) {
            this.devicePositions(Stream.of(devicePositions).map(c -> (DevicePosition)((DevicePosition.Builder)DevicePosition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetDevicePositionHistoryResponse build() {
            return new GetDevicePositionHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDevicePositionHistoryResponse> {
        public Builder devicePositions(Collection<DevicePosition> var1);

        public Builder devicePositions(DevicePosition ... var1);

        public Builder devicePositions(Consumer<DevicePosition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

