/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplacecatalog.model.ContainerProductEntityIdFilter;
import software.amazon.awssdk.services.marketplacecatalog.model.ContainerProductLastModifiedDateFilter;
import software.amazon.awssdk.services.marketplacecatalog.model.ContainerProductTitleFilter;
import software.amazon.awssdk.services.marketplacecatalog.model.ContainerProductVisibilityFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerProductFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerProductFilters> {
    private static final SdkField<ContainerProductEntityIdFilter> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntityId").getter(ContainerProductFilters.getter(ContainerProductFilters::entityId)).setter(ContainerProductFilters.setter(Builder::entityId)).constructor(ContainerProductEntityIdFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()}).build();
    private static final SdkField<ContainerProductLastModifiedDateFilter> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedDate").getter(ContainerProductFilters.getter(ContainerProductFilters::lastModifiedDate)).setter(ContainerProductFilters.setter(Builder::lastModifiedDate)).constructor(ContainerProductLastModifiedDateFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<ContainerProductTitleFilter> PRODUCT_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProductTitle").getter(ContainerProductFilters.getter(ContainerProductFilters::productTitle)).setter(ContainerProductFilters.setter(Builder::productTitle)).constructor(ContainerProductTitleFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductTitle").build()}).build();
    private static final SdkField<ContainerProductVisibilityFilter> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Visibility").getter(ContainerProductFilters.getter(ContainerProductFilters::visibility)).setter(ContainerProductFilters.setter(Builder::visibility)).constructor(ContainerProductVisibilityFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD, LAST_MODIFIED_DATE_FIELD, PRODUCT_TITLE_FIELD, VISIBILITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EntityId", ENTITY_ID_FIELD);
            this.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
            this.put("ProductTitle", PRODUCT_TITLE_FIELD);
            this.put("Visibility", VISIBILITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ContainerProductEntityIdFilter entityId;
    private final ContainerProductLastModifiedDateFilter lastModifiedDate;
    private final ContainerProductTitleFilter productTitle;
    private final ContainerProductVisibilityFilter visibility;

    private ContainerProductFilters(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.productTitle = builder.productTitle;
        this.visibility = builder.visibility;
    }

    public final ContainerProductEntityIdFilter entityId() {
        return this.entityId;
    }

    public final ContainerProductLastModifiedDateFilter lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final ContainerProductTitleFilter productTitle() {
        return this.productTitle;
    }

    public final ContainerProductVisibilityFilter visibility() {
        return this.visibility;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.productTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibility());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerProductFilters)) {
            return false;
        }
        ContainerProductFilters other = (ContainerProductFilters)obj;
        return Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.productTitle(), other.productTitle()) && Objects.equals(this.visibility(), other.visibility());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerProductFilters").add("EntityId", (Object)this.entityId()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("ProductTitle", (Object)this.productTitle()).add("Visibility", (Object)this.visibility()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "ProductTitle": {
                return Optional.ofNullable(clazz.cast(this.productTitle()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibility()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ContainerProductFilters, T> g) {
        return obj -> g.apply((ContainerProductFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ContainerProductEntityIdFilter entityId;
        private ContainerProductLastModifiedDateFilter lastModifiedDate;
        private ContainerProductTitleFilter productTitle;
        private ContainerProductVisibilityFilter visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerProductFilters model) {
            this.entityId(model.entityId);
            this.lastModifiedDate(model.lastModifiedDate);
            this.productTitle(model.productTitle);
            this.visibility(model.visibility);
        }

        public final ContainerProductEntityIdFilter.Builder getEntityId() {
            return this.entityId != null ? this.entityId.toBuilder() : null;
        }

        public final void setEntityId(ContainerProductEntityIdFilter.BuilderImpl entityId) {
            this.entityId = entityId != null ? entityId.build() : null;
        }

        @Override
        public final Builder entityId(ContainerProductEntityIdFilter entityId) {
            this.entityId = entityId;
            return this;
        }

        public final ContainerProductLastModifiedDateFilter.Builder getLastModifiedDate() {
            return this.lastModifiedDate != null ? this.lastModifiedDate.toBuilder() : null;
        }

        public final void setLastModifiedDate(ContainerProductLastModifiedDateFilter.BuilderImpl lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate != null ? lastModifiedDate.build() : null;
        }

        @Override
        public final Builder lastModifiedDate(ContainerProductLastModifiedDateFilter lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final ContainerProductTitleFilter.Builder getProductTitle() {
            return this.productTitle != null ? this.productTitle.toBuilder() : null;
        }

        public final void setProductTitle(ContainerProductTitleFilter.BuilderImpl productTitle) {
            this.productTitle = productTitle != null ? productTitle.build() : null;
        }

        @Override
        public final Builder productTitle(ContainerProductTitleFilter productTitle) {
            this.productTitle = productTitle;
            return this;
        }

        public final ContainerProductVisibilityFilter.Builder getVisibility() {
            return this.visibility != null ? this.visibility.toBuilder() : null;
        }

        public final void setVisibility(ContainerProductVisibilityFilter.BuilderImpl visibility) {
            this.visibility = visibility != null ? visibility.build() : null;
        }

        @Override
        public final Builder visibility(ContainerProductVisibilityFilter visibility) {
            this.visibility = visibility;
            return this;
        }

        public ContainerProductFilters build() {
            return new ContainerProductFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerProductFilters> {
        public Builder entityId(ContainerProductEntityIdFilter var1);

        default public Builder entityId(Consumer<ContainerProductEntityIdFilter.Builder> entityId) {
            return this.entityId((ContainerProductEntityIdFilter)((ContainerProductEntityIdFilter.Builder)ContainerProductEntityIdFilter.builder().applyMutation(entityId)).build());
        }

        public Builder lastModifiedDate(ContainerProductLastModifiedDateFilter var1);

        default public Builder lastModifiedDate(Consumer<ContainerProductLastModifiedDateFilter.Builder> lastModifiedDate) {
            return this.lastModifiedDate((ContainerProductLastModifiedDateFilter)((ContainerProductLastModifiedDateFilter.Builder)ContainerProductLastModifiedDateFilter.builder().applyMutation(lastModifiedDate)).build());
        }

        public Builder productTitle(ContainerProductTitleFilter var1);

        default public Builder productTitle(Consumer<ContainerProductTitleFilter.Builder> productTitle) {
            return this.productTitle((ContainerProductTitleFilter)((ContainerProductTitleFilter.Builder)ContainerProductTitleFilter.builder().applyMutation(productTitle)).build());
        }

        public Builder visibility(ContainerProductVisibilityFilter var1);

        default public Builder visibility(Consumer<ContainerProductVisibilityFilter.Builder> visibility) {
            return this.visibility((ContainerProductVisibilityFilter)((ContainerProductVisibilityFilter.Builder)ContainerProductVisibilityFilter.builder().applyMutation(visibility)).build());
        }
    }
}

