/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacecatalog.model.OfferBuyerAccountsListCopier;
import software.amazon.awssdk.services.marketplacecatalog.model.OfferStateString;
import software.amazon.awssdk.services.marketplacecatalog.model.OfferTargetingListCopier;
import software.amazon.awssdk.services.marketplacecatalog.model.OfferTargetingString;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OfferSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OfferSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(OfferSummary.getter(OfferSummary::name)).setter(OfferSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(OfferSummary.getter(OfferSummary::productId)).setter(OfferSummary.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> RESALE_AUTHORIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResaleAuthorizationId").getter(OfferSummary.getter(OfferSummary::resaleAuthorizationId)).setter(OfferSummary.setter(Builder::resaleAuthorizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResaleAuthorizationId").build()}).build();
    private static final SdkField<String> RELEASE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReleaseDate").getter(OfferSummary.getter(OfferSummary::releaseDate)).setter(OfferSummary.setter(Builder::releaseDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseDate").build()}).build();
    private static final SdkField<String> AVAILABILITY_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityEndDate").getter(OfferSummary.getter(OfferSummary::availabilityEndDate)).setter(OfferSummary.setter(Builder::availabilityEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityEndDate").build()}).build();
    private static final SdkField<List<String>> BUYER_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BuyerAccounts").getter(OfferSummary.getter(OfferSummary::buyerAccounts)).setter(OfferSummary.setter(Builder::buyerAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(OfferSummary.getter(OfferSummary::stateAsString)).setter(OfferSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<String>> TARGETING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targeting").getter(OfferSummary.getter(OfferSummary::targetingAsStrings)).setter(OfferSummary.setter(Builder::targetingWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targeting").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PRODUCT_ID_FIELD, RESALE_AUTHORIZATION_ID_FIELD, RELEASE_DATE_FIELD, AVAILABILITY_END_DATE_FIELD, BUYER_ACCOUNTS_FIELD, STATE_FIELD, TARGETING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("ProductId", PRODUCT_ID_FIELD);
            this.put("ResaleAuthorizationId", RESALE_AUTHORIZATION_ID_FIELD);
            this.put("ReleaseDate", RELEASE_DATE_FIELD);
            this.put("AvailabilityEndDate", AVAILABILITY_END_DATE_FIELD);
            this.put("BuyerAccounts", BUYER_ACCOUNTS_FIELD);
            this.put("State", STATE_FIELD);
            this.put("Targeting", TARGETING_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String productId;
    private final String resaleAuthorizationId;
    private final String releaseDate;
    private final String availabilityEndDate;
    private final List<String> buyerAccounts;
    private final String state;
    private final List<String> targeting;

    private OfferSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.productId = builder.productId;
        this.resaleAuthorizationId = builder.resaleAuthorizationId;
        this.releaseDate = builder.releaseDate;
        this.availabilityEndDate = builder.availabilityEndDate;
        this.buyerAccounts = builder.buyerAccounts;
        this.state = builder.state;
        this.targeting = builder.targeting;
    }

    public final String name() {
        return this.name;
    }

    public final String productId() {
        return this.productId;
    }

    public final String resaleAuthorizationId() {
        return this.resaleAuthorizationId;
    }

    public final String releaseDate() {
        return this.releaseDate;
    }

    public final String availabilityEndDate() {
        return this.availabilityEndDate;
    }

    public final boolean hasBuyerAccounts() {
        return this.buyerAccounts != null && !(this.buyerAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> buyerAccounts() {
        return this.buyerAccounts;
    }

    public final OfferStateString state() {
        return OfferStateString.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final List<OfferTargetingString> targeting() {
        return OfferTargetingListCopier.copyStringToEnum(this.targeting);
    }

    public final boolean hasTargeting() {
        return this.targeting != null && !(this.targeting instanceof SdkAutoConstructList);
    }

    public final List<String> targetingAsStrings() {
        return this.targeting;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resaleAuthorizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuyerAccounts() ? this.buyerAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargeting() ? this.targetingAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferSummary)) {
            return false;
        }
        OfferSummary other = (OfferSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.resaleAuthorizationId(), other.resaleAuthorizationId()) && Objects.equals(this.releaseDate(), other.releaseDate()) && Objects.equals(this.availabilityEndDate(), other.availabilityEndDate()) && this.hasBuyerAccounts() == other.hasBuyerAccounts() && Objects.equals(this.buyerAccounts(), other.buyerAccounts()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTargeting() == other.hasTargeting() && Objects.equals(this.targetingAsStrings(), other.targetingAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"OfferSummary").add("Name", (Object)this.name()).add("ProductId", (Object)this.productId()).add("ResaleAuthorizationId", (Object)this.resaleAuthorizationId()).add("ReleaseDate", (Object)this.releaseDate()).add("AvailabilityEndDate", (Object)this.availabilityEndDate()).add("BuyerAccounts", this.hasBuyerAccounts() ? this.buyerAccounts() : null).add("State", (Object)this.stateAsString()).add("Targeting", this.hasTargeting() ? this.targetingAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ResaleAuthorizationId": {
                return Optional.ofNullable(clazz.cast(this.resaleAuthorizationId()));
            }
            case "ReleaseDate": {
                return Optional.ofNullable(clazz.cast(this.releaseDate()));
            }
            case "AvailabilityEndDate": {
                return Optional.ofNullable(clazz.cast(this.availabilityEndDate()));
            }
            case "BuyerAccounts": {
                return Optional.ofNullable(clazz.cast(this.buyerAccounts()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Targeting": {
                return Optional.ofNullable(clazz.cast(this.targetingAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OfferSummary, T> g) {
        return obj -> g.apply((OfferSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String productId;
        private String resaleAuthorizationId;
        private String releaseDate;
        private String availabilityEndDate;
        private List<String> buyerAccounts = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private List<String> targeting = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OfferSummary model) {
            this.name(model.name);
            this.productId(model.productId);
            this.resaleAuthorizationId(model.resaleAuthorizationId);
            this.releaseDate(model.releaseDate);
            this.availabilityEndDate(model.availabilityEndDate);
            this.buyerAccounts(model.buyerAccounts);
            this.state(model.state);
            this.targetingWithStrings(model.targeting);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getResaleAuthorizationId() {
            return this.resaleAuthorizationId;
        }

        public final void setResaleAuthorizationId(String resaleAuthorizationId) {
            this.resaleAuthorizationId = resaleAuthorizationId;
        }

        @Override
        public final Builder resaleAuthorizationId(String resaleAuthorizationId) {
            this.resaleAuthorizationId = resaleAuthorizationId;
            return this;
        }

        public final String getReleaseDate() {
            return this.releaseDate;
        }

        public final void setReleaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
        }

        @Override
        public final Builder releaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public final String getAvailabilityEndDate() {
            return this.availabilityEndDate;
        }

        public final void setAvailabilityEndDate(String availabilityEndDate) {
            this.availabilityEndDate = availabilityEndDate;
        }

        @Override
        public final Builder availabilityEndDate(String availabilityEndDate) {
            this.availabilityEndDate = availabilityEndDate;
            return this;
        }

        public final Collection<String> getBuyerAccounts() {
            if (this.buyerAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.buyerAccounts;
        }

        public final void setBuyerAccounts(Collection<String> buyerAccounts) {
            this.buyerAccounts = OfferBuyerAccountsListCopier.copy(buyerAccounts);
        }

        @Override
        public final Builder buyerAccounts(Collection<String> buyerAccounts) {
            this.buyerAccounts = OfferBuyerAccountsListCopier.copy(buyerAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buyerAccounts(String ... buyerAccounts) {
            this.buyerAccounts(Arrays.asList(buyerAccounts));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(OfferStateString state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Collection<String> getTargeting() {
            if (this.targeting instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targeting;
        }

        public final void setTargeting(Collection<String> targeting) {
            this.targeting = OfferTargetingListCopier.copy(targeting);
        }

        @Override
        public final Builder targetingWithStrings(Collection<String> targeting) {
            this.targeting = OfferTargetingListCopier.copy(targeting);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetingWithStrings(String ... targeting) {
            this.targetingWithStrings(Arrays.asList(targeting));
            return this;
        }

        @Override
        public final Builder targeting(Collection<OfferTargetingString> targeting) {
            this.targeting = OfferTargetingListCopier.copyEnumToString(targeting);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targeting(OfferTargetingString ... targeting) {
            this.targeting(Arrays.asList(targeting));
            return this;
        }

        public OfferSummary build() {
            return new OfferSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OfferSummary> {
        public Builder name(String var1);

        public Builder productId(String var1);

        public Builder resaleAuthorizationId(String var1);

        public Builder releaseDate(String var1);

        public Builder availabilityEndDate(String var1);

        public Builder buyerAccounts(Collection<String> var1);

        public Builder buyerAccounts(String ... var1);

        public Builder state(String var1);

        public Builder state(OfferStateString var1);

        public Builder targetingWithStrings(Collection<String> var1);

        public Builder targetingWithStrings(String ... var1);

        public Builder targeting(Collection<OfferTargetingString> var1);

        public Builder targeting(OfferTargetingString ... var1);
    }
}

