/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplacecatalog.model.DataProductEntityIdFilter;
import software.amazon.awssdk.services.marketplacecatalog.model.DataProductLastModifiedDateFilter;
import software.amazon.awssdk.services.marketplacecatalog.model.DataProductTitleFilter;
import software.amazon.awssdk.services.marketplacecatalog.model.DataProductVisibilityFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProductFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProductFilters> {
    private static final SdkField<DataProductEntityIdFilter> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntityId").getter(DataProductFilters.getter(DataProductFilters::entityId)).setter(DataProductFilters.setter(Builder::entityId)).constructor(DataProductEntityIdFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()}).build();
    private static final SdkField<DataProductTitleFilter> PRODUCT_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProductTitle").getter(DataProductFilters.getter(DataProductFilters::productTitle)).setter(DataProductFilters.setter(Builder::productTitle)).constructor(DataProductTitleFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductTitle").build()}).build();
    private static final SdkField<DataProductVisibilityFilter> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Visibility").getter(DataProductFilters.getter(DataProductFilters::visibility)).setter(DataProductFilters.setter(Builder::visibility)).constructor(DataProductVisibilityFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<DataProductLastModifiedDateFilter> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedDate").getter(DataProductFilters.getter(DataProductFilters::lastModifiedDate)).setter(DataProductFilters.setter(Builder::lastModifiedDate)).constructor(DataProductLastModifiedDateFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD, PRODUCT_TITLE_FIELD, VISIBILITY_FIELD, LAST_MODIFIED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataProductFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DataProductEntityIdFilter entityId;
    private final DataProductTitleFilter productTitle;
    private final DataProductVisibilityFilter visibility;
    private final DataProductLastModifiedDateFilter lastModifiedDate;

    private DataProductFilters(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.productTitle = builder.productTitle;
        this.visibility = builder.visibility;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final DataProductEntityIdFilter entityId() {
        return this.entityId;
    }

    public final DataProductTitleFilter productTitle() {
        return this.productTitle;
    }

    public final DataProductVisibilityFilter visibility() {
        return this.visibility;
    }

    public final DataProductLastModifiedDateFilter lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibility());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProductFilters)) {
            return false;
        }
        DataProductFilters other = (DataProductFilters)obj;
        return Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.productTitle(), other.productTitle()) && Objects.equals(this.visibility(), other.visibility()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"DataProductFilters").add("EntityId", (Object)this.entityId()).add("ProductTitle", (Object)this.productTitle()).add("Visibility", (Object)this.visibility()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "ProductTitle": {
                return Optional.ofNullable(clazz.cast(this.productTitle()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibility()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EntityId", ENTITY_ID_FIELD);
        map.put("ProductTitle", PRODUCT_TITLE_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProductFilters, T> g) {
        return obj -> g.apply((DataProductFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataProductEntityIdFilter entityId;
        private DataProductTitleFilter productTitle;
        private DataProductVisibilityFilter visibility;
        private DataProductLastModifiedDateFilter lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProductFilters model) {
            this.entityId(model.entityId);
            this.productTitle(model.productTitle);
            this.visibility(model.visibility);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final DataProductEntityIdFilter.Builder getEntityId() {
            return this.entityId != null ? this.entityId.toBuilder() : null;
        }

        public final void setEntityId(DataProductEntityIdFilter.BuilderImpl entityId) {
            this.entityId = entityId != null ? entityId.build() : null;
        }

        @Override
        public final Builder entityId(DataProductEntityIdFilter entityId) {
            this.entityId = entityId;
            return this;
        }

        public final DataProductTitleFilter.Builder getProductTitle() {
            return this.productTitle != null ? this.productTitle.toBuilder() : null;
        }

        public final void setProductTitle(DataProductTitleFilter.BuilderImpl productTitle) {
            this.productTitle = productTitle != null ? productTitle.build() : null;
        }

        @Override
        public final Builder productTitle(DataProductTitleFilter productTitle) {
            this.productTitle = productTitle;
            return this;
        }

        public final DataProductVisibilityFilter.Builder getVisibility() {
            return this.visibility != null ? this.visibility.toBuilder() : null;
        }

        public final void setVisibility(DataProductVisibilityFilter.BuilderImpl visibility) {
            this.visibility = visibility != null ? visibility.build() : null;
        }

        @Override
        public final Builder visibility(DataProductVisibilityFilter visibility) {
            this.visibility = visibility;
            return this;
        }

        public final DataProductLastModifiedDateFilter.Builder getLastModifiedDate() {
            return this.lastModifiedDate != null ? this.lastModifiedDate.toBuilder() : null;
        }

        public final void setLastModifiedDate(DataProductLastModifiedDateFilter.BuilderImpl lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate != null ? lastModifiedDate.build() : null;
        }

        @Override
        public final Builder lastModifiedDate(DataProductLastModifiedDateFilter lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public DataProductFilters build() {
            return new DataProductFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProductFilters> {
        public Builder entityId(DataProductEntityIdFilter var1);

        default public Builder entityId(Consumer<DataProductEntityIdFilter.Builder> entityId) {
            return this.entityId((DataProductEntityIdFilter)((DataProductEntityIdFilter.Builder)DataProductEntityIdFilter.builder().applyMutation(entityId)).build());
        }

        public Builder productTitle(DataProductTitleFilter var1);

        default public Builder productTitle(Consumer<DataProductTitleFilter.Builder> productTitle) {
            return this.productTitle((DataProductTitleFilter)((DataProductTitleFilter.Builder)DataProductTitleFilter.builder().applyMutation(productTitle)).build());
        }

        public Builder visibility(DataProductVisibilityFilter var1);

        default public Builder visibility(Consumer<DataProductVisibilityFilter.Builder> visibility) {
            return this.visibility((DataProductVisibilityFilter)((DataProductVisibilityFilter.Builder)DataProductVisibilityFilter.builder().applyMutation(visibility)).build());
        }

        public Builder lastModifiedDate(DataProductLastModifiedDateFilter var1);

        default public Builder lastModifiedDate(Consumer<DataProductLastModifiedDateFilter.Builder> lastModifiedDate) {
            return this.lastModifiedDate((DataProductLastModifiedDateFilter)((DataProductLastModifiedDateFilter.Builder)DataProductLastModifiedDateFilter.builder().applyMutation(lastModifiedDate)).build());
        }
    }
}

