/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacecatalog.model.OfferTargetingFilterValueListCopier;
import software.amazon.awssdk.services.marketplacecatalog.model.OfferTargetingString;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OfferTargetingFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OfferTargetingFilter> {
    private static final SdkField<List<String>> VALUE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValueList").getter(OfferTargetingFilter.getter(OfferTargetingFilter::valueListAsStrings)).setter(OfferTargetingFilter.setter(Builder::valueListWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OfferTargetingFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> valueList;

    private OfferTargetingFilter(BuilderImpl builder) {
        this.valueList = builder.valueList;
    }

    public final List<OfferTargetingString> valueList() {
        return OfferTargetingFilterValueListCopier.copyStringToEnum(this.valueList);
    }

    public final boolean hasValueList() {
        return this.valueList != null && !(this.valueList instanceof SdkAutoConstructList);
    }

    public final List<String> valueListAsStrings() {
        return this.valueList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValueList() ? this.valueListAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferTargetingFilter)) {
            return false;
        }
        OfferTargetingFilter other = (OfferTargetingFilter)obj;
        return this.hasValueList() == other.hasValueList() && Objects.equals(this.valueListAsStrings(), other.valueListAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"OfferTargetingFilter").add("ValueList", this.hasValueList() ? this.valueListAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ValueList": {
                return Optional.ofNullable(clazz.cast(this.valueListAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("ValueList", VALUE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OfferTargetingFilter, T> g) {
        return obj -> g.apply((OfferTargetingFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> valueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OfferTargetingFilter model) {
            this.valueListWithStrings(model.valueList);
        }

        public final Collection<String> getValueList() {
            if (this.valueList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.valueList;
        }

        public final void setValueList(Collection<String> valueList) {
            this.valueList = OfferTargetingFilterValueListCopier.copy(valueList);
        }

        @Override
        public final Builder valueListWithStrings(Collection<String> valueList) {
            this.valueList = OfferTargetingFilterValueListCopier.copy(valueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueListWithStrings(String ... valueList) {
            this.valueListWithStrings(Arrays.asList(valueList));
            return this;
        }

        @Override
        public final Builder valueList(Collection<OfferTargetingString> valueList) {
            this.valueList = OfferTargetingFilterValueListCopier.copyEnumToString(valueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueList(OfferTargetingString ... valueList) {
            this.valueList(Arrays.asList(valueList));
            return this;
        }

        public OfferTargetingFilter build() {
            return new OfferTargetingFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OfferTargetingFilter> {
        public Builder valueListWithStrings(Collection<String> var1);

        public Builder valueListWithStrings(String ... var1);

        public Builder valueList(Collection<OfferTargetingString> var1);

        public Builder valueList(OfferTargetingString ... var1);
    }
}

