/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplacecatalog.model.ResaleAuthorizationStatusString;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResaleAuthorizationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResaleAuthorizationSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ResaleAuthorizationSummary.getter(ResaleAuthorizationSummary::name)).setter(ResaleAuthorizationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(ResaleAuthorizationSummary.getter(ResaleAuthorizationSummary::productId)).setter(ResaleAuthorizationSummary.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductName").getter(ResaleAuthorizationSummary.getter(ResaleAuthorizationSummary::productName)).setter(ResaleAuthorizationSummary.setter(Builder::productName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()}).build();
    private static final SdkField<String> MANUFACTURER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManufacturerAccountId").getter(ResaleAuthorizationSummary.getter(ResaleAuthorizationSummary::manufacturerAccountId)).setter(ResaleAuthorizationSummary.setter(Builder::manufacturerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManufacturerAccountId").build()}).build();
    private static final SdkField<String> MANUFACTURER_LEGAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManufacturerLegalName").getter(ResaleAuthorizationSummary.getter(ResaleAuthorizationSummary::manufacturerLegalName)).setter(ResaleAuthorizationSummary.setter(Builder::manufacturerLegalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManufacturerLegalName").build()}).build();
    private static final SdkField<String> RESELLER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResellerAccountID").getter(ResaleAuthorizationSummary.getter(ResaleAuthorizationSummary::resellerAccountID)).setter(ResaleAuthorizationSummary.setter(Builder::resellerAccountID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResellerAccountID").build()}).build();
    private static final SdkField<String> RESELLER_LEGAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResellerLegalName").getter(ResaleAuthorizationSummary.getter(ResaleAuthorizationSummary::resellerLegalName)).setter(ResaleAuthorizationSummary.setter(Builder::resellerLegalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResellerLegalName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ResaleAuthorizationSummary.getter(ResaleAuthorizationSummary::statusAsString)).setter(ResaleAuthorizationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> OFFER_EXTENDED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferExtendedStatus").getter(ResaleAuthorizationSummary.getter(ResaleAuthorizationSummary::offerExtendedStatus)).setter(ResaleAuthorizationSummary.setter(Builder::offerExtendedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferExtendedStatus").build()}).build();
    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedDate").getter(ResaleAuthorizationSummary.getter(ResaleAuthorizationSummary::createdDate)).setter(ResaleAuthorizationSummary.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<String> AVAILABILITY_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityEndDate").getter(ResaleAuthorizationSummary.getter(ResaleAuthorizationSummary::availabilityEndDate)).setter(ResaleAuthorizationSummary.setter(Builder::availabilityEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityEndDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PRODUCT_ID_FIELD, PRODUCT_NAME_FIELD, MANUFACTURER_ACCOUNT_ID_FIELD, MANUFACTURER_LEGAL_NAME_FIELD, RESELLER_ACCOUNT_ID_FIELD, RESELLER_LEGAL_NAME_FIELD, STATUS_FIELD, OFFER_EXTENDED_STATUS_FIELD, CREATED_DATE_FIELD, AVAILABILITY_END_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResaleAuthorizationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String productId;
    private final String productName;
    private final String manufacturerAccountId;
    private final String manufacturerLegalName;
    private final String resellerAccountID;
    private final String resellerLegalName;
    private final String status;
    private final String offerExtendedStatus;
    private final String createdDate;
    private final String availabilityEndDate;

    private ResaleAuthorizationSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.productId = builder.productId;
        this.productName = builder.productName;
        this.manufacturerAccountId = builder.manufacturerAccountId;
        this.manufacturerLegalName = builder.manufacturerLegalName;
        this.resellerAccountID = builder.resellerAccountID;
        this.resellerLegalName = builder.resellerLegalName;
        this.status = builder.status;
        this.offerExtendedStatus = builder.offerExtendedStatus;
        this.createdDate = builder.createdDate;
        this.availabilityEndDate = builder.availabilityEndDate;
    }

    public final String name() {
        return this.name;
    }

    public final String productId() {
        return this.productId;
    }

    public final String productName() {
        return this.productName;
    }

    public final String manufacturerAccountId() {
        return this.manufacturerAccountId;
    }

    public final String manufacturerLegalName() {
        return this.manufacturerLegalName;
    }

    public final String resellerAccountID() {
        return this.resellerAccountID;
    }

    public final String resellerLegalName() {
        return this.resellerLegalName;
    }

    public final ResaleAuthorizationStatusString status() {
        return ResaleAuthorizationStatusString.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String offerExtendedStatus() {
        return this.offerExtendedStatus;
    }

    public final String createdDate() {
        return this.createdDate;
    }

    public final String availabilityEndDate() {
        return this.availabilityEndDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productName());
        hashCode = 31 * hashCode + Objects.hashCode(this.manufacturerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.manufacturerLegalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resellerAccountID());
        hashCode = 31 * hashCode + Objects.hashCode(this.resellerLegalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offerExtendedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityEndDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResaleAuthorizationSummary)) {
            return false;
        }
        ResaleAuthorizationSummary other = (ResaleAuthorizationSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.productName(), other.productName()) && Objects.equals(this.manufacturerAccountId(), other.manufacturerAccountId()) && Objects.equals(this.manufacturerLegalName(), other.manufacturerLegalName()) && Objects.equals(this.resellerAccountID(), other.resellerAccountID()) && Objects.equals(this.resellerLegalName(), other.resellerLegalName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.offerExtendedStatus(), other.offerExtendedStatus()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.availabilityEndDate(), other.availabilityEndDate());
    }

    public final String toString() {
        return ToString.builder((String)"ResaleAuthorizationSummary").add("Name", (Object)this.name()).add("ProductId", (Object)this.productId()).add("ProductName", (Object)this.productName()).add("ManufacturerAccountId", (Object)this.manufacturerAccountId()).add("ManufacturerLegalName", (Object)this.manufacturerLegalName()).add("ResellerAccountID", (Object)this.resellerAccountID()).add("ResellerLegalName", (Object)this.resellerLegalName()).add("Status", (Object)this.statusAsString()).add("OfferExtendedStatus", (Object)this.offerExtendedStatus()).add("CreatedDate", (Object)this.createdDate()).add("AvailabilityEndDate", (Object)this.availabilityEndDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProductName": {
                return Optional.ofNullable(clazz.cast(this.productName()));
            }
            case "ManufacturerAccountId": {
                return Optional.ofNullable(clazz.cast(this.manufacturerAccountId()));
            }
            case "ManufacturerLegalName": {
                return Optional.ofNullable(clazz.cast(this.manufacturerLegalName()));
            }
            case "ResellerAccountID": {
                return Optional.ofNullable(clazz.cast(this.resellerAccountID()));
            }
            case "ResellerLegalName": {
                return Optional.ofNullable(clazz.cast(this.resellerLegalName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "OfferExtendedStatus": {
                return Optional.ofNullable(clazz.cast(this.offerExtendedStatus()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "AvailabilityEndDate": {
                return Optional.ofNullable(clazz.cast(this.availabilityEndDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Name", NAME_FIELD);
        map.put("ProductId", PRODUCT_ID_FIELD);
        map.put("ProductName", PRODUCT_NAME_FIELD);
        map.put("ManufacturerAccountId", MANUFACTURER_ACCOUNT_ID_FIELD);
        map.put("ManufacturerLegalName", MANUFACTURER_LEGAL_NAME_FIELD);
        map.put("ResellerAccountID", RESELLER_ACCOUNT_ID_FIELD);
        map.put("ResellerLegalName", RESELLER_LEGAL_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("OfferExtendedStatus", OFFER_EXTENDED_STATUS_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("AvailabilityEndDate", AVAILABILITY_END_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResaleAuthorizationSummary, T> g) {
        return obj -> g.apply((ResaleAuthorizationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String productId;
        private String productName;
        private String manufacturerAccountId;
        private String manufacturerLegalName;
        private String resellerAccountID;
        private String resellerLegalName;
        private String status;
        private String offerExtendedStatus;
        private String createdDate;
        private String availabilityEndDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ResaleAuthorizationSummary model) {
            this.name(model.name);
            this.productId(model.productId);
            this.productName(model.productName);
            this.manufacturerAccountId(model.manufacturerAccountId);
            this.manufacturerLegalName(model.manufacturerLegalName);
            this.resellerAccountID(model.resellerAccountID);
            this.resellerLegalName(model.resellerLegalName);
            this.status(model.status);
            this.offerExtendedStatus(model.offerExtendedStatus);
            this.createdDate(model.createdDate);
            this.availabilityEndDate(model.availabilityEndDate);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getProductName() {
            return this.productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final String getManufacturerAccountId() {
            return this.manufacturerAccountId;
        }

        public final void setManufacturerAccountId(String manufacturerAccountId) {
            this.manufacturerAccountId = manufacturerAccountId;
        }

        @Override
        public final Builder manufacturerAccountId(String manufacturerAccountId) {
            this.manufacturerAccountId = manufacturerAccountId;
            return this;
        }

        public final String getManufacturerLegalName() {
            return this.manufacturerLegalName;
        }

        public final void setManufacturerLegalName(String manufacturerLegalName) {
            this.manufacturerLegalName = manufacturerLegalName;
        }

        @Override
        public final Builder manufacturerLegalName(String manufacturerLegalName) {
            this.manufacturerLegalName = manufacturerLegalName;
            return this;
        }

        public final String getResellerAccountID() {
            return this.resellerAccountID;
        }

        public final void setResellerAccountID(String resellerAccountID) {
            this.resellerAccountID = resellerAccountID;
        }

        @Override
        public final Builder resellerAccountID(String resellerAccountID) {
            this.resellerAccountID = resellerAccountID;
            return this;
        }

        public final String getResellerLegalName() {
            return this.resellerLegalName;
        }

        public final void setResellerLegalName(String resellerLegalName) {
            this.resellerLegalName = resellerLegalName;
        }

        @Override
        public final Builder resellerLegalName(String resellerLegalName) {
            this.resellerLegalName = resellerLegalName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResaleAuthorizationStatusString status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getOfferExtendedStatus() {
            return this.offerExtendedStatus;
        }

        public final void setOfferExtendedStatus(String offerExtendedStatus) {
            this.offerExtendedStatus = offerExtendedStatus;
        }

        @Override
        public final Builder offerExtendedStatus(String offerExtendedStatus) {
            this.offerExtendedStatus = offerExtendedStatus;
            return this;
        }

        public final String getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getAvailabilityEndDate() {
            return this.availabilityEndDate;
        }

        public final void setAvailabilityEndDate(String availabilityEndDate) {
            this.availabilityEndDate = availabilityEndDate;
        }

        @Override
        public final Builder availabilityEndDate(String availabilityEndDate) {
            this.availabilityEndDate = availabilityEndDate;
            return this;
        }

        public ResaleAuthorizationSummary build() {
            return new ResaleAuthorizationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResaleAuthorizationSummary> {
        public Builder name(String var1);

        public Builder productId(String var1);

        public Builder productName(String var1);

        public Builder manufacturerAccountId(String var1);

        public Builder manufacturerLegalName(String var1);

        public Builder resellerAccountID(String var1);

        public Builder resellerLegalName(String var1);

        public Builder status(String var1);

        public Builder status(ResaleAuthorizationStatusString var1);

        public Builder offerExtendedStatus(String var1);

        public Builder createdDate(String var1);

        public Builder availabilityEndDate(String var1);
    }
}

