/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacecatalog.model.SaaSProductTitleFilterValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SaaSProductTitleFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SaaSProductTitleFilter> {
    private static final SdkField<List<String>> VALUE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValueList").getter(SaaSProductTitleFilter.getter(SaaSProductTitleFilter::valueList)).setter(SaaSProductTitleFilter.setter(Builder::valueList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WILD_CARD_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WildCardValue").getter(SaaSProductTitleFilter.getter(SaaSProductTitleFilter::wildCardValue)).setter(SaaSProductTitleFilter.setter(Builder::wildCardValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WildCardValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_LIST_FIELD, WILD_CARD_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SaaSProductTitleFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> valueList;
    private final String wildCardValue;

    private SaaSProductTitleFilter(BuilderImpl builder) {
        this.valueList = builder.valueList;
        this.wildCardValue = builder.wildCardValue;
    }

    public final boolean hasValueList() {
        return this.valueList != null && !(this.valueList instanceof SdkAutoConstructList);
    }

    public final List<String> valueList() {
        return this.valueList;
    }

    public final String wildCardValue() {
        return this.wildCardValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValueList() ? this.valueList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.wildCardValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SaaSProductTitleFilter)) {
            return false;
        }
        SaaSProductTitleFilter other = (SaaSProductTitleFilter)obj;
        return this.hasValueList() == other.hasValueList() && Objects.equals(this.valueList(), other.valueList()) && Objects.equals(this.wildCardValue(), other.wildCardValue());
    }

    public final String toString() {
        return ToString.builder((String)"SaaSProductTitleFilter").add("ValueList", this.hasValueList() ? this.valueList() : null).add("WildCardValue", (Object)this.wildCardValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ValueList": {
                return Optional.ofNullable(clazz.cast(this.valueList()));
            }
            case "WildCardValue": {
                return Optional.ofNullable(clazz.cast(this.wildCardValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ValueList", VALUE_LIST_FIELD);
        map.put("WildCardValue", WILD_CARD_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SaaSProductTitleFilter, T> g) {
        return obj -> g.apply((SaaSProductTitleFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> valueList = DefaultSdkAutoConstructList.getInstance();
        private String wildCardValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SaaSProductTitleFilter model) {
            this.valueList(model.valueList);
            this.wildCardValue(model.wildCardValue);
        }

        public final Collection<String> getValueList() {
            if (this.valueList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.valueList;
        }

        public final void setValueList(Collection<String> valueList) {
            this.valueList = SaaSProductTitleFilterValueListCopier.copy(valueList);
        }

        @Override
        public final Builder valueList(Collection<String> valueList) {
            this.valueList = SaaSProductTitleFilterValueListCopier.copy(valueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueList(String ... valueList) {
            this.valueList(Arrays.asList(valueList));
            return this;
        }

        public final String getWildCardValue() {
            return this.wildCardValue;
        }

        public final void setWildCardValue(String wildCardValue) {
            this.wildCardValue = wildCardValue;
        }

        @Override
        public final Builder wildCardValue(String wildCardValue) {
            this.wildCardValue = wildCardValue;
            return this;
        }

        public SaaSProductTitleFilter build() {
            return new SaaSProductTitleFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SaaSProductTitleFilter> {
        public Builder valueList(Collection<String> var1);

        public Builder valueList(String ... var1);

        public Builder wildCardValue(String var1);
    }
}

