/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkflowmonitor.NetworkFlowMonitorAsyncClient;
import software.amazon.awssdk.services.networkflowmonitor.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsMonitorTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorTopContributorsRow;

public class GetQueryResultsMonitorTopContributorsPublisher
implements SdkPublisher<GetQueryResultsMonitorTopContributorsResponse> {
    private final NetworkFlowMonitorAsyncClient client;
    private final GetQueryResultsMonitorTopContributorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetQueryResultsMonitorTopContributorsPublisher(NetworkFlowMonitorAsyncClient client, GetQueryResultsMonitorTopContributorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetQueryResultsMonitorTopContributorsPublisher(NetworkFlowMonitorAsyncClient client, GetQueryResultsMonitorTopContributorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetQueryResultsMonitorTopContributorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetQueryResultsMonitorTopContributorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MonitorTopContributorsRow> topContributors() {
        Function<GetQueryResultsMonitorTopContributorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.topContributors() != null) {
                return response.topContributors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetQueryResultsMonitorTopContributorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetQueryResultsMonitorTopContributorsResponseFetcher
    implements AsyncPageFetcher<GetQueryResultsMonitorTopContributorsResponse> {
        private GetQueryResultsMonitorTopContributorsResponseFetcher() {
        }

        public boolean hasNextPage(GetQueryResultsMonitorTopContributorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetQueryResultsMonitorTopContributorsResponse> nextPage(GetQueryResultsMonitorTopContributorsResponse previousPage) {
            if (previousPage == null) {
                return GetQueryResultsMonitorTopContributorsPublisher.this.client.getQueryResultsMonitorTopContributors(GetQueryResultsMonitorTopContributorsPublisher.this.firstRequest);
            }
            return GetQueryResultsMonitorTopContributorsPublisher.this.client.getQueryResultsMonitorTopContributors((GetQueryResultsMonitorTopContributorsRequest)((Object)GetQueryResultsMonitorTopContributorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

