/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkflowmonitor.NetworkFlowMonitorClient;
import software.amazon.awssdk.services.networkflowmonitor.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.ListMonitorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorSummary;

public class ListMonitorsIterable
implements SdkIterable<ListMonitorsResponse> {
    private final NetworkFlowMonitorClient client;
    private final ListMonitorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMonitorsIterable(NetworkFlowMonitorClient client, ListMonitorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMonitorsResponseFetcher();
    }

    public Iterator<ListMonitorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MonitorSummary> monitors() {
        Function<ListMonitorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.monitors() != null) {
                return response.monitors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMonitorsResponseFetcher
    implements SyncPageFetcher<ListMonitorsResponse> {
        private ListMonitorsResponseFetcher() {
        }

        public boolean hasNextPage(ListMonitorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMonitorsResponse nextPage(ListMonitorsResponse previousPage) {
            if (previousPage == null) {
                return ListMonitorsIterable.this.client.listMonitors(ListMonitorsIterable.this.firstRequest);
            }
            return ListMonitorsIterable.this.client.listMonitors((ListMonitorsRequest)((Object)ListMonitorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

