/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkflowmonitor.NetworkFlowMonitorClient;
import software.amazon.awssdk.services.networkflowmonitor.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkflowmonitor.model.ListScopesRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.ListScopesResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.ScopeSummary;

public class ListScopesIterable
implements SdkIterable<ListScopesResponse> {
    private final NetworkFlowMonitorClient client;
    private final ListScopesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListScopesIterable(NetworkFlowMonitorClient client, ListScopesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListScopesResponseFetcher();
    }

    public Iterator<ListScopesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScopeSummary> scopes() {
        Function<ListScopesResponse, Iterator> getIterator = response -> {
            if (response != null && response.scopes() != null) {
                return response.scopes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListScopesResponseFetcher
    implements SyncPageFetcher<ListScopesResponse> {
        private ListScopesResponseFetcher() {
        }

        public boolean hasNextPage(ListScopesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListScopesResponse nextPage(ListScopesResponse previousPage) {
            if (previousPage == null) {
                return ListScopesIterable.this.client.listScopes(ListScopesIterable.this.firstRequest);
            }
            return ListScopesIterable.this.client.listScopes((ListScopesRequest)((Object)ListScopesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

