/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRdsDbInstancesRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeRdsDbInstancesRequest.Builder, DescribeRdsDbInstancesRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(DescribeRdsDbInstancesRequest::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<List<String>> RDS_DB_INSTANCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RdsDbInstanceArns")
            .getter(getter(DescribeRdsDbInstancesRequest::rdsDbInstanceArns))
            .setter(setter(Builder::rdsDbInstanceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsDbInstanceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD,
            RDS_DB_INSTANCE_ARNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stackId;

    private final List<String> rdsDbInstanceArns;

    private DescribeRdsDbInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.rdsDbInstanceArns = builder.rdsDbInstanceArns;
    }

    /**
     * <p>
     * The ID of the stack with which the instances are registered. The operation returns descriptions of all registered
     * Amazon RDS instances.
     * </p>
     * 
     * @return The ID of the stack with which the instances are registered. The operation returns descriptions of all
     *         registered Amazon RDS instances.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RdsDbInstanceArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRdsDbInstanceArns() {
        return rdsDbInstanceArns != null && !(rdsDbInstanceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the ARNs of the instances to be described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRdsDbInstanceArns} method.
     * </p>
     * 
     * @return An array containing the ARNs of the instances to be described.
     */
    public final List<String> rdsDbInstanceArns() {
        return rdsDbInstanceArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRdsDbInstanceArns() ? rdsDbInstanceArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRdsDbInstancesRequest)) {
            return false;
        }
        DescribeRdsDbInstancesRequest other = (DescribeRdsDbInstancesRequest) obj;
        return Objects.equals(stackId(), other.stackId()) && hasRdsDbInstanceArns() == other.hasRdsDbInstanceArns()
                && Objects.equals(rdsDbInstanceArns(), other.rdsDbInstanceArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRdsDbInstancesRequest").add("StackId", stackId())
                .add("RdsDbInstanceArns", hasRdsDbInstanceArns() ? rdsDbInstanceArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "RdsDbInstanceArns":
            return Optional.ofNullable(clazz.cast(rdsDbInstanceArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackId", STACK_ID_FIELD);
        map.put("RdsDbInstanceArns", RDS_DB_INSTANCE_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRdsDbInstancesRequest, T> g) {
        return obj -> g.apply((DescribeRdsDbInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRdsDbInstancesRequest> {
        /**
         * <p>
         * The ID of the stack with which the instances are registered. The operation returns descriptions of all
         * registered Amazon RDS instances.
         * </p>
         * 
         * @param stackId
         *        The ID of the stack with which the instances are registered. The operation returns descriptions of all
         *        registered Amazon RDS instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * An array containing the ARNs of the instances to be described.
         * </p>
         * 
         * @param rdsDbInstanceArns
         *        An array containing the ARNs of the instances to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstanceArns(Collection<String> rdsDbInstanceArns);

        /**
         * <p>
         * An array containing the ARNs of the instances to be described.
         * </p>
         * 
         * @param rdsDbInstanceArns
         *        An array containing the ARNs of the instances to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstanceArns(String... rdsDbInstanceArns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String stackId;

        private List<String> rdsDbInstanceArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRdsDbInstancesRequest model) {
            super(model);
            stackId(model.stackId);
            rdsDbInstanceArns(model.rdsDbInstanceArns);
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final Collection<String> getRdsDbInstanceArns() {
            if (rdsDbInstanceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return rdsDbInstanceArns;
        }

        public final void setRdsDbInstanceArns(Collection<String> rdsDbInstanceArns) {
            this.rdsDbInstanceArns = StringsCopier.copy(rdsDbInstanceArns);
        }

        @Override
        public final Builder rdsDbInstanceArns(Collection<String> rdsDbInstanceArns) {
            this.rdsDbInstanceArns = StringsCopier.copy(rdsDbInstanceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rdsDbInstanceArns(String... rdsDbInstanceArns) {
            rdsDbInstanceArns(Arrays.asList(rdsDbInstanceArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRdsDbInstancesRequest build() {
            return new DescribeRdsDbInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
