/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the data needed by RDP clients such as the Microsoft Remote Desktop Connection to log in to the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemporaryCredential implements SdkPojo, Serializable,
        ToCopyableBuilder<TemporaryCredential.Builder, TemporaryCredential> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(TemporaryCredential::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(TemporaryCredential::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<Integer> VALID_FOR_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ValidForInMinutes").getter(getter(TemporaryCredential::validForInMinutes))
            .setter(setter(Builder::validForInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidForInMinutes").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(TemporaryCredential::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD,
            PASSWORD_FIELD, VALID_FOR_IN_MINUTES_FIELD, INSTANCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String username;

    private final String password;

    private final Integer validForInMinutes;

    private final String instanceId;

    private TemporaryCredential(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.validForInMinutes = builder.validForInMinutes;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The user name.
     * </p>
     * 
     * @return The user name.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The password.
     * </p>
     * 
     * @return The password.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * The length of time (in minutes) that the grant is valid. When the grant expires, at the end of this period, the
     * user will no longer be able to use the credentials to log in. If they are logged in at the time, they are
     * automatically logged out.
     * </p>
     * 
     * @return The length of time (in minutes) that the grant is valid. When the grant expires, at the end of this
     *         period, the user will no longer be able to use the credentials to log in. If they are logged in at the
     *         time, they are automatically logged out.
     */
    public final Integer validForInMinutes() {
        return validForInMinutes;
    }

    /**
     * <p>
     * The instance's OpsWorks Stacks ID.
     * </p>
     * 
     * @return The instance's OpsWorks Stacks ID.
     */
    public final String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(validForInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemporaryCredential)) {
            return false;
        }
        TemporaryCredential other = (TemporaryCredential) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(password(), other.password())
                && Objects.equals(validForInMinutes(), other.validForInMinutes())
                && Objects.equals(instanceId(), other.instanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemporaryCredential").add("Username", username()).add("Password", password())
                .add("ValidForInMinutes", validForInMinutes()).add("InstanceId", instanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "ValidForInMinutes":
            return Optional.ofNullable(clazz.cast(validForInMinutes()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Username", USERNAME_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("ValidForInMinutes", VALID_FOR_IN_MINUTES_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemporaryCredential, T> g) {
        return obj -> g.apply((TemporaryCredential) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemporaryCredential> {
        /**
         * <p>
         * The user name.
         * </p>
         * 
         * @param username
         *        The user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The password.
         * </p>
         * 
         * @param password
         *        The password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The length of time (in minutes) that the grant is valid. When the grant expires, at the end of this period,
         * the user will no longer be able to use the credentials to log in. If they are logged in at the time, they are
         * automatically logged out.
         * </p>
         * 
         * @param validForInMinutes
         *        The length of time (in minutes) that the grant is valid. When the grant expires, at the end of this
         *        period, the user will no longer be able to use the credentials to log in. If they are logged in at the
         *        time, they are automatically logged out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validForInMinutes(Integer validForInMinutes);

        /**
         * <p>
         * The instance's OpsWorks Stacks ID.
         * </p>
         * 
         * @param instanceId
         *        The instance's OpsWorks Stacks ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);
    }

    static final class BuilderImpl implements Builder {
        private String username;

        private String password;

        private Integer validForInMinutes;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(TemporaryCredential model) {
            username(model.username);
            password(model.password);
            validForInMinutes(model.validForInMinutes);
            instanceId(model.instanceId);
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final Integer getValidForInMinutes() {
            return validForInMinutes;
        }

        public final void setValidForInMinutes(Integer validForInMinutes) {
            this.validForInMinutes = validForInMinutes;
        }

        @Override
        public final Builder validForInMinutes(Integer validForInMinutes) {
            this.validForInMinutes = validForInMinutes;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        @Override
        public TemporaryCredential build() {
            return new TemporaryCredential(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
