/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.paymentcryptography.model.ImportKeyMaterial;
import software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm;
import software.amazon.awssdk.services.paymentcryptography.model.PaymentCryptographyRequest;
import software.amazon.awssdk.services.paymentcryptography.model.Tag;
import software.amazon.awssdk.services.paymentcryptography.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportKeyRequest
extends PaymentCryptographyRequest
implements ToCopyableBuilder<Builder, ImportKeyRequest> {
    private static final SdkField<ImportKeyMaterial> KEY_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyMaterial").getter(ImportKeyRequest.getter(ImportKeyRequest::keyMaterial)).setter(ImportKeyRequest.setter(Builder::keyMaterial)).constructor(ImportKeyMaterial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterial").build()}).build();
    private static final SdkField<String> KEY_CHECK_VALUE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyCheckValueAlgorithm").getter(ImportKeyRequest.getter(ImportKeyRequest::keyCheckValueAlgorithmAsString)).setter(ImportKeyRequest.setter(Builder::keyCheckValueAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValueAlgorithm").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(ImportKeyRequest.getter(ImportKeyRequest::enabled)).setter(ImportKeyRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ImportKeyRequest.getter(ImportKeyRequest::tags)).setter(ImportKeyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_MATERIAL_FIELD, KEY_CHECK_VALUE_ALGORITHM_FIELD, ENABLED_FIELD, TAGS_FIELD));
    private final ImportKeyMaterial keyMaterial;
    private final String keyCheckValueAlgorithm;
    private final Boolean enabled;
    private final List<Tag> tags;

    private ImportKeyRequest(BuilderImpl builder) {
        super(builder);
        this.keyMaterial = builder.keyMaterial;
        this.keyCheckValueAlgorithm = builder.keyCheckValueAlgorithm;
        this.enabled = builder.enabled;
        this.tags = builder.tags;
    }

    public final ImportKeyMaterial keyMaterial() {
        return this.keyMaterial;
    }

    public final KeyCheckValueAlgorithm keyCheckValueAlgorithm() {
        return KeyCheckValueAlgorithm.fromValue(this.keyCheckValueAlgorithm);
    }

    public final String keyCheckValueAlgorithmAsString() {
        return this.keyCheckValueAlgorithm;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCheckValueAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyRequest)) {
            return false;
        }
        ImportKeyRequest other = (ImportKeyRequest)((Object)obj);
        return Objects.equals(this.keyMaterial(), other.keyMaterial()) && Objects.equals(this.keyCheckValueAlgorithmAsString(), other.keyCheckValueAlgorithmAsString()) && Objects.equals(this.enabled(), other.enabled()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ImportKeyRequest").add("KeyMaterial", (Object)this.keyMaterial()).add("KeyCheckValueAlgorithm", (Object)this.keyCheckValueAlgorithmAsString()).add("Enabled", (Object)this.enabled()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyMaterial": {
                return Optional.ofNullable(clazz.cast(this.keyMaterial()));
            }
            case "KeyCheckValueAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyCheckValueAlgorithmAsString()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportKeyRequest, T> g) {
        return obj -> g.apply((ImportKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyRequest.BuilderImpl
    implements Builder {
        private ImportKeyMaterial keyMaterial;
        private String keyCheckValueAlgorithm;
        private Boolean enabled;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyRequest model) {
            super(model);
            this.keyMaterial(model.keyMaterial);
            this.keyCheckValueAlgorithm(model.keyCheckValueAlgorithm);
            this.enabled(model.enabled);
            this.tags(model.tags);
        }

        public final ImportKeyMaterial.Builder getKeyMaterial() {
            return this.keyMaterial != null ? this.keyMaterial.toBuilder() : null;
        }

        public final void setKeyMaterial(ImportKeyMaterial.BuilderImpl keyMaterial) {
            this.keyMaterial = keyMaterial != null ? keyMaterial.build() : null;
        }

        @Override
        public final Builder keyMaterial(ImportKeyMaterial keyMaterial) {
            this.keyMaterial = keyMaterial;
            return this;
        }

        public final String getKeyCheckValueAlgorithm() {
            return this.keyCheckValueAlgorithm;
        }

        public final void setKeyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
            return this;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm(keyCheckValueAlgorithm == null ? null : keyCheckValueAlgorithm.toString());
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportKeyRequest build() {
            return new ImportKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PaymentCryptographyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportKeyRequest> {
        public Builder keyMaterial(ImportKeyMaterial var1);

        default public Builder keyMaterial(Consumer<ImportKeyMaterial.Builder> keyMaterial) {
            return this.keyMaterial((ImportKeyMaterial)((ImportKeyMaterial.Builder)ImportKeyMaterial.builder().applyMutation(keyMaterial)).build());
        }

        public Builder keyCheckValueAlgorithm(String var1);

        public Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm var1);

        public Builder enabled(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

