/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.paymentcryptography.model.ImportKeyCryptogram;
import software.amazon.awssdk.services.paymentcryptography.model.ImportTr31KeyBlock;
import software.amazon.awssdk.services.paymentcryptography.model.ImportTr34KeyBlock;
import software.amazon.awssdk.services.paymentcryptography.model.RootCertificatePublicKey;
import software.amazon.awssdk.services.paymentcryptography.model.TrustedCertificatePublicKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportKeyMaterial
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportKeyMaterial> {
    private static final SdkField<RootCertificatePublicKey> ROOT_CERTIFICATE_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RootCertificatePublicKey").getter(ImportKeyMaterial.getter(ImportKeyMaterial::rootCertificatePublicKey)).setter(ImportKeyMaterial.setter(Builder::rootCertificatePublicKey)).constructor(RootCertificatePublicKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootCertificatePublicKey").build()}).build();
    private static final SdkField<TrustedCertificatePublicKey> TRUSTED_CERTIFICATE_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrustedCertificatePublicKey").getter(ImportKeyMaterial.getter(ImportKeyMaterial::trustedCertificatePublicKey)).setter(ImportKeyMaterial.setter(Builder::trustedCertificatePublicKey)).constructor(TrustedCertificatePublicKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedCertificatePublicKey").build()}).build();
    private static final SdkField<ImportTr31KeyBlock> TR31_KEY_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tr31KeyBlock").getter(ImportKeyMaterial.getter(ImportKeyMaterial::tr31KeyBlock)).setter(ImportKeyMaterial.setter(Builder::tr31KeyBlock)).constructor(ImportTr31KeyBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tr31KeyBlock").build()}).build();
    private static final SdkField<ImportTr34KeyBlock> TR34_KEY_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tr34KeyBlock").getter(ImportKeyMaterial.getter(ImportKeyMaterial::tr34KeyBlock)).setter(ImportKeyMaterial.setter(Builder::tr34KeyBlock)).constructor(ImportTr34KeyBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tr34KeyBlock").build()}).build();
    private static final SdkField<ImportKeyCryptogram> KEY_CRYPTOGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyCryptogram").getter(ImportKeyMaterial.getter(ImportKeyMaterial::keyCryptogram)).setter(ImportKeyMaterial.setter(Builder::keyCryptogram)).constructor(ImportKeyCryptogram::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCryptogram").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOT_CERTIFICATE_PUBLIC_KEY_FIELD, TRUSTED_CERTIFICATE_PUBLIC_KEY_FIELD, TR31_KEY_BLOCK_FIELD, TR34_KEY_BLOCK_FIELD, KEY_CRYPTOGRAM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RootCertificatePublicKey", ROOT_CERTIFICATE_PUBLIC_KEY_FIELD);
            this.put("TrustedCertificatePublicKey", TRUSTED_CERTIFICATE_PUBLIC_KEY_FIELD);
            this.put("Tr31KeyBlock", TR31_KEY_BLOCK_FIELD);
            this.put("Tr34KeyBlock", TR34_KEY_BLOCK_FIELD);
            this.put("KeyCryptogram", KEY_CRYPTOGRAM_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final RootCertificatePublicKey rootCertificatePublicKey;
    private final TrustedCertificatePublicKey trustedCertificatePublicKey;
    private final ImportTr31KeyBlock tr31KeyBlock;
    private final ImportTr34KeyBlock tr34KeyBlock;
    private final ImportKeyCryptogram keyCryptogram;
    private final Type type;

    private ImportKeyMaterial(BuilderImpl builder) {
        this.rootCertificatePublicKey = builder.rootCertificatePublicKey;
        this.trustedCertificatePublicKey = builder.trustedCertificatePublicKey;
        this.tr31KeyBlock = builder.tr31KeyBlock;
        this.tr34KeyBlock = builder.tr34KeyBlock;
        this.keyCryptogram = builder.keyCryptogram;
        this.type = builder.type;
    }

    public final RootCertificatePublicKey rootCertificatePublicKey() {
        return this.rootCertificatePublicKey;
    }

    public final TrustedCertificatePublicKey trustedCertificatePublicKey() {
        return this.trustedCertificatePublicKey;
    }

    public final ImportTr31KeyBlock tr31KeyBlock() {
        return this.tr31KeyBlock;
    }

    public final ImportTr34KeyBlock tr34KeyBlock() {
        return this.tr34KeyBlock;
    }

    public final ImportKeyCryptogram keyCryptogram() {
        return this.keyCryptogram;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rootCertificatePublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedCertificatePublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.tr31KeyBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.tr34KeyBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCryptogram());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyMaterial)) {
            return false;
        }
        ImportKeyMaterial other = (ImportKeyMaterial)obj;
        return Objects.equals(this.rootCertificatePublicKey(), other.rootCertificatePublicKey()) && Objects.equals(this.trustedCertificatePublicKey(), other.trustedCertificatePublicKey()) && Objects.equals(this.tr31KeyBlock(), other.tr31KeyBlock()) && Objects.equals(this.tr34KeyBlock(), other.tr34KeyBlock()) && Objects.equals(this.keyCryptogram(), other.keyCryptogram());
    }

    public final String toString() {
        return ToString.builder((String)"ImportKeyMaterial").add("RootCertificatePublicKey", (Object)this.rootCertificatePublicKey()).add("TrustedCertificatePublicKey", (Object)this.trustedCertificatePublicKey()).add("Tr31KeyBlock", (Object)this.tr31KeyBlock()).add("Tr34KeyBlock", (Object)this.tr34KeyBlock()).add("KeyCryptogram", (Object)this.keyCryptogram()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RootCertificatePublicKey": {
                return Optional.ofNullable(clazz.cast(this.rootCertificatePublicKey()));
            }
            case "TrustedCertificatePublicKey": {
                return Optional.ofNullable(clazz.cast(this.trustedCertificatePublicKey()));
            }
            case "Tr31KeyBlock": {
                return Optional.ofNullable(clazz.cast(this.tr31KeyBlock()));
            }
            case "Tr34KeyBlock": {
                return Optional.ofNullable(clazz.cast(this.tr34KeyBlock()));
            }
            case "KeyCryptogram": {
                return Optional.ofNullable(clazz.cast(this.keyCryptogram()));
            }
        }
        return Optional.empty();
    }

    public static ImportKeyMaterial fromRootCertificatePublicKey(RootCertificatePublicKey rootCertificatePublicKey) {
        return (ImportKeyMaterial)ImportKeyMaterial.builder().rootCertificatePublicKey(rootCertificatePublicKey).build();
    }

    public static ImportKeyMaterial fromRootCertificatePublicKey(Consumer<RootCertificatePublicKey.Builder> rootCertificatePublicKey) {
        RootCertificatePublicKey.Builder builder = RootCertificatePublicKey.builder();
        rootCertificatePublicKey.accept(builder);
        return ImportKeyMaterial.fromRootCertificatePublicKey((RootCertificatePublicKey)builder.build());
    }

    public static ImportKeyMaterial fromTrustedCertificatePublicKey(TrustedCertificatePublicKey trustedCertificatePublicKey) {
        return (ImportKeyMaterial)ImportKeyMaterial.builder().trustedCertificatePublicKey(trustedCertificatePublicKey).build();
    }

    public static ImportKeyMaterial fromTrustedCertificatePublicKey(Consumer<TrustedCertificatePublicKey.Builder> trustedCertificatePublicKey) {
        TrustedCertificatePublicKey.Builder builder = TrustedCertificatePublicKey.builder();
        trustedCertificatePublicKey.accept(builder);
        return ImportKeyMaterial.fromTrustedCertificatePublicKey((TrustedCertificatePublicKey)builder.build());
    }

    public static ImportKeyMaterial fromTr31KeyBlock(ImportTr31KeyBlock tr31KeyBlock) {
        return (ImportKeyMaterial)ImportKeyMaterial.builder().tr31KeyBlock(tr31KeyBlock).build();
    }

    public static ImportKeyMaterial fromTr31KeyBlock(Consumer<ImportTr31KeyBlock.Builder> tr31KeyBlock) {
        ImportTr31KeyBlock.Builder builder = ImportTr31KeyBlock.builder();
        tr31KeyBlock.accept(builder);
        return ImportKeyMaterial.fromTr31KeyBlock((ImportTr31KeyBlock)builder.build());
    }

    public static ImportKeyMaterial fromTr34KeyBlock(ImportTr34KeyBlock tr34KeyBlock) {
        return (ImportKeyMaterial)ImportKeyMaterial.builder().tr34KeyBlock(tr34KeyBlock).build();
    }

    public static ImportKeyMaterial fromTr34KeyBlock(Consumer<ImportTr34KeyBlock.Builder> tr34KeyBlock) {
        ImportTr34KeyBlock.Builder builder = ImportTr34KeyBlock.builder();
        tr34KeyBlock.accept(builder);
        return ImportKeyMaterial.fromTr34KeyBlock((ImportTr34KeyBlock)builder.build());
    }

    public static ImportKeyMaterial fromKeyCryptogram(ImportKeyCryptogram keyCryptogram) {
        return (ImportKeyMaterial)ImportKeyMaterial.builder().keyCryptogram(keyCryptogram).build();
    }

    public static ImportKeyMaterial fromKeyCryptogram(Consumer<ImportKeyCryptogram.Builder> keyCryptogram) {
        ImportKeyCryptogram.Builder builder = ImportKeyCryptogram.builder();
        keyCryptogram.accept(builder);
        return ImportKeyMaterial.fromKeyCryptogram((ImportKeyCryptogram)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportKeyMaterial, T> g) {
        return obj -> g.apply((ImportKeyMaterial)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ROOT_CERTIFICATE_PUBLIC_KEY,
        TRUSTED_CERTIFICATE_PUBLIC_KEY,
        TR31_KEY_BLOCK,
        TR34_KEY_BLOCK,
        KEY_CRYPTOGRAM,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private RootCertificatePublicKey rootCertificatePublicKey;
        private TrustedCertificatePublicKey trustedCertificatePublicKey;
        private ImportTr31KeyBlock tr31KeyBlock;
        private ImportTr34KeyBlock tr34KeyBlock;
        private ImportKeyCryptogram keyCryptogram;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyMaterial model) {
            this.rootCertificatePublicKey(model.rootCertificatePublicKey);
            this.trustedCertificatePublicKey(model.trustedCertificatePublicKey);
            this.tr31KeyBlock(model.tr31KeyBlock);
            this.tr34KeyBlock(model.tr34KeyBlock);
            this.keyCryptogram(model.keyCryptogram);
        }

        public final RootCertificatePublicKey.Builder getRootCertificatePublicKey() {
            return this.rootCertificatePublicKey != null ? this.rootCertificatePublicKey.toBuilder() : null;
        }

        public final void setRootCertificatePublicKey(RootCertificatePublicKey.BuilderImpl rootCertificatePublicKey) {
            RootCertificatePublicKey oldValue = this.rootCertificatePublicKey;
            this.rootCertificatePublicKey = rootCertificatePublicKey != null ? rootCertificatePublicKey.build() : null;
            this.handleUnionValueChange(Type.ROOT_CERTIFICATE_PUBLIC_KEY, oldValue, this.rootCertificatePublicKey);
        }

        @Override
        public final Builder rootCertificatePublicKey(RootCertificatePublicKey rootCertificatePublicKey) {
            RootCertificatePublicKey oldValue = this.rootCertificatePublicKey;
            this.rootCertificatePublicKey = rootCertificatePublicKey;
            this.handleUnionValueChange(Type.ROOT_CERTIFICATE_PUBLIC_KEY, oldValue, this.rootCertificatePublicKey);
            return this;
        }

        public final TrustedCertificatePublicKey.Builder getTrustedCertificatePublicKey() {
            return this.trustedCertificatePublicKey != null ? this.trustedCertificatePublicKey.toBuilder() : null;
        }

        public final void setTrustedCertificatePublicKey(TrustedCertificatePublicKey.BuilderImpl trustedCertificatePublicKey) {
            TrustedCertificatePublicKey oldValue = this.trustedCertificatePublicKey;
            this.trustedCertificatePublicKey = trustedCertificatePublicKey != null ? trustedCertificatePublicKey.build() : null;
            this.handleUnionValueChange(Type.TRUSTED_CERTIFICATE_PUBLIC_KEY, oldValue, this.trustedCertificatePublicKey);
        }

        @Override
        public final Builder trustedCertificatePublicKey(TrustedCertificatePublicKey trustedCertificatePublicKey) {
            TrustedCertificatePublicKey oldValue = this.trustedCertificatePublicKey;
            this.trustedCertificatePublicKey = trustedCertificatePublicKey;
            this.handleUnionValueChange(Type.TRUSTED_CERTIFICATE_PUBLIC_KEY, oldValue, this.trustedCertificatePublicKey);
            return this;
        }

        public final ImportTr31KeyBlock.Builder getTr31KeyBlock() {
            return this.tr31KeyBlock != null ? this.tr31KeyBlock.toBuilder() : null;
        }

        public final void setTr31KeyBlock(ImportTr31KeyBlock.BuilderImpl tr31KeyBlock) {
            ImportTr31KeyBlock oldValue = this.tr31KeyBlock;
            this.tr31KeyBlock = tr31KeyBlock != null ? tr31KeyBlock.build() : null;
            this.handleUnionValueChange(Type.TR31_KEY_BLOCK, oldValue, this.tr31KeyBlock);
        }

        @Override
        public final Builder tr31KeyBlock(ImportTr31KeyBlock tr31KeyBlock) {
            ImportTr31KeyBlock oldValue = this.tr31KeyBlock;
            this.tr31KeyBlock = tr31KeyBlock;
            this.handleUnionValueChange(Type.TR31_KEY_BLOCK, oldValue, this.tr31KeyBlock);
            return this;
        }

        public final ImportTr34KeyBlock.Builder getTr34KeyBlock() {
            return this.tr34KeyBlock != null ? this.tr34KeyBlock.toBuilder() : null;
        }

        public final void setTr34KeyBlock(ImportTr34KeyBlock.BuilderImpl tr34KeyBlock) {
            ImportTr34KeyBlock oldValue = this.tr34KeyBlock;
            this.tr34KeyBlock = tr34KeyBlock != null ? tr34KeyBlock.build() : null;
            this.handleUnionValueChange(Type.TR34_KEY_BLOCK, oldValue, this.tr34KeyBlock);
        }

        @Override
        public final Builder tr34KeyBlock(ImportTr34KeyBlock tr34KeyBlock) {
            ImportTr34KeyBlock oldValue = this.tr34KeyBlock;
            this.tr34KeyBlock = tr34KeyBlock;
            this.handleUnionValueChange(Type.TR34_KEY_BLOCK, oldValue, this.tr34KeyBlock);
            return this;
        }

        public final ImportKeyCryptogram.Builder getKeyCryptogram() {
            return this.keyCryptogram != null ? this.keyCryptogram.toBuilder() : null;
        }

        public final void setKeyCryptogram(ImportKeyCryptogram.BuilderImpl keyCryptogram) {
            ImportKeyCryptogram oldValue = this.keyCryptogram;
            this.keyCryptogram = keyCryptogram != null ? keyCryptogram.build() : null;
            this.handleUnionValueChange(Type.KEY_CRYPTOGRAM, oldValue, this.keyCryptogram);
        }

        @Override
        public final Builder keyCryptogram(ImportKeyCryptogram keyCryptogram) {
            ImportKeyCryptogram oldValue = this.keyCryptogram;
            this.keyCryptogram = keyCryptogram;
            this.handleUnionValueChange(Type.KEY_CRYPTOGRAM, oldValue, this.keyCryptogram);
            return this;
        }

        public ImportKeyMaterial build() {
            return new ImportKeyMaterial(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportKeyMaterial> {
        public Builder rootCertificatePublicKey(RootCertificatePublicKey var1);

        default public Builder rootCertificatePublicKey(Consumer<RootCertificatePublicKey.Builder> rootCertificatePublicKey) {
            return this.rootCertificatePublicKey((RootCertificatePublicKey)((RootCertificatePublicKey.Builder)RootCertificatePublicKey.builder().applyMutation(rootCertificatePublicKey)).build());
        }

        public Builder trustedCertificatePublicKey(TrustedCertificatePublicKey var1);

        default public Builder trustedCertificatePublicKey(Consumer<TrustedCertificatePublicKey.Builder> trustedCertificatePublicKey) {
            return this.trustedCertificatePublicKey((TrustedCertificatePublicKey)((TrustedCertificatePublicKey.Builder)TrustedCertificatePublicKey.builder().applyMutation(trustedCertificatePublicKey)).build());
        }

        public Builder tr31KeyBlock(ImportTr31KeyBlock var1);

        default public Builder tr31KeyBlock(Consumer<ImportTr31KeyBlock.Builder> tr31KeyBlock) {
            return this.tr31KeyBlock((ImportTr31KeyBlock)((ImportTr31KeyBlock.Builder)ImportTr31KeyBlock.builder().applyMutation(tr31KeyBlock)).build());
        }

        public Builder tr34KeyBlock(ImportTr34KeyBlock var1);

        default public Builder tr34KeyBlock(Consumer<ImportTr34KeyBlock.Builder> tr34KeyBlock) {
            return this.tr34KeyBlock((ImportTr34KeyBlock)((ImportTr34KeyBlock.Builder)ImportTr34KeyBlock.builder().applyMutation(tr34KeyBlock)).build());
        }

        public Builder keyCryptogram(ImportKeyCryptogram var1);

        default public Builder keyCryptogram(Consumer<ImportKeyCryptogram.Builder> keyCryptogram) {
            return this.keyCryptogram((ImportKeyCryptogram)((ImportKeyCryptogram.Builder)ImportKeyCryptogram.builder().applyMutation(keyCryptogram)).build());
        }
    }
}

