/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.ContentDisposition;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMessageTemplateAttachmentRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, CreateMessageTemplateAttachmentRequest> {
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("body").getter(CreateMessageTemplateAttachmentRequest.getter(CreateMessageTemplateAttachmentRequest::body)).setter(CreateMessageTemplateAttachmentRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateMessageTemplateAttachmentRequest.getter(CreateMessageTemplateAttachmentRequest::clientToken)).setter(CreateMessageTemplateAttachmentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> CONTENT_DISPOSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentDisposition").getter(CreateMessageTemplateAttachmentRequest.getter(CreateMessageTemplateAttachmentRequest::contentDispositionAsString)).setter(CreateMessageTemplateAttachmentRequest.setter(Builder::contentDisposition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentDisposition").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(CreateMessageTemplateAttachmentRequest.getter(CreateMessageTemplateAttachmentRequest::knowledgeBaseId)).setter(CreateMessageTemplateAttachmentRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> MESSAGE_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageTemplateId").getter(CreateMessageTemplateAttachmentRequest.getter(CreateMessageTemplateAttachmentRequest::messageTemplateId)).setter(CreateMessageTemplateAttachmentRequest.setter(Builder::messageTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("messageTemplateId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateMessageTemplateAttachmentRequest.getter(CreateMessageTemplateAttachmentRequest::name)).setter(CreateMessageTemplateAttachmentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, CLIENT_TOKEN_FIELD, CONTENT_DISPOSITION_FIELD, KNOWLEDGE_BASE_ID_FIELD, MESSAGE_TEMPLATE_ID_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("body", BODY_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("contentDisposition", CONTENT_DISPOSITION_FIELD);
            this.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
            this.put("messageTemplateId", MESSAGE_TEMPLATE_ID_FIELD);
            this.put("name", NAME_FIELD);
        }
    });
    private final String body;
    private final String clientToken;
    private final String contentDisposition;
    private final String knowledgeBaseId;
    private final String messageTemplateId;
    private final String name;

    private CreateMessageTemplateAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.body = builder.body;
        this.clientToken = builder.clientToken;
        this.contentDisposition = builder.contentDisposition;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.messageTemplateId = builder.messageTemplateId;
        this.name = builder.name;
    }

    public final String body() {
        return this.body;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ContentDisposition contentDisposition() {
        return ContentDisposition.fromValue(this.contentDisposition);
    }

    public final String contentDispositionAsString() {
        return this.contentDisposition;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String messageTemplateId() {
        return this.messageTemplateId;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMessageTemplateAttachmentRequest)) {
            return false;
        }
        CreateMessageTemplateAttachmentRequest other = (CreateMessageTemplateAttachmentRequest)((Object)obj);
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.contentDispositionAsString(), other.contentDispositionAsString()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.messageTemplateId(), other.messageTemplateId()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMessageTemplateAttachmentRequest").add("Body", (Object)(this.body() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)this.clientToken()).add("ContentDisposition", (Object)this.contentDispositionAsString()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("MessageTemplateId", (Object)this.messageTemplateId()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "contentDisposition": {
                return Optional.ofNullable(clazz.cast(this.contentDispositionAsString()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "messageTemplateId": {
                return Optional.ofNullable(clazz.cast(this.messageTemplateId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateMessageTemplateAttachmentRequest, T> g) {
        return obj -> g.apply((CreateMessageTemplateAttachmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String body;
        private String clientToken;
        private String contentDisposition;
        private String knowledgeBaseId;
        private String messageTemplateId;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMessageTemplateAttachmentRequest model) {
            super(model);
            this.body(model.body);
            this.clientToken(model.clientToken);
            this.contentDisposition(model.contentDisposition);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.messageTemplateId(model.messageTemplateId);
            this.name(model.name);
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getContentDisposition() {
            return this.contentDisposition;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        @Override
        public final Builder contentDisposition(ContentDisposition contentDisposition) {
            this.contentDisposition(contentDisposition == null ? null : contentDisposition.toString());
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getMessageTemplateId() {
            return this.messageTemplateId;
        }

        public final void setMessageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
        }

        @Override
        public final Builder messageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMessageTemplateAttachmentRequest build() {
            return new CreateMessageTemplateAttachmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMessageTemplateAttachmentRequest> {
        public Builder body(String var1);

        public Builder clientToken(String var1);

        public Builder contentDisposition(String var1);

        public Builder contentDisposition(ContentDisposition var1);

        public Builder knowledgeBaseId(String var1);

        public Builder messageTemplateId(String var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

