/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.RelevanceLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RankingData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RankingData> {
    private static final SdkField<String> RELEVANCE_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relevanceLevel").getter(RankingData.getter(RankingData::relevanceLevelAsString)).setter(RankingData.setter(Builder::relevanceLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceLevel").build()}).build();
    private static final SdkField<Double> RELEVANCE_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("relevanceScore").getter(RankingData.getter(RankingData::relevanceScore)).setter(RankingData.setter(Builder::relevanceScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceScore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELEVANCE_LEVEL_FIELD, RELEVANCE_SCORE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RankingData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String relevanceLevel;
    private final Double relevanceScore;

    private RankingData(BuilderImpl builder) {
        this.relevanceLevel = builder.relevanceLevel;
        this.relevanceScore = builder.relevanceScore;
    }

    public final RelevanceLevel relevanceLevel() {
        return RelevanceLevel.fromValue(this.relevanceLevel);
    }

    public final String relevanceLevelAsString() {
        return this.relevanceLevel;
    }

    public final Double relevanceScore() {
        return this.relevanceScore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.relevanceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.relevanceScore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RankingData)) {
            return false;
        }
        RankingData other = (RankingData)obj;
        return Objects.equals(this.relevanceLevelAsString(), other.relevanceLevelAsString()) && Objects.equals(this.relevanceScore(), other.relevanceScore());
    }

    public final String toString() {
        return ToString.builder((String)"RankingData").add("RelevanceLevel", (Object)this.relevanceLevelAsString()).add("RelevanceScore", (Object)this.relevanceScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relevanceLevel": {
                return Optional.ofNullable(clazz.cast(this.relevanceLevelAsString()));
            }
            case "relevanceScore": {
                return Optional.ofNullable(clazz.cast(this.relevanceScore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("relevanceLevel", RELEVANCE_LEVEL_FIELD);
        map.put("relevanceScore", RELEVANCE_SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RankingData, T> g) {
        return obj -> g.apply((RankingData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String relevanceLevel;
        private Double relevanceScore;

        private BuilderImpl() {
        }

        private BuilderImpl(RankingData model) {
            this.relevanceLevel(model.relevanceLevel);
            this.relevanceScore(model.relevanceScore);
        }

        public final String getRelevanceLevel() {
            return this.relevanceLevel;
        }

        public final void setRelevanceLevel(String relevanceLevel) {
            this.relevanceLevel = relevanceLevel;
        }

        @Override
        public final Builder relevanceLevel(String relevanceLevel) {
            this.relevanceLevel = relevanceLevel;
            return this;
        }

        @Override
        public final Builder relevanceLevel(RelevanceLevel relevanceLevel) {
            this.relevanceLevel(relevanceLevel == null ? null : relevanceLevel.toString());
            return this;
        }

        public final Double getRelevanceScore() {
            return this.relevanceScore;
        }

        public final void setRelevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
        }

        @Override
        public final Builder relevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
            return this;
        }

        public RankingData build() {
            return new RankingData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RankingData> {
        public Builder relevanceLevel(String var1);

        public Builder relevanceLevel(RelevanceLevel var1);

        public Builder relevanceScore(Double var1);
    }
}

