/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter;
import software.amazon.awssdk.services.redshiftserverless.model.ConfigParameterListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.Endpoint;
import software.amazon.awssdk.services.redshiftserverless.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.SubnetIdListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.VpcIdsCopier;
import software.amazon.awssdk.services.redshiftserverless.model.WorkgroupStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Workgroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Workgroup> {
    private static final SdkField<Integer> BASE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("baseCapacity").getter(Workgroup.getter(Workgroup::baseCapacity)).setter(Workgroup.setter(Builder::baseCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCapacity").build()}).build();
    private static final SdkField<List<ConfigParameter>> CONFIG_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configParameters").getter(Workgroup.getter(Workgroup::configParameters)).setter(Workgroup.setter(Builder::configParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(Workgroup.getter(Workgroup::creationDate)).setter(Workgroup.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<String>> CROSS_ACCOUNT_VPCS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("crossAccountVpcs").getter(Workgroup.getter(Workgroup::crossAccountVpcs)).setter(Workgroup.setter(Builder::crossAccountVpcs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountVpcs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customDomainCertificateArn").getter(Workgroup.getter(Workgroup::customDomainCertificateArn)).setter(Workgroup.setter(Builder::customDomainCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainCertificateArn").build()}).build();
    private static final SdkField<Instant> CUSTOM_DOMAIN_CERTIFICATE_EXPIRY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("customDomainCertificateExpiryTime").getter(Workgroup.getter(Workgroup::customDomainCertificateExpiryTime)).setter(Workgroup.setter(Builder::customDomainCertificateExpiryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainCertificateExpiryTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customDomainName").getter(Workgroup.getter(Workgroup::customDomainName)).setter(Workgroup.setter(Builder::customDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()}).build();
    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("endpoint").getter(Workgroup.getter(Workgroup::endpoint)).setter(Workgroup.setter(Builder::endpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enhancedVpcRouting").getter(Workgroup.getter(Workgroup::enhancedVpcRouting)).setter(Workgroup.setter(Builder::enhancedVpcRouting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedVpcRouting").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxCapacity").getter(Workgroup.getter(Workgroup::maxCapacity)).setter(Workgroup.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCapacity").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(Workgroup.getter(Workgroup::namespaceName)).setter(Workgroup.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<String> PATCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("patchVersion").getter(Workgroup.getter(Workgroup::patchVersion)).setter(Workgroup.setter(Builder::patchVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patchVersion").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(Workgroup.getter(Workgroup::port)).setter(Workgroup.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publiclyAccessible").getter(Workgroup.getter(Workgroup::publiclyAccessible)).setter(Workgroup.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(Workgroup.getter(Workgroup::securityGroupIds)).setter(Workgroup.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Workgroup.getter(Workgroup::statusAsString)).setter(Workgroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnetIds").getter(Workgroup.getter(Workgroup::subnetIds)).setter(Workgroup.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKGROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workgroupArn").getter(Workgroup.getter(Workgroup::workgroupArn)).setter(Workgroup.setter(Builder::workgroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupArn").build()}).build();
    private static final SdkField<String> WORKGROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workgroupId").getter(Workgroup.getter(Workgroup::workgroupId)).setter(Workgroup.setter(Builder::workgroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupId").build()}).build();
    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workgroupName").getter(Workgroup.getter(Workgroup::workgroupName)).setter(Workgroup.setter(Builder::workgroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()}).build();
    private static final SdkField<String> WORKGROUP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workgroupVersion").getter(Workgroup.getter(Workgroup::workgroupVersion)).setter(Workgroup.setter(Builder::workgroupVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_CAPACITY_FIELD, CONFIG_PARAMETERS_FIELD, CREATION_DATE_FIELD, CROSS_ACCOUNT_VPCS_FIELD, CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD, CUSTOM_DOMAIN_CERTIFICATE_EXPIRY_TIME_FIELD, CUSTOM_DOMAIN_NAME_FIELD, ENDPOINT_FIELD, ENHANCED_VPC_ROUTING_FIELD, MAX_CAPACITY_FIELD, NAMESPACE_NAME_FIELD, PATCH_VERSION_FIELD, PORT_FIELD, PUBLICLY_ACCESSIBLE_FIELD, SECURITY_GROUP_IDS_FIELD, STATUS_FIELD, SUBNET_IDS_FIELD, WORKGROUP_ARN_FIELD, WORKGROUP_ID_FIELD, WORKGROUP_NAME_FIELD, WORKGROUP_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer baseCapacity;
    private final List<ConfigParameter> configParameters;
    private final Instant creationDate;
    private final List<String> crossAccountVpcs;
    private final String customDomainCertificateArn;
    private final Instant customDomainCertificateExpiryTime;
    private final String customDomainName;
    private final Endpoint endpoint;
    private final Boolean enhancedVpcRouting;
    private final Integer maxCapacity;
    private final String namespaceName;
    private final String patchVersion;
    private final Integer port;
    private final Boolean publiclyAccessible;
    private final List<String> securityGroupIds;
    private final String status;
    private final List<String> subnetIds;
    private final String workgroupArn;
    private final String workgroupId;
    private final String workgroupName;
    private final String workgroupVersion;

    private Workgroup(BuilderImpl builder) {
        this.baseCapacity = builder.baseCapacity;
        this.configParameters = builder.configParameters;
        this.creationDate = builder.creationDate;
        this.crossAccountVpcs = builder.crossAccountVpcs;
        this.customDomainCertificateArn = builder.customDomainCertificateArn;
        this.customDomainCertificateExpiryTime = builder.customDomainCertificateExpiryTime;
        this.customDomainName = builder.customDomainName;
        this.endpoint = builder.endpoint;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.maxCapacity = builder.maxCapacity;
        this.namespaceName = builder.namespaceName;
        this.patchVersion = builder.patchVersion;
        this.port = builder.port;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroupIds = builder.securityGroupIds;
        this.status = builder.status;
        this.subnetIds = builder.subnetIds;
        this.workgroupArn = builder.workgroupArn;
        this.workgroupId = builder.workgroupId;
        this.workgroupName = builder.workgroupName;
        this.workgroupVersion = builder.workgroupVersion;
    }

    public final Integer baseCapacity() {
        return this.baseCapacity;
    }

    public final boolean hasConfigParameters() {
        return this.configParameters != null && !(this.configParameters instanceof SdkAutoConstructList);
    }

    public final List<ConfigParameter> configParameters() {
        return this.configParameters;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final boolean hasCrossAccountVpcs() {
        return this.crossAccountVpcs != null && !(this.crossAccountVpcs instanceof SdkAutoConstructList);
    }

    public final List<String> crossAccountVpcs() {
        return this.crossAccountVpcs;
    }

    public final String customDomainCertificateArn() {
        return this.customDomainCertificateArn;
    }

    public final Instant customDomainCertificateExpiryTime() {
        return this.customDomainCertificateExpiryTime;
    }

    public final String customDomainName() {
        return this.customDomainName;
    }

    public final Endpoint endpoint() {
        return this.endpoint;
    }

    public final Boolean enhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public final Integer maxCapacity() {
        return this.maxCapacity;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final String patchVersion() {
        return this.patchVersion;
    }

    public final Integer port() {
        return this.port;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final WorkgroupStatus status() {
        return WorkgroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final String workgroupArn() {
        return this.workgroupArn;
    }

    public final String workgroupId() {
        return this.workgroupId;
    }

    public final String workgroupName() {
        return this.workgroupName;
    }

    public final String workgroupVersion() {
        return this.workgroupVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigParameters() ? this.configParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrossAccountVpcs() ? this.crossAccountVpcs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainCertificateExpiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workgroup)) {
            return false;
        }
        Workgroup other = (Workgroup)obj;
        return Objects.equals(this.baseCapacity(), other.baseCapacity()) && this.hasConfigParameters() == other.hasConfigParameters() && Objects.equals(this.configParameters(), other.configParameters()) && Objects.equals(this.creationDate(), other.creationDate()) && this.hasCrossAccountVpcs() == other.hasCrossAccountVpcs() && Objects.equals(this.crossAccountVpcs(), other.crossAccountVpcs()) && Objects.equals(this.customDomainCertificateArn(), other.customDomainCertificateArn()) && Objects.equals(this.customDomainCertificateExpiryTime(), other.customDomainCertificateExpiryTime()) && Objects.equals(this.customDomainName(), other.customDomainName()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.enhancedVpcRouting(), other.enhancedVpcRouting()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.patchVersion(), other.patchVersion()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.workgroupArn(), other.workgroupArn()) && Objects.equals(this.workgroupId(), other.workgroupId()) && Objects.equals(this.workgroupName(), other.workgroupName()) && Objects.equals(this.workgroupVersion(), other.workgroupVersion());
    }

    public final String toString() {
        return ToString.builder((String)"Workgroup").add("BaseCapacity", (Object)this.baseCapacity()).add("ConfigParameters", this.hasConfigParameters() ? this.configParameters() : null).add("CreationDate", (Object)this.creationDate()).add("CrossAccountVpcs", this.hasCrossAccountVpcs() ? this.crossAccountVpcs() : null).add("CustomDomainCertificateArn", (Object)this.customDomainCertificateArn()).add("CustomDomainCertificateExpiryTime", (Object)this.customDomainCertificateExpiryTime()).add("CustomDomainName", (Object)this.customDomainName()).add("Endpoint", (Object)this.endpoint()).add("EnhancedVpcRouting", (Object)this.enhancedVpcRouting()).add("MaxCapacity", (Object)this.maxCapacity()).add("NamespaceName", (Object)this.namespaceName()).add("PatchVersion", (Object)this.patchVersion()).add("Port", (Object)this.port()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("Status", (Object)this.statusAsString()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("WorkgroupArn", (Object)this.workgroupArn()).add("WorkgroupId", (Object)this.workgroupId()).add("WorkgroupName", (Object)this.workgroupName()).add("WorkgroupVersion", (Object)this.workgroupVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "baseCapacity": {
                return Optional.ofNullable(clazz.cast(this.baseCapacity()));
            }
            case "configParameters": {
                return Optional.ofNullable(clazz.cast(this.configParameters()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "crossAccountVpcs": {
                return Optional.ofNullable(clazz.cast(this.crossAccountVpcs()));
            }
            case "customDomainCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.customDomainCertificateArn()));
            }
            case "customDomainCertificateExpiryTime": {
                return Optional.ofNullable(clazz.cast(this.customDomainCertificateExpiryTime()));
            }
            case "customDomainName": {
                return Optional.ofNullable(clazz.cast(this.customDomainName()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "enhancedVpcRouting": {
                return Optional.ofNullable(clazz.cast(this.enhancedVpcRouting()));
            }
            case "maxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "patchVersion": {
                return Optional.ofNullable(clazz.cast(this.patchVersion()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "publiclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "subnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "workgroupArn": {
                return Optional.ofNullable(clazz.cast(this.workgroupArn()));
            }
            case "workgroupId": {
                return Optional.ofNullable(clazz.cast(this.workgroupId()));
            }
            case "workgroupName": {
                return Optional.ofNullable(clazz.cast(this.workgroupName()));
            }
            case "workgroupVersion": {
                return Optional.ofNullable(clazz.cast(this.workgroupVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Workgroup, T> g) {
        return obj -> g.apply((Workgroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer baseCapacity;
        private List<ConfigParameter> configParameters = DefaultSdkAutoConstructList.getInstance();
        private Instant creationDate;
        private List<String> crossAccountVpcs = DefaultSdkAutoConstructList.getInstance();
        private String customDomainCertificateArn;
        private Instant customDomainCertificateExpiryTime;
        private String customDomainName;
        private Endpoint endpoint;
        private Boolean enhancedVpcRouting;
        private Integer maxCapacity;
        private String namespaceName;
        private String patchVersion;
        private Integer port;
        private Boolean publiclyAccessible;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String workgroupArn;
        private String workgroupId;
        private String workgroupName;
        private String workgroupVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Workgroup model) {
            this.baseCapacity(model.baseCapacity);
            this.configParameters(model.configParameters);
            this.creationDate(model.creationDate);
            this.crossAccountVpcs(model.crossAccountVpcs);
            this.customDomainCertificateArn(model.customDomainCertificateArn);
            this.customDomainCertificateExpiryTime(model.customDomainCertificateExpiryTime);
            this.customDomainName(model.customDomainName);
            this.endpoint(model.endpoint);
            this.enhancedVpcRouting(model.enhancedVpcRouting);
            this.maxCapacity(model.maxCapacity);
            this.namespaceName(model.namespaceName);
            this.patchVersion(model.patchVersion);
            this.port(model.port);
            this.publiclyAccessible(model.publiclyAccessible);
            this.securityGroupIds(model.securityGroupIds);
            this.status(model.status);
            this.subnetIds(model.subnetIds);
            this.workgroupArn(model.workgroupArn);
            this.workgroupId(model.workgroupId);
            this.workgroupName(model.workgroupName);
            this.workgroupVersion(model.workgroupVersion);
        }

        public final Integer getBaseCapacity() {
            return this.baseCapacity;
        }

        public final void setBaseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
        }

        @Override
        public final Builder baseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
            return this;
        }

        public final List<ConfigParameter.Builder> getConfigParameters() {
            List<ConfigParameter.Builder> result = ConfigParameterListCopier.copyToBuilder(this.configParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigParameters(Collection<ConfigParameter.BuilderImpl> configParameters) {
            this.configParameters = ConfigParameterListCopier.copyFromBuilder(configParameters);
        }

        @Override
        public final Builder configParameters(Collection<ConfigParameter> configParameters) {
            this.configParameters = ConfigParameterListCopier.copy(configParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configParameters(ConfigParameter ... configParameters) {
            this.configParameters(Arrays.asList(configParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configParameters(Consumer<ConfigParameter.Builder> ... configParameters) {
            this.configParameters(Stream.of(configParameters).map(c -> (ConfigParameter)((ConfigParameter.Builder)ConfigParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Collection<String> getCrossAccountVpcs() {
            if (this.crossAccountVpcs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.crossAccountVpcs;
        }

        public final void setCrossAccountVpcs(Collection<String> crossAccountVpcs) {
            this.crossAccountVpcs = VpcIdsCopier.copy(crossAccountVpcs);
        }

        @Override
        public final Builder crossAccountVpcs(Collection<String> crossAccountVpcs) {
            this.crossAccountVpcs = VpcIdsCopier.copy(crossAccountVpcs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossAccountVpcs(String ... crossAccountVpcs) {
            this.crossAccountVpcs(Arrays.asList(crossAccountVpcs));
            return this;
        }

        public final String getCustomDomainCertificateArn() {
            return this.customDomainCertificateArn;
        }

        public final void setCustomDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
        }

        @Override
        public final Builder customDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
            return this;
        }

        public final Instant getCustomDomainCertificateExpiryTime() {
            return this.customDomainCertificateExpiryTime;
        }

        public final void setCustomDomainCertificateExpiryTime(Instant customDomainCertificateExpiryTime) {
            this.customDomainCertificateExpiryTime = customDomainCertificateExpiryTime;
        }

        @Override
        public final Builder customDomainCertificateExpiryTime(Instant customDomainCertificateExpiryTime) {
            this.customDomainCertificateExpiryTime = customDomainCertificateExpiryTime;
            return this;
        }

        public final String getCustomDomainName() {
            return this.customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final Endpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getPatchVersion() {
            return this.patchVersion;
        }

        public final void setPatchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
        }

        @Override
        public final Builder patchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkgroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getWorkgroupArn() {
            return this.workgroupArn;
        }

        public final void setWorkgroupArn(String workgroupArn) {
            this.workgroupArn = workgroupArn;
        }

        @Override
        public final Builder workgroupArn(String workgroupArn) {
            this.workgroupArn = workgroupArn;
            return this;
        }

        public final String getWorkgroupId() {
            return this.workgroupId;
        }

        public final void setWorkgroupId(String workgroupId) {
            this.workgroupId = workgroupId;
        }

        @Override
        public final Builder workgroupId(String workgroupId) {
            this.workgroupId = workgroupId;
            return this;
        }

        public final String getWorkgroupName() {
            return this.workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        public final String getWorkgroupVersion() {
            return this.workgroupVersion;
        }

        public final void setWorkgroupVersion(String workgroupVersion) {
            this.workgroupVersion = workgroupVersion;
        }

        @Override
        public final Builder workgroupVersion(String workgroupVersion) {
            this.workgroupVersion = workgroupVersion;
            return this;
        }

        public Workgroup build() {
            return new Workgroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Workgroup> {
        public Builder baseCapacity(Integer var1);

        public Builder configParameters(Collection<ConfigParameter> var1);

        public Builder configParameters(ConfigParameter ... var1);

        public Builder configParameters(Consumer<ConfigParameter.Builder> ... var1);

        public Builder creationDate(Instant var1);

        public Builder crossAccountVpcs(Collection<String> var1);

        public Builder crossAccountVpcs(String ... var1);

        public Builder customDomainCertificateArn(String var1);

        public Builder customDomainCertificateExpiryTime(Instant var1);

        public Builder customDomainName(String var1);

        public Builder endpoint(Endpoint var1);

        default public Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return this.endpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(endpoint)).build());
        }

        public Builder enhancedVpcRouting(Boolean var1);

        public Builder maxCapacity(Integer var1);

        public Builder namespaceName(String var1);

        public Builder patchVersion(String var1);

        public Builder port(Integer var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder status(String var1);

        public Builder status(WorkgroupStatus var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder workgroupArn(String var1);

        public Builder workgroupId(String var1);

        public Builder workgroupName(String var1);

        public Builder workgroupVersion(String var1);
    }
}

