/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateFacesRequest extends RekognitionRequest implements
        ToCopyableBuilder<DisassociateFacesRequest.Builder, DisassociateFacesRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionId").getter(getter(DisassociateFacesRequest::collectionId))
            .setter(setter(Builder::collectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(DisassociateFacesRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(DisassociateFacesRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<String>> FACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FaceIds")
            .getter(getter(DisassociateFacesRequest::faceIds))
            .setter(setter(Builder::faceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD,
            USER_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD, FACE_IDS_FIELD));

    private final String collectionId;

    private final String userId;

    private final String clientRequestToken;

    private final List<String> faceIds;

    private DisassociateFacesRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.userId = builder.userId;
        this.clientRequestToken = builder.clientRequestToken;
        this.faceIds = builder.faceIds;
    }

    /**
     * <p>
     * The ID of an existing collection containing the UserID.
     * </p>
     * 
     * @return The ID of an existing collection containing the UserID.
     */
    public final String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * ID for the existing UserID.
     * </p>
     * 
     * @return ID for the existing UserID.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * Idempotent token used to identify the request to <code>DisassociateFaces</code>. If you use the same token with
     * multiple <code>DisassociateFaces</code> requests, the same response is returned. Use ClientRequestToken to
     * prevent the same request from being processed more than once.
     * </p>
     * 
     * @return Idempotent token used to identify the request to <code>DisassociateFaces</code>. If you use the same
     *         token with multiple <code>DisassociateFaces</code> requests, the same response is returned. Use
     *         ClientRequestToken to prevent the same request from being processed more than once.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FaceIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFaceIds() {
        return faceIds != null && !(faceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of face IDs to disassociate from the UserID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFaceIds} method.
     * </p>
     * 
     * @return An array of face IDs to disassociate from the UserID.
     */
    public final List<String> faceIds() {
        return faceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFaceIds() ? faceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateFacesRequest)) {
            return false;
        }
        DisassociateFacesRequest other = (DisassociateFacesRequest) obj;
        return Objects.equals(collectionId(), other.collectionId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasFaceIds() == other.hasFaceIds()
                && Objects.equals(faceIds(), other.faceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateFacesRequest").add("CollectionId", collectionId()).add("UserId", userId())
                .add("ClientRequestToken", clientRequestToken()).add("FaceIds", hasFaceIds() ? faceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.ofNullable(clazz.cast(collectionId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "FaceIds":
            return Optional.ofNullable(clazz.cast(faceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateFacesRequest, T> g) {
        return obj -> g.apply((DisassociateFacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateFacesRequest> {
        /**
         * <p>
         * The ID of an existing collection containing the UserID.
         * </p>
         * 
         * @param collectionId
         *        The ID of an existing collection containing the UserID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * ID for the existing UserID.
         * </p>
         * 
         * @param userId
         *        ID for the existing UserID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Idempotent token used to identify the request to <code>DisassociateFaces</code>. If you use the same token
         * with multiple <code>DisassociateFaces</code> requests, the same response is returned. Use ClientRequestToken
         * to prevent the same request from being processed more than once.
         * </p>
         * 
         * @param clientRequestToken
         *        Idempotent token used to identify the request to <code>DisassociateFaces</code>. If you use the same
         *        token with multiple <code>DisassociateFaces</code> requests, the same response is returned. Use
         *        ClientRequestToken to prevent the same request from being processed more than once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * An array of face IDs to disassociate from the UserID.
         * </p>
         * 
         * @param faceIds
         *        An array of face IDs to disassociate from the UserID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceIds(Collection<String> faceIds);

        /**
         * <p>
         * An array of face IDs to disassociate from the UserID.
         * </p>
         * 
         * @param faceIds
         *        An array of face IDs to disassociate from the UserID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceIds(String... faceIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String collectionId;

        private String userId;

        private String clientRequestToken;

        private List<String> faceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateFacesRequest model) {
            super(model);
            collectionId(model.collectionId);
            userId(model.userId);
            clientRequestToken(model.clientRequestToken);
            faceIds(model.faceIds);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Collection<String> getFaceIds() {
            if (faceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return faceIds;
        }

        public final void setFaceIds(Collection<String> faceIds) {
            this.faceIds = UserFaceIdListCopier.copy(faceIds);
        }

        @Override
        public final Builder faceIds(Collection<String> faceIds) {
            this.faceIds = UserFaceIdListCopier.copy(faceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceIds(String... faceIds) {
            faceIds(Arrays.asList(faceIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateFacesRequest build() {
            return new DisassociateFacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
