/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is a required parameter for label detection stream processors and should not be used to start a face search
 * stream processor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamProcessingStartSelector implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamProcessingStartSelector.Builder, StreamProcessingStartSelector> {
    private static final SdkField<KinesisVideoStreamStartSelector> KVS_STREAM_START_SELECTOR_FIELD = SdkField
            .<KinesisVideoStreamStartSelector> builder(MarshallingType.SDK_POJO).memberName("KVSStreamStartSelector")
            .getter(getter(StreamProcessingStartSelector::kvsStreamStartSelector))
            .setter(setter(Builder::kvsStreamStartSelector)).constructor(KinesisVideoStreamStartSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KVSStreamStartSelector").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(KVS_STREAM_START_SELECTOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final KinesisVideoStreamStartSelector kvsStreamStartSelector;

    private StreamProcessingStartSelector(BuilderImpl builder) {
        this.kvsStreamStartSelector = builder.kvsStreamStartSelector;
    }

    /**
     * <p>
     * Specifies the starting point in the stream to start processing. This can be done with a producer timestamp or a
     * fragment number in a Kinesis stream.
     * </p>
     * 
     * @return Specifies the starting point in the stream to start processing. This can be done with a producer
     *         timestamp or a fragment number in a Kinesis stream.
     */
    public final KinesisVideoStreamStartSelector kvsStreamStartSelector() {
        return kvsStreamStartSelector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kvsStreamStartSelector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamProcessingStartSelector)) {
            return false;
        }
        StreamProcessingStartSelector other = (StreamProcessingStartSelector) obj;
        return Objects.equals(kvsStreamStartSelector(), other.kvsStreamStartSelector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamProcessingStartSelector").add("KVSStreamStartSelector", kvsStreamStartSelector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KVSStreamStartSelector":
            return Optional.ofNullable(clazz.cast(kvsStreamStartSelector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamProcessingStartSelector, T> g) {
        return obj -> g.apply((StreamProcessingStartSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamProcessingStartSelector> {
        /**
         * <p>
         * Specifies the starting point in the stream to start processing. This can be done with a producer timestamp or
         * a fragment number in a Kinesis stream.
         * </p>
         * 
         * @param kvsStreamStartSelector
         *        Specifies the starting point in the stream to start processing. This can be done with a producer
         *        timestamp or a fragment number in a Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kvsStreamStartSelector(KinesisVideoStreamStartSelector kvsStreamStartSelector);

        /**
         * <p>
         * Specifies the starting point in the stream to start processing. This can be done with a producer timestamp or
         * a fragment number in a Kinesis stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link KinesisVideoStreamStartSelector.Builder}
         * avoiding the need to create one manually via {@link KinesisVideoStreamStartSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisVideoStreamStartSelector.Builder#build()} is called
         * immediately and its result is passed to {@link #kvsStreamStartSelector(KinesisVideoStreamStartSelector)}.
         * 
         * @param kvsStreamStartSelector
         *        a consumer that will call methods on {@link KinesisVideoStreamStartSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kvsStreamStartSelector(KinesisVideoStreamStartSelector)
         */
        default Builder kvsStreamStartSelector(Consumer<KinesisVideoStreamStartSelector.Builder> kvsStreamStartSelector) {
            return kvsStreamStartSelector(KinesisVideoStreamStartSelector.builder().applyMutation(kvsStreamStartSelector).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KinesisVideoStreamStartSelector kvsStreamStartSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamProcessingStartSelector model) {
            kvsStreamStartSelector(model.kvsStreamStartSelector);
        }

        public final KinesisVideoStreamStartSelector.Builder getKvsStreamStartSelector() {
            return kvsStreamStartSelector != null ? kvsStreamStartSelector.toBuilder() : null;
        }

        public final void setKvsStreamStartSelector(KinesisVideoStreamStartSelector.BuilderImpl kvsStreamStartSelector) {
            this.kvsStreamStartSelector = kvsStreamStartSelector != null ? kvsStreamStartSelector.build() : null;
        }

        @Override
        public final Builder kvsStreamStartSelector(KinesisVideoStreamStartSelector kvsStreamStartSelector) {
            this.kvsStreamStartSelector = kvsStreamStartSelector;
            return this;
        }

        @Override
        public StreamProcessingStartSelector build() {
            return new StreamProcessingStartSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
