/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an item of Personal Protective Equipment (PPE) detected by <a>DetectProtectiveEquipment</a>. For
 * more information, see <a>DetectProtectiveEquipment</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EquipmentDetection implements SdkPojo, Serializable,
        ToCopyableBuilder<EquipmentDetection.Builder, EquipmentDetection> {
    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.<BoundingBox> builder(MarshallingType.SDK_POJO)
            .memberName("BoundingBox").getter(getter(EquipmentDetection::boundingBox)).setter(setter(Builder::boundingBox))
            .constructor(BoundingBox::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(EquipmentDetection::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(EquipmentDetection::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<CoversBodyPart> COVERS_BODY_PART_FIELD = SdkField
            .<CoversBodyPart> builder(MarshallingType.SDK_POJO).memberName("CoversBodyPart")
            .getter(getter(EquipmentDetection::coversBodyPart)).setter(setter(Builder::coversBodyPart))
            .constructor(CoversBodyPart::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoversBodyPart").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD,
            CONFIDENCE_FIELD, TYPE_FIELD, COVERS_BODY_PART_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BoundingBox boundingBox;

    private final Float confidence;

    private final String type;

    private final CoversBodyPart coversBodyPart;

    private EquipmentDetection(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.confidence = builder.confidence;
        this.type = builder.type;
        this.coversBodyPart = builder.coversBodyPart;
    }

    /**
     * <p>
     * A bounding box surrounding the item of detected PPE.
     * </p>
     * 
     * @return A bounding box surrounding the item of detected PPE.
     */
    public final BoundingBox boundingBox() {
        return boundingBox;
    }

    /**
     * <p>
     * The confidence that Amazon Rekognition has that the bounding box (<code>BoundingBox</code>) contains an item of
     * PPE.
     * </p>
     * 
     * @return The confidence that Amazon Rekognition has that the bounding box (<code>BoundingBox</code>) contains an
     *         item of PPE.
     */
    public final Float confidence() {
        return confidence;
    }

    /**
     * <p>
     * The type of detected PPE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProtectiveEquipmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of detected PPE.
     * @see ProtectiveEquipmentType
     */
    public final ProtectiveEquipmentType type() {
        return ProtectiveEquipmentType.fromValue(type);
    }

    /**
     * <p>
     * The type of detected PPE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProtectiveEquipmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of detected PPE.
     * @see ProtectiveEquipmentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Information about the body part covered by the detected PPE.
     * </p>
     * 
     * @return Information about the body part covered by the detected PPE.
     */
    public final CoversBodyPart coversBodyPart() {
        return coversBodyPart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(coversBodyPart());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EquipmentDetection)) {
            return false;
        }
        EquipmentDetection other = (EquipmentDetection) obj;
        return Objects.equals(boundingBox(), other.boundingBox()) && Objects.equals(confidence(), other.confidence())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(coversBodyPart(), other.coversBodyPart());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EquipmentDetection").add("BoundingBox", boundingBox()).add("Confidence", confidence())
                .add("Type", typeAsString()).add("CoversBodyPart", coversBodyPart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "CoversBodyPart":
            return Optional.ofNullable(clazz.cast(coversBodyPart()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BoundingBox", BOUNDING_BOX_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("CoversBodyPart", COVERS_BODY_PART_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EquipmentDetection, T> g) {
        return obj -> g.apply((EquipmentDetection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EquipmentDetection> {
        /**
         * <p>
         * A bounding box surrounding the item of detected PPE.
         * </p>
         * 
         * @param boundingBox
         *        A bounding box surrounding the item of detected PPE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(BoundingBox boundingBox);

        /**
         * <p>
         * A bounding box surrounding the item of detected PPE.
         * </p>
         * This is a convenience method that creates an instance of the {@link BoundingBox.Builder} avoiding the need to
         * create one manually via {@link BoundingBox#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BoundingBox.Builder#build()} is called immediately and its result
         * is passed to {@link #boundingBox(BoundingBox)}.
         * 
         * @param boundingBox
         *        a consumer that will call methods on {@link BoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boundingBox(BoundingBox)
         */
        default Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return boundingBox(BoundingBox.builder().applyMutation(boundingBox).build());
        }

        /**
         * <p>
         * The confidence that Amazon Rekognition has that the bounding box (<code>BoundingBox</code>) contains an item
         * of PPE.
         * </p>
         * 
         * @param confidence
         *        The confidence that Amazon Rekognition has that the bounding box (<code>BoundingBox</code>) contains
         *        an item of PPE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);

        /**
         * <p>
         * The type of detected PPE.
         * </p>
         * 
         * @param type
         *        The type of detected PPE.
         * @see ProtectiveEquipmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectiveEquipmentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of detected PPE.
         * </p>
         * 
         * @param type
         *        The type of detected PPE.
         * @see ProtectiveEquipmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectiveEquipmentType
         */
        Builder type(ProtectiveEquipmentType type);

        /**
         * <p>
         * Information about the body part covered by the detected PPE.
         * </p>
         * 
         * @param coversBodyPart
         *        Information about the body part covered by the detected PPE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coversBodyPart(CoversBodyPart coversBodyPart);

        /**
         * <p>
         * Information about the body part covered by the detected PPE.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoversBodyPart.Builder} avoiding the need
         * to create one manually via {@link CoversBodyPart#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoversBodyPart.Builder#build()} is called immediately and its
         * result is passed to {@link #coversBodyPart(CoversBodyPart)}.
         * 
         * @param coversBodyPart
         *        a consumer that will call methods on {@link CoversBodyPart.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coversBodyPart(CoversBodyPart)
         */
        default Builder coversBodyPart(Consumer<CoversBodyPart.Builder> coversBodyPart) {
            return coversBodyPart(CoversBodyPart.builder().applyMutation(coversBodyPart).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BoundingBox boundingBox;

        private Float confidence;

        private String type;

        private CoversBodyPart coversBodyPart;

        private BuilderImpl() {
        }

        private BuilderImpl(EquipmentDetection model) {
            boundingBox(model.boundingBox);
            confidence(model.confidence);
            type(model.type);
            coversBodyPart(model.coversBodyPart);
        }

        public final BoundingBox.Builder getBoundingBox() {
            return boundingBox != null ? boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProtectiveEquipmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final CoversBodyPart.Builder getCoversBodyPart() {
            return coversBodyPart != null ? coversBodyPart.toBuilder() : null;
        }

        public final void setCoversBodyPart(CoversBodyPart.BuilderImpl coversBodyPart) {
            this.coversBodyPart = coversBodyPart != null ? coversBodyPart.build() : null;
        }

        @Override
        public final Builder coversBodyPart(CoversBodyPart coversBodyPart) {
            this.coversBodyPart = coversBodyPart;
            return this;
        }

        @Override
        public EquipmentDetection build() {
            return new EquipmentDetection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
