/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a shot detection segment detected in a video. For more information, see <a>SegmentDetection</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShotSegment implements SdkPojo, Serializable, ToCopyableBuilder<ShotSegment.Builder, ShotSegment> {
    private static final SdkField<Long> INDEX_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Index")
            .getter(getter(ShotSegment::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(ShotSegment::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(INDEX_FIELD, CONFIDENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long index;

    private final Float confidence;

    private ShotSegment(BuilderImpl builder) {
        this.index = builder.index;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * An Identifier for a shot detection segment detected in a video.
     * </p>
     * 
     * @return An Identifier for a shot detection segment detected in a video.
     */
    public final Long index() {
        return index;
    }

    /**
     * <p>
     * The confidence that Amazon Rekognition Video has in the accuracy of the detected segment.
     * </p>
     * 
     * @return The confidence that Amazon Rekognition Video has in the accuracy of the detected segment.
     */
    public final Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(index());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShotSegment)) {
            return false;
        }
        ShotSegment other = (ShotSegment) obj;
        return Objects.equals(index(), other.index()) && Objects.equals(confidence(), other.confidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShotSegment").add("Index", index()).add("Confidence", confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Index":
            return Optional.ofNullable(clazz.cast(index()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Index", INDEX_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ShotSegment, T> g) {
        return obj -> g.apply((ShotSegment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShotSegment> {
        /**
         * <p>
         * An Identifier for a shot detection segment detected in a video.
         * </p>
         * 
         * @param index
         *        An Identifier for a shot detection segment detected in a video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Long index);

        /**
         * <p>
         * The confidence that Amazon Rekognition Video has in the accuracy of the detected segment.
         * </p>
         * 
         * @param confidence
         *        The confidence that Amazon Rekognition Video has in the accuracy of the detected segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    static final class BuilderImpl implements Builder {
        private Long index;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(ShotSegment model) {
            index(model.index);
            confidence(model.confidence);
        }

        public final Long getIndex() {
            return index;
        }

        public final void setIndex(Long index) {
            this.index = index;
        }

        @Override
        public final Builder index(Long index) {
            this.index = index;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public ShotSegment build() {
            return new ShotSegment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
