/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartStreamProcessorRequest extends RekognitionRequest implements
        ToCopyableBuilder<StartStreamProcessorRequest.Builder, StartStreamProcessorRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StartStreamProcessorRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<StreamProcessingStartSelector> START_SELECTOR_FIELD = SdkField
            .<StreamProcessingStartSelector> builder(MarshallingType.SDK_POJO).memberName("StartSelector")
            .getter(getter(StartStreamProcessorRequest::startSelector)).setter(setter(Builder::startSelector))
            .constructor(StreamProcessingStartSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartSelector").build()).build();

    private static final SdkField<StreamProcessingStopSelector> STOP_SELECTOR_FIELD = SdkField
            .<StreamProcessingStopSelector> builder(MarshallingType.SDK_POJO).memberName("StopSelector")
            .getter(getter(StartStreamProcessorRequest::stopSelector)).setter(setter(Builder::stopSelector))
            .constructor(StreamProcessingStopSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopSelector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            START_SELECTOR_FIELD, STOP_SELECTOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final StreamProcessingStartSelector startSelector;

    private final StreamProcessingStopSelector stopSelector;

    private StartStreamProcessorRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.startSelector = builder.startSelector;
        this.stopSelector = builder.stopSelector;
    }

    /**
     * <p>
     * The name of the stream processor to start processing.
     * </p>
     * 
     * @return The name of the stream processor to start processing.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the starting point in the Kinesis stream to start processing. You can use the producer timestamp or the
     * fragment number. If you use the producer timestamp, you must put the time in milliseconds. For more information
     * about fragment numbers, see <a
     * href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_reader_Fragment.html">Fragment</a>.
     * </p>
     * <p>
     * This is a required parameter for label detection stream processors and should not be used to start a face search
     * stream processor.
     * </p>
     * 
     * @return Specifies the starting point in the Kinesis stream to start processing. You can use the producer
     *         timestamp or the fragment number. If you use the producer timestamp, you must put the time in
     *         milliseconds. For more information about fragment numbers, see <a
     *         href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_reader_Fragment.html">Fragment</a>.
     *         </p>
     *         <p>
     *         This is a required parameter for label detection stream processors and should not be used to start a face
     *         search stream processor.
     */
    public final StreamProcessingStartSelector startSelector() {
        return startSelector;
    }

    /**
     * <p>
     * Specifies when to stop processing the stream. You can specify a maximum amount of time to process the video.
     * </p>
     * <p>
     * This is a required parameter for label detection stream processors and should not be used to start a face search
     * stream processor.
     * </p>
     * 
     * @return Specifies when to stop processing the stream. You can specify a maximum amount of time to process the
     *         video. </p>
     *         <p>
     *         This is a required parameter for label detection stream processors and should not be used to start a face
     *         search stream processor.
     */
    public final StreamProcessingStopSelector stopSelector() {
        return stopSelector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(startSelector());
        hashCode = 31 * hashCode + Objects.hashCode(stopSelector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartStreamProcessorRequest)) {
            return false;
        }
        StartStreamProcessorRequest other = (StartStreamProcessorRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(startSelector(), other.startSelector())
                && Objects.equals(stopSelector(), other.stopSelector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartStreamProcessorRequest").add("Name", name()).add("StartSelector", startSelector())
                .add("StopSelector", stopSelector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "StartSelector":
            return Optional.ofNullable(clazz.cast(startSelector()));
        case "StopSelector":
            return Optional.ofNullable(clazz.cast(stopSelector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("StartSelector", START_SELECTOR_FIELD);
        map.put("StopSelector", STOP_SELECTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartStreamProcessorRequest, T> g) {
        return obj -> g.apply((StartStreamProcessorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartStreamProcessorRequest> {
        /**
         * <p>
         * The name of the stream processor to start processing.
         * </p>
         * 
         * @param name
         *        The name of the stream processor to start processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the starting point in the Kinesis stream to start processing. You can use the producer timestamp or
         * the fragment number. If you use the producer timestamp, you must put the time in milliseconds. For more
         * information about fragment numbers, see <a
         * href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_reader_Fragment.html">Fragment</a>.
         * </p>
         * <p>
         * This is a required parameter for label detection stream processors and should not be used to start a face
         * search stream processor.
         * </p>
         * 
         * @param startSelector
         *        Specifies the starting point in the Kinesis stream to start processing. You can use the producer
         *        timestamp or the fragment number. If you use the producer timestamp, you must put the time in
         *        milliseconds. For more information about fragment numbers, see <a
         *        href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_reader_Fragment.html"
         *        >Fragment</a>. </p>
         *        <p>
         *        This is a required parameter for label detection stream processors and should not be used to start a
         *        face search stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startSelector(StreamProcessingStartSelector startSelector);

        /**
         * <p>
         * Specifies the starting point in the Kinesis stream to start processing. You can use the producer timestamp or
         * the fragment number. If you use the producer timestamp, you must put the time in milliseconds. For more
         * information about fragment numbers, see <a
         * href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_reader_Fragment.html">Fragment</a>.
         * </p>
         * <p>
         * This is a required parameter for label detection stream processors and should not be used to start a face
         * search stream processor.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamProcessingStartSelector.Builder}
         * avoiding the need to create one manually via {@link StreamProcessingStartSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamProcessingStartSelector.Builder#build()} is called
         * immediately and its result is passed to {@link #startSelector(StreamProcessingStartSelector)}.
         * 
         * @param startSelector
         *        a consumer that will call methods on {@link StreamProcessingStartSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startSelector(StreamProcessingStartSelector)
         */
        default Builder startSelector(Consumer<StreamProcessingStartSelector.Builder> startSelector) {
            return startSelector(StreamProcessingStartSelector.builder().applyMutation(startSelector).build());
        }

        /**
         * <p>
         * Specifies when to stop processing the stream. You can specify a maximum amount of time to process the video.
         * </p>
         * <p>
         * This is a required parameter for label detection stream processors and should not be used to start a face
         * search stream processor.
         * </p>
         * 
         * @param stopSelector
         *        Specifies when to stop processing the stream. You can specify a maximum amount of time to process the
         *        video. </p>
         *        <p>
         *        This is a required parameter for label detection stream processors and should not be used to start a
         *        face search stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopSelector(StreamProcessingStopSelector stopSelector);

        /**
         * <p>
         * Specifies when to stop processing the stream. You can specify a maximum amount of time to process the video.
         * </p>
         * <p>
         * This is a required parameter for label detection stream processors and should not be used to start a face
         * search stream processor.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamProcessingStopSelector.Builder}
         * avoiding the need to create one manually via {@link StreamProcessingStopSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamProcessingStopSelector.Builder#build()} is called
         * immediately and its result is passed to {@link #stopSelector(StreamProcessingStopSelector)}.
         * 
         * @param stopSelector
         *        a consumer that will call methods on {@link StreamProcessingStopSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stopSelector(StreamProcessingStopSelector)
         */
        default Builder stopSelector(Consumer<StreamProcessingStopSelector.Builder> stopSelector) {
            return stopSelector(StreamProcessingStopSelector.builder().applyMutation(stopSelector).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String name;

        private StreamProcessingStartSelector startSelector;

        private StreamProcessingStopSelector stopSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(StartStreamProcessorRequest model) {
            super(model);
            name(model.name);
            startSelector(model.startSelector);
            stopSelector(model.stopSelector);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StreamProcessingStartSelector.Builder getStartSelector() {
            return startSelector != null ? startSelector.toBuilder() : null;
        }

        public final void setStartSelector(StreamProcessingStartSelector.BuilderImpl startSelector) {
            this.startSelector = startSelector != null ? startSelector.build() : null;
        }

        @Override
        public final Builder startSelector(StreamProcessingStartSelector startSelector) {
            this.startSelector = startSelector;
            return this;
        }

        public final StreamProcessingStopSelector.Builder getStopSelector() {
            return stopSelector != null ? stopSelector.toBuilder() : null;
        }

        public final void setStopSelector(StreamProcessingStopSelector.BuilderImpl stopSelector) {
            this.stopSelector = stopSelector != null ? stopSelector.build() : null;
        }

        @Override
        public final Builder stopSelector(StreamProcessingStopSelector stopSelector) {
            this.stopSelector = stopSelector;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartStreamProcessorRequest build() {
            return new StartStreamProcessorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
