/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The stream processor settings that you want to update. <code>ConnectedHome</code> settings can be updated to detect
 * different labels with a different minimum confidence.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamProcessorSettingsForUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamProcessorSettingsForUpdate.Builder, StreamProcessorSettingsForUpdate> {
    private static final SdkField<ConnectedHomeSettingsForUpdate> CONNECTED_HOME_FOR_UPDATE_FIELD = SdkField
            .<ConnectedHomeSettingsForUpdate> builder(MarshallingType.SDK_POJO).memberName("ConnectedHomeForUpdate")
            .getter(getter(StreamProcessorSettingsForUpdate::connectedHomeForUpdate))
            .setter(setter(Builder::connectedHomeForUpdate)).constructor(ConnectedHomeSettingsForUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedHomeForUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONNECTED_HOME_FOR_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConnectedHomeSettingsForUpdate connectedHomeForUpdate;

    private StreamProcessorSettingsForUpdate(BuilderImpl builder) {
        this.connectedHomeForUpdate = builder.connectedHomeForUpdate;
    }

    /**
     * <p>
     * The label detection settings you want to use for your stream processor.
     * </p>
     * 
     * @return The label detection settings you want to use for your stream processor.
     */
    public final ConnectedHomeSettingsForUpdate connectedHomeForUpdate() {
        return connectedHomeForUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectedHomeForUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamProcessorSettingsForUpdate)) {
            return false;
        }
        StreamProcessorSettingsForUpdate other = (StreamProcessorSettingsForUpdate) obj;
        return Objects.equals(connectedHomeForUpdate(), other.connectedHomeForUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamProcessorSettingsForUpdate").add("ConnectedHomeForUpdate", connectedHomeForUpdate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectedHomeForUpdate":
            return Optional.ofNullable(clazz.cast(connectedHomeForUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectedHomeForUpdate", CONNECTED_HOME_FOR_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamProcessorSettingsForUpdate, T> g) {
        return obj -> g.apply((StreamProcessorSettingsForUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamProcessorSettingsForUpdate> {
        /**
         * <p>
         * The label detection settings you want to use for your stream processor.
         * </p>
         * 
         * @param connectedHomeForUpdate
         *        The label detection settings you want to use for your stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedHomeForUpdate(ConnectedHomeSettingsForUpdate connectedHomeForUpdate);

        /**
         * <p>
         * The label detection settings you want to use for your stream processor.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectedHomeSettingsForUpdate.Builder}
         * avoiding the need to create one manually via {@link ConnectedHomeSettingsForUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectedHomeSettingsForUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #connectedHomeForUpdate(ConnectedHomeSettingsForUpdate)}.
         * 
         * @param connectedHomeForUpdate
         *        a consumer that will call methods on {@link ConnectedHomeSettingsForUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectedHomeForUpdate(ConnectedHomeSettingsForUpdate)
         */
        default Builder connectedHomeForUpdate(Consumer<ConnectedHomeSettingsForUpdate.Builder> connectedHomeForUpdate) {
            return connectedHomeForUpdate(ConnectedHomeSettingsForUpdate.builder().applyMutation(connectedHomeForUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConnectedHomeSettingsForUpdate connectedHomeForUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamProcessorSettingsForUpdate model) {
            connectedHomeForUpdate(model.connectedHomeForUpdate);
        }

        public final ConnectedHomeSettingsForUpdate.Builder getConnectedHomeForUpdate() {
            return connectedHomeForUpdate != null ? connectedHomeForUpdate.toBuilder() : null;
        }

        public final void setConnectedHomeForUpdate(ConnectedHomeSettingsForUpdate.BuilderImpl connectedHomeForUpdate) {
            this.connectedHomeForUpdate = connectedHomeForUpdate != null ? connectedHomeForUpdate.build() : null;
        }

        @Override
        public final Builder connectedHomeForUpdate(ConnectedHomeSettingsForUpdate connectedHomeForUpdate) {
            this.connectedHomeForUpdate = connectedHomeForUpdate;
            return this;
        }

        @Override
        public StreamProcessorSettingsForUpdate build() {
            return new StreamProcessorSettingsForUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
