/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakergeospatial.model.OutputConfigInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.SageMakerGeospatialRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportEarthObservationJobRequest
extends SageMakerGeospatialRequest
implements ToCopyableBuilder<Builder, ExportEarthObservationJobRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ExportEarthObservationJobRequest.getter(ExportEarthObservationJobRequest::arn)).setter(ExportEarthObservationJobRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ExportEarthObservationJobRequest.getter(ExportEarthObservationJobRequest::clientToken)).setter(ExportEarthObservationJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(ExportEarthObservationJobRequest.getter(ExportEarthObservationJobRequest::executionRoleArn)).setter(ExportEarthObservationJobRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<Boolean> EXPORT_SOURCE_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExportSourceImages").getter(ExportEarthObservationJobRequest.getter(ExportEarthObservationJobRequest::exportSourceImages)).setter(ExportEarthObservationJobRequest.setter(Builder::exportSourceImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSourceImages").build()}).build();
    private static final SdkField<OutputConfigInput> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(ExportEarthObservationJobRequest.getter(ExportEarthObservationJobRequest::outputConfig)).setter(ExportEarthObservationJobRequest.setter(Builder::outputConfig)).constructor(OutputConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CLIENT_TOKEN_FIELD, EXECUTION_ROLE_ARN_FIELD, EXPORT_SOURCE_IMAGES_FIELD, OUTPUT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportEarthObservationJobRequest.memberNameToFieldInitializer();
    private final String arn;
    private final String clientToken;
    private final String executionRoleArn;
    private final Boolean exportSourceImages;
    private final OutputConfigInput outputConfig;

    private ExportEarthObservationJobRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.clientToken = builder.clientToken;
        this.executionRoleArn = builder.executionRoleArn;
        this.exportSourceImages = builder.exportSourceImages;
        this.outputConfig = builder.outputConfig;
    }

    public final String arn() {
        return this.arn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final Boolean exportSourceImages() {
        return this.exportSourceImages;
    }

    public final OutputConfigInput outputConfig() {
        return this.outputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportSourceImages());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportEarthObservationJobRequest)) {
            return false;
        }
        ExportEarthObservationJobRequest other = (ExportEarthObservationJobRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.exportSourceImages(), other.exportSourceImages()) && Objects.equals(this.outputConfig(), other.outputConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ExportEarthObservationJobRequest").add("Arn", (Object)this.arn()).add("ClientToken", (Object)this.clientToken()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("ExportSourceImages", (Object)this.exportSourceImages()).add("OutputConfig", (Object)this.outputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "ExportSourceImages": {
                return Optional.ofNullable(clazz.cast(this.exportSourceImages()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("ExportSourceImages", EXPORT_SOURCE_IMAGES_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportEarthObservationJobRequest, T> g) {
        return obj -> g.apply((ExportEarthObservationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerGeospatialRequest.BuilderImpl
    implements Builder {
        private String arn;
        private String clientToken;
        private String executionRoleArn;
        private Boolean exportSourceImages;
        private OutputConfigInput outputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportEarthObservationJobRequest model) {
            super(model);
            this.arn(model.arn);
            this.clientToken(model.clientToken);
            this.executionRoleArn(model.executionRoleArn);
            this.exportSourceImages(model.exportSourceImages);
            this.outputConfig(model.outputConfig);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final Boolean getExportSourceImages() {
            return this.exportSourceImages;
        }

        public final void setExportSourceImages(Boolean exportSourceImages) {
            this.exportSourceImages = exportSourceImages;
        }

        @Override
        public final Builder exportSourceImages(Boolean exportSourceImages) {
            this.exportSourceImages = exportSourceImages;
            return this;
        }

        public final OutputConfigInput.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfigInput.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfigInput outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportEarthObservationJobRequest build() {
            return new ExportEarthObservationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerGeospatialRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportEarthObservationJobRequest> {
        public Builder arn(String var1);

        public Builder clientToken(String var1);

        public Builder executionRoleArn(String var1);

        public Builder exportSourceImages(Boolean var1);

        public Builder outputConfig(OutputConfigInput var1);

        default public Builder outputConfig(Consumer<OutputConfigInput.Builder> outputConfig) {
            return this.outputConfig((OutputConfigInput)((OutputConfigInput.Builder)OutputConfigInput.builder().applyMutation(outputConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

