/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.verifiedpermissions.model.AudiencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOpenIdConnectAccessTokenConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateOpenIdConnectAccessTokenConfiguration> {
    private static final SdkField<String> PRINCIPAL_ID_CLAIM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalIdClaim").getter(UpdateOpenIdConnectAccessTokenConfiguration.getter(UpdateOpenIdConnectAccessTokenConfiguration::principalIdClaim)).setter(UpdateOpenIdConnectAccessTokenConfiguration.setter(Builder::principalIdClaim)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalIdClaim").build()}).build();
    private static final SdkField<List<String>> AUDIENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("audiences").getter(UpdateOpenIdConnectAccessTokenConfiguration.getter(UpdateOpenIdConnectAccessTokenConfiguration::audiences)).setter(UpdateOpenIdConnectAccessTokenConfiguration.setter(Builder::audiences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audiences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_ID_CLAIM_FIELD, AUDIENCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String principalIdClaim;
    private final List<String> audiences;

    private UpdateOpenIdConnectAccessTokenConfiguration(BuilderImpl builder) {
        this.principalIdClaim = builder.principalIdClaim;
        this.audiences = builder.audiences;
    }

    public final String principalIdClaim() {
        return this.principalIdClaim;
    }

    public final boolean hasAudiences() {
        return this.audiences != null && !(this.audiences instanceof SdkAutoConstructList);
    }

    public final List<String> audiences() {
        return this.audiences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principalIdClaim());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudiences() ? this.audiences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOpenIdConnectAccessTokenConfiguration)) {
            return false;
        }
        UpdateOpenIdConnectAccessTokenConfiguration other = (UpdateOpenIdConnectAccessTokenConfiguration)obj;
        return Objects.equals(this.principalIdClaim(), other.principalIdClaim()) && this.hasAudiences() == other.hasAudiences() && Objects.equals(this.audiences(), other.audiences());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOpenIdConnectAccessTokenConfiguration").add("PrincipalIdClaim", (Object)(this.principalIdClaim() == null ? null : "*** Sensitive Data Redacted ***")).add("Audiences", this.hasAudiences() ? this.audiences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "principalIdClaim": {
                return Optional.ofNullable(clazz.cast(this.principalIdClaim()));
            }
            case "audiences": {
                return Optional.ofNullable(clazz.cast(this.audiences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOpenIdConnectAccessTokenConfiguration, T> g) {
        return obj -> g.apply((UpdateOpenIdConnectAccessTokenConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String principalIdClaim;
        private List<String> audiences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOpenIdConnectAccessTokenConfiguration model) {
            this.principalIdClaim(model.principalIdClaim);
            this.audiences(model.audiences);
        }

        public final String getPrincipalIdClaim() {
            return this.principalIdClaim;
        }

        public final void setPrincipalIdClaim(String principalIdClaim) {
            this.principalIdClaim = principalIdClaim;
        }

        @Override
        public final Builder principalIdClaim(String principalIdClaim) {
            this.principalIdClaim = principalIdClaim;
            return this;
        }

        public final Collection<String> getAudiences() {
            if (this.audiences instanceof SdkAutoConstructList) {
                return null;
            }
            return this.audiences;
        }

        public final void setAudiences(Collection<String> audiences) {
            this.audiences = AudiencesCopier.copy(audiences);
        }

        @Override
        public final Builder audiences(Collection<String> audiences) {
            this.audiences = AudiencesCopier.copy(audiences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audiences(String ... audiences) {
            this.audiences(Arrays.asList(audiences));
            return this;
        }

        public UpdateOpenIdConnectAccessTokenConfiguration build() {
            return new UpdateOpenIdConnectAccessTokenConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateOpenIdConnectAccessTokenConfiguration> {
        public Builder principalIdClaim(String var1);

        public Builder audiences(Collection<String> var1);

        public Builder audiences(String ... var1);
    }
}

