/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.verifiedpermissions.model.OpenIdConnectAccessTokenConfigurationItem;
import software.amazon.awssdk.services.verifiedpermissions.model.OpenIdConnectIdentityTokenConfigurationItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenIdConnectTokenSelectionItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenIdConnectTokenSelectionItem> {
    private static final SdkField<OpenIdConnectAccessTokenConfigurationItem> ACCESS_TOKEN_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessTokenOnly").getter(OpenIdConnectTokenSelectionItem.getter(OpenIdConnectTokenSelectionItem::accessTokenOnly)).setter(OpenIdConnectTokenSelectionItem.setter(Builder::accessTokenOnly)).constructor(OpenIdConnectAccessTokenConfigurationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessTokenOnly").build()}).build();
    private static final SdkField<OpenIdConnectIdentityTokenConfigurationItem> IDENTITY_TOKEN_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("identityTokenOnly").getter(OpenIdConnectTokenSelectionItem.getter(OpenIdConnectTokenSelectionItem::identityTokenOnly)).setter(OpenIdConnectTokenSelectionItem.setter(Builder::identityTokenOnly)).constructor(OpenIdConnectIdentityTokenConfigurationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityTokenOnly").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_ONLY_FIELD, IDENTITY_TOKEN_ONLY_FIELD));
    private static final long serialVersionUID = 1L;
    private final OpenIdConnectAccessTokenConfigurationItem accessTokenOnly;
    private final OpenIdConnectIdentityTokenConfigurationItem identityTokenOnly;
    private final Type type;

    private OpenIdConnectTokenSelectionItem(BuilderImpl builder) {
        this.accessTokenOnly = builder.accessTokenOnly;
        this.identityTokenOnly = builder.identityTokenOnly;
        this.type = builder.type;
    }

    public final OpenIdConnectAccessTokenConfigurationItem accessTokenOnly() {
        return this.accessTokenOnly;
    }

    public final OpenIdConnectIdentityTokenConfigurationItem identityTokenOnly() {
        return this.identityTokenOnly;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTokenOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityTokenOnly());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenIdConnectTokenSelectionItem)) {
            return false;
        }
        OpenIdConnectTokenSelectionItem other = (OpenIdConnectTokenSelectionItem)obj;
        return Objects.equals(this.accessTokenOnly(), other.accessTokenOnly()) && Objects.equals(this.identityTokenOnly(), other.identityTokenOnly());
    }

    public final String toString() {
        return ToString.builder((String)"OpenIdConnectTokenSelectionItem").add("AccessTokenOnly", (Object)this.accessTokenOnly()).add("IdentityTokenOnly", (Object)this.identityTokenOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessTokenOnly": {
                return Optional.ofNullable(clazz.cast(this.accessTokenOnly()));
            }
            case "identityTokenOnly": {
                return Optional.ofNullable(clazz.cast(this.identityTokenOnly()));
            }
        }
        return Optional.empty();
    }

    public static OpenIdConnectTokenSelectionItem fromAccessTokenOnly(OpenIdConnectAccessTokenConfigurationItem accessTokenOnly) {
        return (OpenIdConnectTokenSelectionItem)OpenIdConnectTokenSelectionItem.builder().accessTokenOnly(accessTokenOnly).build();
    }

    public static OpenIdConnectTokenSelectionItem fromAccessTokenOnly(Consumer<OpenIdConnectAccessTokenConfigurationItem.Builder> accessTokenOnly) {
        OpenIdConnectAccessTokenConfigurationItem.Builder builder = OpenIdConnectAccessTokenConfigurationItem.builder();
        accessTokenOnly.accept(builder);
        return OpenIdConnectTokenSelectionItem.fromAccessTokenOnly((OpenIdConnectAccessTokenConfigurationItem)builder.build());
    }

    public static OpenIdConnectTokenSelectionItem fromIdentityTokenOnly(OpenIdConnectIdentityTokenConfigurationItem identityTokenOnly) {
        return (OpenIdConnectTokenSelectionItem)OpenIdConnectTokenSelectionItem.builder().identityTokenOnly(identityTokenOnly).build();
    }

    public static OpenIdConnectTokenSelectionItem fromIdentityTokenOnly(Consumer<OpenIdConnectIdentityTokenConfigurationItem.Builder> identityTokenOnly) {
        OpenIdConnectIdentityTokenConfigurationItem.Builder builder = OpenIdConnectIdentityTokenConfigurationItem.builder();
        identityTokenOnly.accept(builder);
        return OpenIdConnectTokenSelectionItem.fromIdentityTokenOnly((OpenIdConnectIdentityTokenConfigurationItem)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenIdConnectTokenSelectionItem, T> g) {
        return obj -> g.apply((OpenIdConnectTokenSelectionItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ACCESS_TOKEN_ONLY,
        IDENTITY_TOKEN_ONLY,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private OpenIdConnectAccessTokenConfigurationItem accessTokenOnly;
        private OpenIdConnectIdentityTokenConfigurationItem identityTokenOnly;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OpenIdConnectTokenSelectionItem model) {
            this.accessTokenOnly(model.accessTokenOnly);
            this.identityTokenOnly(model.identityTokenOnly);
        }

        public final OpenIdConnectAccessTokenConfigurationItem.Builder getAccessTokenOnly() {
            return this.accessTokenOnly != null ? this.accessTokenOnly.toBuilder() : null;
        }

        public final void setAccessTokenOnly(OpenIdConnectAccessTokenConfigurationItem.BuilderImpl accessTokenOnly) {
            OpenIdConnectAccessTokenConfigurationItem oldValue = this.accessTokenOnly;
            this.accessTokenOnly = accessTokenOnly != null ? accessTokenOnly.build() : null;
            this.handleUnionValueChange(Type.ACCESS_TOKEN_ONLY, oldValue, this.accessTokenOnly);
        }

        @Override
        public final Builder accessTokenOnly(OpenIdConnectAccessTokenConfigurationItem accessTokenOnly) {
            OpenIdConnectAccessTokenConfigurationItem oldValue = this.accessTokenOnly;
            this.accessTokenOnly = accessTokenOnly;
            this.handleUnionValueChange(Type.ACCESS_TOKEN_ONLY, oldValue, this.accessTokenOnly);
            return this;
        }

        public final OpenIdConnectIdentityTokenConfigurationItem.Builder getIdentityTokenOnly() {
            return this.identityTokenOnly != null ? this.identityTokenOnly.toBuilder() : null;
        }

        public final void setIdentityTokenOnly(OpenIdConnectIdentityTokenConfigurationItem.BuilderImpl identityTokenOnly) {
            OpenIdConnectIdentityTokenConfigurationItem oldValue = this.identityTokenOnly;
            this.identityTokenOnly = identityTokenOnly != null ? identityTokenOnly.build() : null;
            this.handleUnionValueChange(Type.IDENTITY_TOKEN_ONLY, oldValue, this.identityTokenOnly);
        }

        @Override
        public final Builder identityTokenOnly(OpenIdConnectIdentityTokenConfigurationItem identityTokenOnly) {
            OpenIdConnectIdentityTokenConfigurationItem oldValue = this.identityTokenOnly;
            this.identityTokenOnly = identityTokenOnly;
            this.handleUnionValueChange(Type.IDENTITY_TOKEN_ONLY, oldValue, this.identityTokenOnly);
            return this;
        }

        public OpenIdConnectTokenSelectionItem build() {
            return new OpenIdConnectTokenSelectionItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenIdConnectTokenSelectionItem> {
        public Builder accessTokenOnly(OpenIdConnectAccessTokenConfigurationItem var1);

        default public Builder accessTokenOnly(Consumer<OpenIdConnectAccessTokenConfigurationItem.Builder> accessTokenOnly) {
            return this.accessTokenOnly((OpenIdConnectAccessTokenConfigurationItem)((OpenIdConnectAccessTokenConfigurationItem.Builder)OpenIdConnectAccessTokenConfigurationItem.builder().applyMutation(accessTokenOnly)).build());
        }

        public Builder identityTokenOnly(OpenIdConnectIdentityTokenConfigurationItem var1);

        default public Builder identityTokenOnly(Consumer<OpenIdConnectIdentityTokenConfigurationItem.Builder> identityTokenOnly) {
            return this.identityTokenOnly((OpenIdConnectIdentityTokenConfigurationItem)((OpenIdConnectIdentityTokenConfigurationItem.Builder)OpenIdConnectIdentityTokenConfigurationItem.builder().applyMutation(identityTokenOnly)).build());
        }
    }
}

