/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.verifiedpermissions.model.StaticPolicyDefinition;
import software.amazon.awssdk.services.verifiedpermissions.model.TemplateLinkedPolicyDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyDefinition> {
    private static final SdkField<StaticPolicyDefinition> STATIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("static").getter(PolicyDefinition.getter(PolicyDefinition::staticValue)).setter(PolicyDefinition.setter(Builder::staticValue)).constructor(StaticPolicyDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("static").build()}).build();
    private static final SdkField<TemplateLinkedPolicyDefinition> TEMPLATE_LINKED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("templateLinked").getter(PolicyDefinition.getter(PolicyDefinition::templateLinked)).setter(PolicyDefinition.setter(Builder::templateLinked)).constructor(TemplateLinkedPolicyDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateLinked").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_FIELD, TEMPLATE_LINKED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PolicyDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final StaticPolicyDefinition staticValue;
    private final TemplateLinkedPolicyDefinition templateLinked;
    private final Type type;

    private PolicyDefinition(BuilderImpl builder) {
        this.staticValue = builder.staticValue;
        this.templateLinked = builder.templateLinked;
        this.type = builder.type;
    }

    public final StaticPolicyDefinition staticValue() {
        return this.staticValue;
    }

    public final TemplateLinkedPolicyDefinition templateLinked() {
        return this.templateLinked;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.staticValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateLinked());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDefinition)) {
            return false;
        }
        PolicyDefinition other = (PolicyDefinition)obj;
        return Objects.equals(this.staticValue(), other.staticValue()) && Objects.equals(this.templateLinked(), other.templateLinked());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyDefinition").add("Static", (Object)this.staticValue()).add("TemplateLinked", (Object)this.templateLinked()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "static": {
                return Optional.ofNullable(clazz.cast(this.staticValue()));
            }
            case "templateLinked": {
                return Optional.ofNullable(clazz.cast(this.templateLinked()));
            }
        }
        return Optional.empty();
    }

    public static PolicyDefinition fromStaticValue(StaticPolicyDefinition staticValue) {
        return (PolicyDefinition)PolicyDefinition.builder().staticValue(staticValue).build();
    }

    public static PolicyDefinition fromStaticValue(Consumer<StaticPolicyDefinition.Builder> staticValue) {
        StaticPolicyDefinition.Builder builder = StaticPolicyDefinition.builder();
        staticValue.accept(builder);
        return PolicyDefinition.fromStaticValue((StaticPolicyDefinition)builder.build());
    }

    public static PolicyDefinition fromTemplateLinked(TemplateLinkedPolicyDefinition templateLinked) {
        return (PolicyDefinition)PolicyDefinition.builder().templateLinked(templateLinked).build();
    }

    public static PolicyDefinition fromTemplateLinked(Consumer<TemplateLinkedPolicyDefinition.Builder> templateLinked) {
        TemplateLinkedPolicyDefinition.Builder builder = TemplateLinkedPolicyDefinition.builder();
        templateLinked.accept(builder);
        return PolicyDefinition.fromTemplateLinked((TemplateLinkedPolicyDefinition)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("static", STATIC_FIELD);
        map.put("templateLinked", TEMPLATE_LINKED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyDefinition, T> g) {
        return obj -> g.apply((PolicyDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        STATIC,
        TEMPLATE_LINKED,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private StaticPolicyDefinition staticValue;
        private TemplateLinkedPolicyDefinition templateLinked;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyDefinition model) {
            this.staticValue(model.staticValue);
            this.templateLinked(model.templateLinked);
        }

        public final StaticPolicyDefinition.Builder getStaticValue() {
            return this.staticValue != null ? this.staticValue.toBuilder() : null;
        }

        public final void setStaticValue(StaticPolicyDefinition.BuilderImpl staticValue) {
            StaticPolicyDefinition oldValue = this.staticValue;
            this.staticValue = staticValue != null ? staticValue.build() : null;
            this.handleUnionValueChange(Type.STATIC, oldValue, this.staticValue);
        }

        @Override
        public final Builder staticValue(StaticPolicyDefinition staticValue) {
            StaticPolicyDefinition oldValue = this.staticValue;
            this.staticValue = staticValue;
            this.handleUnionValueChange(Type.STATIC, oldValue, this.staticValue);
            return this;
        }

        public final TemplateLinkedPolicyDefinition.Builder getTemplateLinked() {
            return this.templateLinked != null ? this.templateLinked.toBuilder() : null;
        }

        public final void setTemplateLinked(TemplateLinkedPolicyDefinition.BuilderImpl templateLinked) {
            TemplateLinkedPolicyDefinition oldValue = this.templateLinked;
            this.templateLinked = templateLinked != null ? templateLinked.build() : null;
            this.handleUnionValueChange(Type.TEMPLATE_LINKED, oldValue, this.templateLinked);
        }

        @Override
        public final Builder templateLinked(TemplateLinkedPolicyDefinition templateLinked) {
            TemplateLinkedPolicyDefinition oldValue = this.templateLinked;
            this.templateLinked = templateLinked;
            this.handleUnionValueChange(Type.TEMPLATE_LINKED, oldValue, this.templateLinked);
            return this;
        }

        public PolicyDefinition build() {
            return new PolicyDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyDefinition> {
        public Builder staticValue(StaticPolicyDefinition var1);

        default public Builder staticValue(Consumer<StaticPolicyDefinition.Builder> staticValue) {
            return this.staticValue((StaticPolicyDefinition)((StaticPolicyDefinition.Builder)StaticPolicyDefinition.builder().applyMutation(staticValue)).build());
        }

        public Builder templateLinked(TemplateLinkedPolicyDefinition var1);

        default public Builder templateLinked(Consumer<TemplateLinkedPolicyDefinition.Builder> templateLinked) {
            return this.templateLinked((TemplateLinkedPolicyDefinition)((TemplateLinkedPolicyDefinition.Builder)TemplateLinkedPolicyDefinition.builder().applyMutation(templateLinked)).build());
        }
    }
}

