/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;

public class ConnectionUtils {
    public static HostInfo copyWithAdditionalProps(HostInfo baseHostInfo, Map<String, String> additionalProps) {
        if (baseHostInfo == null || additionalProps == null) {
            return baseHostInfo;
        }
        ConnectionUrl urlContainer = ConnectionUrl.getConnectionUrlInstance(baseHostInfo.getDatabaseUrl(), new Properties());
        Map<String, String> originalProps = baseHostInfo.getHostProperties();
        HashMap<String, String> mergedProps = new HashMap<String, String>();
        mergedProps.putAll(originalProps);
        mergedProps.putAll(additionalProps);
        return new HostInfo(urlContainer, baseHostInfo.getHost(), baseHostInfo.getPort(), baseHostInfo.getUser(), baseHostInfo.getPassword(), mergedProps);
    }

    public static HostInfo copyWithAdditionalProps(HostInfo baseHostInfo, ConnectionUrl connectionUrl) {
        if (connectionUrl == null) {
            return baseHostInfo;
        }
        HostInfo mainHost = connectionUrl.getMainHost();
        if (baseHostInfo == null) {
            return mainHost;
        }
        return ConnectionUtils.copyWithAdditionalProps(baseHostInfo, mainHost);
    }

    public static HostInfo copyWithAdditionalProps(HostInfo baseHostInfo, HostInfo newHostInfo) {
        ConnectionUrl urlContainer = ConnectionUrl.getConnectionUrlInstance(baseHostInfo.getDatabaseUrl(), new Properties());
        Map<String, String> originalProps = baseHostInfo.getHostProperties();
        HashMap<String, String> mergedProps = new HashMap<String, String>();
        mergedProps.putAll(originalProps);
        mergedProps.putAll(newHostInfo.getHostProperties());
        return new HostInfo(urlContainer, baseHostInfo.getHost(), baseHostInfo.getPort(), newHostInfo.getUser(), newHostInfo.getPassword(), mergedProps);
    }
}

