/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.generator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.util.StringUtility;
import tk.mybatis.mapper.generator.file.GenerateByListTemplateFile;
import tk.mybatis.mapper.generator.file.GenerateByTemplateFile;
import tk.mybatis.mapper.generator.formatter.ListTemplateFormatter;
import tk.mybatis.mapper.generator.formatter.TemplateFormatter;
import tk.mybatis.mapper.generator.model.TableClass;
import tk.mybatis.mapper.generator.model.TableColumnBuilder;

public class TemplateFilePlugin
extends PluginAdapter {
    public static final String DEFAULT_TEMPLATEFORMATTER = "tk.mybatis.mapper.generator.formatter.FreemarkerTemplateFormatter";
    private String singleMode;
    private String targetProject;
    private String targetPackage;
    private String templatePath;
    private String templateContent;
    private String fileName;
    private Object templateFormatter;
    private String templateFormatterClass;
    private Set<TableClass> cacheTables;
    private String encoding;

    public static Field convertToJavaBeansField(IntrospectedColumn introspectedColumn) {
        FullyQualifiedJavaType fqjt = introspectedColumn.getFullyQualifiedJavaType();
        String property = introspectedColumn.getJavaProperty();
        Field field = new Field(property, fqjt);
        field.setVisibility(JavaVisibility.PRIVATE);
        return field;
    }

    protected String read(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, this.encoding));
        StringBuffer stringBuffer = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            stringBuffer.append(line);
            line = reader.readLine();
            if (line == null) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean validate(List<String> warnings) {
        boolean right = true;
        if (!StringUtility.stringHasValue((String)this.fileName)) {
            warnings.add("\u6ca1\u6709\u914d\u7f6e \"fileName\" \u6587\u4ef6\u540d\u6a21\u677f\uff0c\u56e0\u6b64\u4e0d\u4f1a\u751f\u6210\u4efb\u4f55\u989d\u5916\u4ee3\u7801!");
            right = false;
        }
        if (!StringUtility.stringHasValue((String)this.templatePath)) {
            warnings.add("\u6ca1\u6709\u914d\u7f6e \"templatePath\" \u6a21\u677f\u8def\u5f84\uff0c\u56e0\u6b64\u4e0d\u4f1a\u751f\u6210\u4efb\u4f55\u989d\u5916\u4ee3\u7801!");
            right = false;
        } else {
            try {
                URL resourceUrl = null;
                try {
                    resourceUrl = ObjectFactory.getResource((String)this.templatePath);
                }
                catch (Exception e) {
                    warnings.add("\u672c\u5730\u52a0\u8f7d\"templatePath\" \u6a21\u677f\u8def\u5f84\u5931\u8d25\uff0c\u5c1d\u8bd5 URL \u65b9\u5f0f\u83b7\u53d6!");
                }
                if (resourceUrl == null) {
                    resourceUrl = new URL(this.templatePath);
                }
                InputStream inputStream = resourceUrl.openConnection().getInputStream();
                this.templateContent = this.read(inputStream);
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                warnings.add("\u8bfb\u53d6\u6a21\u677f\u6587\u4ef6\u51fa\u9519: " + e.getMessage());
                right = false;
            }
        }
        if (!StringUtility.stringHasValue((String)this.templateFormatterClass)) {
            this.templateFormatterClass = DEFAULT_TEMPLATEFORMATTER;
            warnings.add("\u6ca1\u6709\u914d\u7f6e \"templateFormatterClass\" \u6a21\u677f\u5904\u7406\u5668\uff0c\u4f7f\u7528\u9ed8\u8ba4\u7684\u5904\u7406\u5668!");
        }
        try {
            this.templateFormatter = Class.forName(this.templateFormatterClass).newInstance();
        }
        catch (Exception e) {
            warnings.add("\u521d\u59cb\u5316 templateFormatter \u51fa\u9519:" + e.getMessage());
            right = false;
        }
        if (!right) {
            return false;
        }
        int errorCount = 0;
        if (!StringUtility.stringHasValue((String)this.targetProject)) {
            ++errorCount;
            warnings.add("\u6ca1\u6709\u914d\u7f6e \"targetProject\" \u8def\u5f84!");
        }
        if (!StringUtility.stringHasValue((String)this.targetPackage)) {
            ++errorCount;
            warnings.add("\u6ca1\u6709\u914d\u7f6e \"targetPackage\" \u8def\u5f84!");
        }
        if (errorCount >= 2) {
            warnings.add("\u7531\u4e8e\u6ca1\u6709\u914d\u7f6e\u4efb\u4f55\u6709\u6548\u8def\u5f84\uff0c\u4e0d\u4f1a\u751f\u6210\u4efb\u4f55\u989d\u5916\u4ee3\u7801!");
            return false;
        }
        return true;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        ArrayList<GeneratedJavaFile> list = new ArrayList<GeneratedJavaFile>();
        TableClass tableClass = TableColumnBuilder.build(introspectedTable);
        if ("TRUE".equalsIgnoreCase(this.singleMode)) {
            list.add(new GenerateByTemplateFile(tableClass, (TemplateFormatter)this.templateFormatter, this.properties, this.targetProject, this.targetPackage, this.fileName, this.templateContent));
        } else {
            this.cacheTables.add(tableClass);
        }
        return list;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles() {
        ArrayList<GeneratedJavaFile> list = new ArrayList<GeneratedJavaFile>();
        if (this.cacheTables != null && this.cacheTables.size() > 0) {
            list.add(new GenerateByListTemplateFile(this.cacheTables, (ListTemplateFormatter)this.templateFormatter, this.properties, this.targetProject, this.targetPackage, this.fileName, this.templateContent));
        }
        return list;
    }

    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.singleMode = properties.getProperty("singleMode", "true");
        if (!"TRUE".equalsIgnoreCase(this.singleMode)) {
            this.cacheTables = new LinkedHashSet<TableClass>();
        }
        this.targetProject = properties.getProperty("targetProject");
        this.targetPackage = properties.getProperty("targetPackage");
        this.templatePath = properties.getProperty("templatePath");
        this.fileName = properties.getProperty("fileName");
        this.templateFormatterClass = properties.getProperty("templateFormatter");
        this.encoding = properties.getProperty("encoding", "UTF-8");
    }
}

