/*
 * Decompiled with CFR 0.152.
 */
package top.dogtcc.core;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.PropertySource;
import top.dogtcc.core.common.DefaultBytePackConvert;
import top.dogtcc.core.common.IBytePackConvert;
import top.dogtcc.core.log.AbstractErrorLog;
import top.dogtcc.core.log.AbstractHistoryLog;
import top.dogtcc.core.log.IErrorLog;
import top.dogtcc.core.log.IHistoryLog;

@Configuration
@EnableAspectJAutoProxy
@PropertySource(value={"classpath:application.properties"})
@ConfigurationProperties(prefix="dog.application")
public class ApplicationAutoConfig {
    @Value(value="${applicationname:noname}")
    private String applicationname;

    public String getApplicationname() {
        return this.applicationname;
    }

    public void setApplicationname(String applicationname) {
        this.applicationname = applicationname;
    }

    @Bean
    @ConditionalOnMissingBean(value={IHistoryLog.class})
    public IHistoryLog historyLog() {
        return new AbstractHistoryLog(){};
    }

    @Bean
    @ConditionalOnMissingBean(value={IBytePackConvert.class})
    public IBytePackConvert objectBytesConvert() {
        return new DefaultBytePackConvert();
    }

    @Bean
    @ConditionalOnMissingBean(value={IErrorLog.class})
    public IErrorLog errorLog() {
        return new AbstractErrorLog(){};
    }
}

