/*
 * Decompiled with CFR 0.152.
 */
package top.dogtcc.core.annotation;

import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import top.dogtcc.core.annotation.ITccHandler;
import top.dogtcc.core.common.ThreadManager;
import top.dogtcc.core.entry.DogCall;
import top.dogtcc.core.entry.DogTcc;
import top.dogtcc.core.entry.TccContext;
import top.dogtcc.core.entry.TccLock;
import top.dogtcc.core.jms.IContextManager;
import top.dogtcc.core.jms.ILockPool;

public abstract class TccHandler
implements ITccHandler {
    private static Logger logger = Logger.getLogger(TccHandler.class);
    @Autowired
    private ILockPool lockPool;
    @Autowired
    private IContextManager iContextManager;

    @Override
    public void before(DogTcc tcc, DogCall call) {
    }

    @Override
    public void exceptionHandler(DogTcc tcc, DogCall call, Exception e) throws Exception {
    }

    public final void putDatas(Map<Object, Object> datas) throws Exception {
        if (ThreadManager.inTcc()) {
            ThreadManager.getContext().getContext().putAll(datas);
            this.iContextManager.setContext(ThreadManager.currentTcc(), ThreadManager.currentCall(), ThreadManager.getContext());
        }
    }

    public final Set<TccLock> lock(Set<TccLock> locks) throws Exception {
        if (ThreadManager.inTcc()) {
            return this.lockPool.lock(ThreadManager.currentTcc(), ThreadManager.currentCall(), locks);
        }
        return null;
    }

    @Override
    public void cancel(TccContext context, DogTcc tcc, DogCall call) {
        logger.info((Object)("cancel call: " + call));
    }

    @Override
    public void confirm(TccContext context, DogTcc tcc, DogCall call) {
        logger.info((Object)("confirm call: " + call));
    }
}

