/*
 * Decompiled with CFR 0.152.
 */
package top.dogtcc.core.aop;

import java.util.UUID;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import top.dogtcc.core.ApplicationAutoConfig;
import top.dogtcc.core.annotation.DogCallAnnotation;
import top.dogtcc.core.annotation.ITccHandler;
import top.dogtcc.core.aop.ITccServer;
import top.dogtcc.core.common.Pair;
import top.dogtcc.core.common.ThreadManager;
import top.dogtcc.core.entry.DogCall;
import top.dogtcc.core.entry.DogTcc;
import top.dogtcc.core.entry.TccContext;
import top.dogtcc.core.util.SpringContextUtil;

@Component
@Aspect
@Order(value=-1)
public class DogCallAop {
    private static Logger logger = Logger.getLogger(DogCallAop.class);
    @Autowired
    ApplicationAutoConfig config;
    @Autowired
    ITccServer server;

    @Around(value="@annotation(top.dogtcc.core.annotation.DogCallAnnotation)  && @annotation(ad) ")
    public Object doAroundtransaction(ProceedingJoinPoint pjp, DogCallAnnotation ad) throws Throwable {
        String callName = ad.Name().equals("") ? pjp.getSignature().toString().replace('.', '_').replace(',', '_').replace(' ', '_').replace('(', '_').replace(')', '_') : ad.Name();
        Object result = null;
        ITccHandler tccHandler = null;
        DogTcc transaction = null;
        DogCall localcaller = null;
        try {
            transaction = ThreadManager.currentTcc();
            if (transaction != null) {
                logger.info((Object)("\u672c\u5730\u4e8b\u52a1\u8c03\u7528\uff1a" + transaction.toString() + ": callname:" + callName));
                localcaller = new DogCall(callName + UUID.randomUUID().toString(), this.config.getApplicationname());
                TccContext tccContext = new TccContext(ad.TccHandlerClass().getName(), pjp.getArgs());
                ThreadManager.setCall(new Pair<DogCall, TccContext>(localcaller, tccContext));
                this.server.tccCall(transaction, localcaller, tccContext);
                Class<?> tccHandlerClass = Class.forName(tccContext.getClassName());
                tccHandler = (ITccHandler)SpringContextUtil.getApplicationContext().getBean(tccHandlerClass);
                tccHandler.before(transaction, localcaller);
            } else {
                logger.info((Object)("\u975e\u672c\u5730\u4e8b\u52a1\u8c03\u7528 callname:" + callName));
            }
            result = pjp.proceed();
        }
        catch (Exception e) {
            if (tccHandler != null) {
                tccHandler.exceptionHandler(transaction, localcaller, e);
            }
            logger.error((Object)("\u672c\u5730\u8c03\u7528\u5931\u8d25:" + e));
            throw e;
        }
        finally {
            ThreadManager.clearCall();
        }
        return result;
    }
}

