/*
 * Decompiled with CFR 0.152.
 */
package top.dogtcc.core.aop;

import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import top.dogtcc.core.ApplicationAutoConfig;
import top.dogtcc.core.annotation.DogTccAnnotation;
import top.dogtcc.core.aop.ITccServer;
import top.dogtcc.core.common.ThreadManager;
import top.dogtcc.core.entry.DogTcc;

@Component
@Aspect
@Order(value=-2)
public class DogTccAop {
    private static Logger logger = Logger.getLogger(DogTccAop.class);
    @Autowired
    ITccServer server;
    @Autowired
    private ApplicationAutoConfig applicationAutoConfig;

    @Around(value="@annotation(top.dogtcc.core.annotation.DogTccAnnotation)  && @annotation(ad) ")
    public Object doAroundtransaction(ProceedingJoinPoint pjp, DogTccAnnotation ad) throws Throwable {
        String tccName;
        String string = tccName = ad.Name().equals("") ? pjp.getSignature().toString().replace('.', '_').replace(',', '_').replace(' ', '_').replace('(', '_').replace(')', '_') : ad.Name();
        if (ThreadManager.inTcc()) {
            return pjp.proceed();
        }
        try {
            Object object;
            DogTcc transaction = new DogTcc(this.applicationAutoConfig.getApplicationname(), tccName);
            logger.info((Object)("createTransaction:" + transaction.toString()));
            ThreadManager.setTcc(transaction);
            Object object2 = object = this.server.tccTry(transaction, pjp);
            return object2;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ThreadManager.clearTcc();
        }
    }
}

