/*
 * Decompiled with CFR 0.152.
 */
package top.dogtcc.core.aop;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.log4j.Logger;
import top.dogtcc.core.annotation.ITccHandler;
import top.dogtcc.core.common.ContextBuffer;
import top.dogtcc.core.common.IBytePackConvert;
import top.dogtcc.core.common.Pair;
import top.dogtcc.core.entry.DogCall;
import top.dogtcc.core.entry.DogTcc;
import top.dogtcc.core.entry.DogTccStatus;
import top.dogtcc.core.entry.TccContext;
import top.dogtcc.core.event.CallNodeOfflineEvent;
import top.dogtcc.core.event.TccAchievementEvent;
import top.dogtcc.core.event.TccNodeOfflineEvent;
import top.dogtcc.core.event.TccTryAchievementEvent;
import top.dogtcc.core.jms.IBroker;
import top.dogtcc.core.jms.exception.ConnectException;
import top.dogtcc.core.jms.exception.TccNotExsitException;
import top.dogtcc.core.jmx.Error;
import top.dogtcc.core.jmx.ErrorLogMXBean;
import top.dogtcc.core.listener.ITccListener;
import top.dogtcc.core.log.IErrorLog;
import top.dogtcc.core.log.IHistoryLog;
import top.dogtcc.core.util.SpringContextUtil;

class TccListener
implements ErrorLogMXBean,
ITccListener {
    List<Error> fails = new ArrayList<Error>();
    private static Logger logger = Logger.getLogger(TccListener.class);
    private IBytePackConvert convert;
    private IBroker message;
    private ContextBuffer contextBuffer;
    private IErrorLog confirmAndCancelErrorLog;
    private Executor executor;
    private IHistoryLog historylog;

    @Override
    public List<Error> fails() {
        return this.fails;
    }

    public TccListener(IBroker iMessage, IBytePackConvert convert, IErrorLog confirmAndCancelErrorLog, ContextBuffer contextBuffer, IHistoryLog historylog, Executor executor) {
        this.message = iMessage;
        this.convert = convert;
        this.confirmAndCancelErrorLog = confirmAndCancelErrorLog;
        this.contextBuffer = contextBuffer;
        this.executor = executor;
        this.historylog = historylog;
    }

    @Override
    public void onTccEvent(TccAchievementEvent var1) throws TccNotExsitException, ConnectException, InterruptedException {
        logger.info((Object)("TccAchievementEvent" + var1.getSource()));
        this.message.clearTcc(var1.getSource());
        this.historylog.log(var1.getSource());
    }

    @Override
    public void onTccEvent(TccNodeOfflineEvent var1) throws TccNotExsitException, ConnectException, InterruptedException {
        logger.info((Object)("TccNodeOfflineEvent" + var1.getSource()));
        if (var1.getSource().getStatus().equals(DogTccStatus.TRY)) {
            this.message.cancelTry(var1.getSource());
            this.message.addTccAchievementListener(var1.getSource(), this);
        } else {
            this.message.addTccAchievementListener(var1.getSource(), this);
        }
    }

    @Override
    public void onCallEvent(CallNodeOfflineEvent var1) throws IllegalStateException, ConnectException, InterruptedException {
        logger.info((Object)("CallNodeOfflineEvent" + var1.getSource()));
        List<Pair<DogCall, byte[]>> offlineDogCalls = var1.callPairs();
        for (Pair<DogCall, byte[]> e : offlineDogCalls) {
            this.contextBuffer.put(var1.getTcc(), e.getKey(), this.convert.byteArrayToObject(e.getValue()));
        }
        try {
            this.message.addTryAchievementListener(var1.getTcc(), this);
        }
        catch (TccNotExsitException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void onTccEvent(TccTryAchievementEvent var1) {
        logger.info((Object)("TccTryAchievementEvent" + var1.getSource()));
        DogTcc transaction = var1.getSource();
        List<Pair<DogCall, TccContext>> calls = this.contextBuffer.find(transaction);
        this.contextBuffer.clear(transaction);
        if (transaction.getStatus().equals(DogTccStatus.CONFIRM) || transaction.getStatus().equals(DogTccStatus.CANCEL)) {
            for (Pair<DogCall, TccContext> e : calls) {
                this.tryCompleteHandlerExecutor(transaction, e.getKey(), e.getValue());
            }
        } else {
            throw new IllegalStateException();
        }
    }

    protected void tryCompleteHandlerExecutor(final DogTcc tran, final DogCall call, final TccContext context) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Class<?> rollbackClass = Class.forName(context.getClassName());
                    ITccHandler rollback = (ITccHandler)SpringContextUtil.getApplicationContext().getBean(rollbackClass);
                    if (tran.isSuccess()) {
                        rollback.confirm(context, tran, call);
                    } else {
                        if (TccListener.this.fails.size() == 1024) {
                            TccListener.this.fails.clear();
                        }
                        String errorString = "";
                        for (Object arg : context.getArgs()) {
                            errorString = errorString + arg.getClass().getName() + "  " + arg.toString() + "  ";
                        }
                        TccListener.this.fails.add(new Error(tran, call, context.getLockList(), errorString));
                        rollback.cancel(context, tran, call);
                    }
                    TccListener.this.message.confirmCall(tran, call, context);
                }
                catch (Exception f) {
                    logger.error((Object)f);
                    if (tran.isSuccess()) {
                        TccListener.this.confirmAndCancelErrorLog.confirmError(tran, call, context);
                    }
                    TccListener.this.confirmAndCancelErrorLog.cancelError(tran, call, context);
                }
            }
        });
    }
}

