/*
 * Decompiled with CFR 0.152.
 */
package top.dogtcc.core.aop;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.stereotype.Component;
import top.dogtcc.core.ApplicationAutoConfig;
import top.dogtcc.core.aop.ITccServer;
import top.dogtcc.core.aop.TccListener;
import top.dogtcc.core.common.ContextBuffer;
import top.dogtcc.core.common.IBytePackConvert;
import top.dogtcc.core.entry.DogCall;
import top.dogtcc.core.entry.DogTcc;
import top.dogtcc.core.entry.TccContext;
import top.dogtcc.core.jms.IBroker;
import top.dogtcc.core.jms.exception.CallExsitException;
import top.dogtcc.core.jms.exception.ConnectException;
import top.dogtcc.core.jms.exception.LockExsitException;
import top.dogtcc.core.jms.exception.TccNotExsitException;
import top.dogtcc.core.jmx.TccServerMXBean;
import top.dogtcc.core.listener.ITccListener;
import top.dogtcc.core.log.IErrorLog;
import top.dogtcc.core.log.IHistoryLog;

@Component
class TccServer
implements TccServerMXBean,
ITccServer {
    private static Logger logger = Logger.getLogger(TccServer.class);
    private ApplicationAutoConfig autoConfig;
    private ITccListener listener;
    private ContextBuffer contextBuffer = new ContextBuffer();
    private IBroker message;
    ExecutorService rollbackExecutor;
    private long tccNum = 0L;
    private long callNum = 0L;
    private long tccErrorNum = 0L;
    private List<DogTcc> faillist = new ArrayList<DogTcc>();

    public TccServer(ApplicationAutoConfig autoConfig, IBroker iMessage, IBytePackConvert convert, IErrorLog errorLog, IHistoryLog historylog) {
        this.message = iMessage;
        this.autoConfig = autoConfig;
        this.rollbackExecutor = Executors.newCachedThreadPool();
        this.listener = new TccListener(iMessage, convert, errorLog, this.contextBuffer, historylog, this.rollbackExecutor);
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName("top.dogtcc.core.aop:type=ITccListener");
            mbs.registerMBean(this.listener, name);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    public Object tccTry(DogTcc tran, ProceedingJoinPoint point) throws Throwable {
        ++this.tccNum;
        try {
            this.message.registerTcc(tran);
            logger.info((Object)("TCC\u8fdc\u7a0b\u8c03\u7528:" + tran));
            Object result = point.proceed();
            logger.info((Object)("TCC\u8fd4\u56de:" + tran));
            this.message.confirmTry(tran);
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            this.logfails(tran);
            ++this.tccErrorNum;
            logger.error((Object)("TCC\u62a5\u9519:" + tran));
            logger.error((Object)e);
            this.message.cancelTry(tran);
            throw e;
        }
        finally {
            this.message.addTccAchievementListener(tran, this.listener);
        }
    }

    @Override
    public void tccCall(DogTcc transaction, DogCall call, TccContext context) throws LockExsitException, TccNotExsitException, CallExsitException, ConnectException, InterruptedException {
        ++this.callNum;
        this.message.registerCall(transaction, call, context);
        this.contextBuffer.put(transaction, call, context);
        this.message.addTryAchievementListener(transaction, this.listener);
        logger.info((Object)("tccCall:" + transaction));
    }

    @Override
    public void connect() throws ConnectException, InterruptedException {
        this.message.connect();
        this.message.addCallOfflineListener(this.listener);
        this.message.addTccOfflineListner(this.listener);
        logger.info((Object)("application:" + this.autoConfig.getApplicationname() + ": started"));
    }

    @Override
    public void close() throws IOException {
        this.message.close();
        this.rollbackExecutor.shutdown();
    }

    private void logfails(DogTcc failTcc) {
        if (this.faillist.size() == 1024) {
            this.faillist.clear();
        }
        this.faillist.add(failTcc);
    }

    @Override
    public List<DogTcc> failsTcc() {
        return this.faillist;
    }

    @Override
    public long getTccNum() {
        return this.tccNum;
    }

    @Override
    public long getCallNum() {
        return this.callNum;
    }

    @Override
    public long getTccErrorNum() {
        return this.tccErrorNum;
    }
}

