/*
 * Decompiled with CFR 0.152.
 */
package top.dogtcc.core.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import top.dogtcc.core.common.Pair;
import top.dogtcc.core.entry.DogCall;
import top.dogtcc.core.entry.DogTcc;
import top.dogtcc.core.entry.TccContext;

public class ContextBuffer {
    private final Map<DogTcc, List<Pair<DogCall, TccContext>>> buffer = new ConcurrentHashMap<DogTcc, List<Pair<DogCall, TccContext>>>();
    private final List<Pair<DogCall, TccContext>> nomodify = Collections.unmodifiableList(new ArrayList());

    public void put(DogTcc tranPath, DogCall server, TccContext context) {
        if (this.buffer.containsKey(tranPath)) {
            this.buffer.get(tranPath).add(new Pair<DogCall, TccContext>(server, context));
        } else {
            ArrayList<Pair<DogCall, TccContext>> servers = new ArrayList<Pair<DogCall, TccContext>>();
            servers.add(new Pair<DogCall, TccContext>(server, context));
            this.buffer.put(tranPath, servers);
        }
    }

    public List<Pair<DogCall, TccContext>> find(DogTcc tranPath) {
        return this.buffer.getOrDefault(tranPath, this.nomodify);
    }

    public void clear(DogTcc tranPath) {
        this.buffer.remove(tranPath);
    }
}

