/*
 * Decompiled with CFR 0.152.
 */
package top.dogtcc.core.common;

import top.dogtcc.core.common.Pair;
import top.dogtcc.core.entry.DogCall;
import top.dogtcc.core.entry.DogTcc;
import top.dogtcc.core.entry.TccContext;

public class ThreadManager {
    private static final ThreadLocal<Pair<DogTcc, Pair<DogCall, TccContext>>> transactionWithThread = new ThreadLocal(){

        protected Object initialValue() {
            return new Pair<Object, Pair<Object, Object>>(null, new Pair<Object, Object>(null, null));
        }
    };

    public static void clearTcc() {
        transactionWithThread.remove();
    }

    public static void clearCall() {
        ThreadManager.setCall(new Pair<Object, Object>(null, null));
    }

    public static void setTcc(DogTcc tran) {
        transactionWithThread.set(new Pair<DogTcc, Pair<Object, Object>>(tran, new Pair<Object, Object>(null, null)));
    }

    public static void setCall(Pair<DogCall, TccContext> callAndContext) {
        Pair<DogTcc, Pair<DogCall, TccContext>> newPair = new Pair<DogTcc, Pair<DogCall, TccContext>>(transactionWithThread.get().getKey(), callAndContext);
        transactionWithThread.remove();
        transactionWithThread.set(newPair);
    }

    public static TccContext getContext() {
        return transactionWithThread.get().getValue().getValue();
    }

    public static DogCall currentCall() {
        return transactionWithThread.get().getValue().getKey();
    }

    public static DogTcc currentTcc() {
        return transactionWithThread.get().getKey();
    }

    public static boolean inTcc() {
        return ThreadManager.currentTcc() != null;
    }
}

