/*
 * Decompiled with CFR 0.152.
 */
package top.dogtcc.core.entry;

import java.io.Serializable;
import java.util.UUID;
import top.dogtcc.core.entry.DogTccStatus;

public class DogTcc
implements Serializable {
    public static final String NameHeader = "DogName";
    public static final String KeyHeader = "DogKey";
    public static final String ApplicationHeader = "DogApplication";
    private String application;
    private String key;
    private DogTccStatus status;
    private String name;

    public String getUnique() {
        return this.application + this.key + this.name;
    }

    public int hashCode() {
        String hashStr = this.application + this.key + this.name;
        return hashStr.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DogTcc) {
            DogTcc other = (DogTcc)obj;
            return this.application.equals(other.application) && this.name.equals(other.name) && this.key.equals(other.key);
        }
        return false;
    }

    public String toString() {
        return "[DogTran:  application:" + this.application + "    Name:" + this.name + "   key:" + this.key + " status" + this.status + "]";
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public DogTccStatus getStatus() {
        return this.status;
    }

    public void setStatus(DogTccStatus status) {
        this.status = status;
    }

    public DogTcc(String application, String name) {
        this.application = application;
        this.name = name;
        this.key = UUID.randomUUID().toString();
        this.status = DogTccStatus.TRY;
    }

    public DogTcc(String application, String name, String key) {
        this.application = application;
        this.name = name;
        this.key = key;
        this.status = DogTccStatus.TRY;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSuccess() {
        return this.getStatus().equals(DogTccStatus.CONFIRM);
    }
}

