/*
 * Decompiled with CFR 0.152.
 */
package top.dogtcc.database.core;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import top.dogtcc.core.annotation.TccHandler;
import top.dogtcc.core.entry.DogCall;
import top.dogtcc.core.entry.DogTcc;
import top.dogtcc.core.entry.TccContext;
import top.dogtcc.core.entry.TccLock;
import top.dogtcc.core.util.SpringContextUtil;
import top.dogtcc.database.core.ClazzInfo;
import top.dogtcc.database.core.annotation.OperationType;
import top.dogtcc.database.core.buffer.IDataBuffer;

public class DbTccHandler
extends TccHandler {
    private static Logger logger = Logger.getLogger(DbTccHandler.class);
    private IDataBuffer dataBuffer = (IDataBuffer)SpringContextUtil.getApplicationContext().getBean(IDataBuffer.class);

    public void exceptionHandler(DogTcc tcc, DogCall call, Exception e) throws Exception {
        super.exceptionHandler(tcc, call, e);
    }

    public void cancel(TccContext context, DogTcc tcc, DogCall call) {
        super.cancel(context, tcc, call);
        Map locks = context.getContext();
        try {
            for (Map.Entry values : locks.entrySet()) {
                ClazzInfo clazzInfo = (ClazzInfo)values.getKey();
                Object repositoryBean = SpringContextUtil.getApplicationContext().getBean(clazzInfo.getClazz());
                Set tccLocks = (Set)values.getValue();
                Method method = clazzInfo.method(repositoryBean);
                for (TccLock e : tccLocks) {
                    Object bufferedData = this.dataBuffer.getData(e);
                    method.setAccessible(true);
                    if (clazzInfo.getOperationType().equals(OperationType.INSERTNEWDATA)) {
                        method.invoke(repositoryBean, (Object[])bufferedData);
                    } else {
                        method.invoke(repositoryBean, bufferedData);
                    }
                    logger.info((Object)("Cancel method:" + method.getName()));
                    logger.info((Object)("Cancel parameter:" + bufferedData));
                    this.dataBuffer.clearData(e);
                }
            }
        }
        catch (Exception g) {
            logger.error((Object)g);
        }
    }

    public void confirm(TccContext context, DogTcc tcc, DogCall call) {
        super.confirm(context, tcc, call);
        for (TccLock lock : context.getLockList()) {
            this.dataBuffer.clearData(lock);
        }
    }

    public void before(DogTcc tcc, DogCall call) {
        super.before(tcc, call);
    }
}

